/*
 * Decompiled with CFR 0.152.
 */
package com.dantaeusb.zetter.client.gui;

import com.dantaeusb.zetter.client.gui.painting.CanvasWidget;
import com.dantaeusb.zetter.client.gui.painting.ColorCodeWidget;
import com.dantaeusb.zetter.client.gui.painting.PaletteWidget;
import com.dantaeusb.zetter.client.gui.painting.SlidersWidget;
import com.dantaeusb.zetter.client.gui.painting.ToolsWidget;
import com.dantaeusb.zetter.container.EaselContainer;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class PaintingScreen
extends ContainerScreen<EaselContainer>
implements IContainerListener {
    private static final ResourceLocation PAINTING_RESOURCE = new ResourceLocation("zetter", "textures/gui/painting.png");
    private float sinceLastTick = 0.0f;
    private ToolsWidget toolsWidget;
    private CanvasWidget canvasWidget;
    private PaletteWidget paletteWidget;
    private ColorCodeWidget colorCodeWidget;
    private SlidersWidget slidersWidget;

    public PaintingScreen(EaselContainer paintingContainer, PlayerInventory playerInventory, ITextComponent title) {
        super((Container)paintingContainer, playerInventory, title);
        this.field_146999_f = 176;
        this.field_147000_g = 185;
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        int CANVAS_POSITION_X = 48;
        int CANVAS_POSITION_Y = 9;
        int TOOLS_POSITION_X = 7;
        int TOOLS_POSITION_Y = 8;
        int PALETTE_POSITION_X = 147;
        int PALETTE_POSITION_Y = 9;
        int SLIDER_POSITION_X = 13;
        int SLIDER_OFFSET_Y = 117;
        int TEXTBOX_POSITION_X = 47;
        int TEXTBOX_POSITION_Y = 95;
        this.canvasWidget = new CanvasWidget(this, this.getGuiLeft() + 48, this.getGuiTop() + 9);
        this.paletteWidget = new PaletteWidget(this, this.getGuiLeft() + 147, this.getGuiTop() + 9);
        this.toolsWidget = new ToolsWidget(this, this.getGuiLeft() + 7, this.getGuiTop() + 8);
        this.slidersWidget = new SlidersWidget(this, this.getGuiLeft() + 13, this.getGuiTop() + 117);
        this.colorCodeWidget = new ColorCodeWidget(this, this.getGuiLeft() + 47, this.getGuiTop() + 95);
        this.colorCodeWidget.initFields();
        this.field_230705_e_.add(this.canvasWidget);
        this.field_230705_e_.add(this.paletteWidget);
        this.field_230705_e_.add(this.toolsWidget);
        this.field_230705_e_.add(this.slidersWidget);
        this.field_230705_e_.add(this.colorCodeWidget);
        ((EaselContainer)this.func_212873_a_()).setFirstLoadNotification(this::firstLoadUpdate);
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        ((EaselContainer)this.field_147002_h).func_75132_a(this);
    }

    public void func_231164_f_() {
        super.func_231164_f_();
    }

    public void addChildren(IGuiEventListener eventListener) {
        this.field_230705_e_.add(eventListener);
    }

    public FontRenderer getFont() {
        return this.field_230712_o_;
    }

    public boolean isCanvasAvailable() {
        return ((EaselContainer)this.field_147002_h).isCanvasAvailable();
    }

    public boolean isPaletteAvailable() {
        return ((EaselContainer)this.field_147002_h).isPaletteAvailable();
    }

    public int getColorAt(int pixelIndex) {
        return ((EaselContainer)this.field_147002_h).getCanvasData().getColorAt(pixelIndex);
    }

    public int getColorAt(int pixelX, int pixelY) {
        return ((EaselContainer)this.field_147002_h).getCanvasData().getColorAt(pixelX, pixelY);
    }

    public int getCurrentColor() {
        return this.getPaletteColor(this.paletteWidget.getCurrentPaletteSlot());
    }

    public int getPaletteColor(int slot) {
        return ((EaselContainer)this.field_147002_h).getPaletteColor(slot);
    }

    public void firstLoadUpdate() {
        this.updateSlidersWithCurrentColor();
    }

    public void updateCurrentPaletteColor(int color) {
        ((EaselContainer)this.field_147002_h).setPaletteColor(this.paletteWidget.getCurrentPaletteSlot(), color);
        this.slidersWidget.updateSlidersWithCurrentColor();
    }

    public void pushPaletteUpdateColor() {
        ((EaselContainer)this.field_147002_h).sendPaletteUpdatePacket(this.paletteWidget.getCurrentPaletteSlot(), this.getCurrentColor());
    }

    public void updateSlidersWithCurrentColor() {
        this.slidersWidget.updateSlidersWithCurrentColor();
    }

    public void useTool(int canvasX, int canvasY) {
        switch (this.toolsWidget.getCurrentTool()) {
            case PENCIL: {
                ((EaselContainer)this.func_212873_a_()).writePixelOnCanvasClientSide(canvasX, canvasY, this.getCurrentColor(), this.field_213127_e.field_70458_d.func_110124_au());
                break;
            }
            case EYEDROPPER: {
                ((EaselContainer)this.func_212873_a_()).eyedropper(this.paletteWidget.getCurrentPaletteSlot(), canvasX, canvasY);
                this.updateSlidersWithCurrentColor();
                break;
            }
            case BUCKET: {
                ((EaselContainer)this.func_212873_a_()).bucket(canvasX, canvasY, this.getCurrentColor());
            }
        }
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(matrixStack, mouseX, mouseY);
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        ((EaselContainer)this.func_212873_a_()).tick();
        this.colorCodeWidget.tick();
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int x, int y) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(PAINTING_RESOURCE);
        this.func_238474_b_(matrixStack, this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        this.toolsWidget.render(matrixStack);
        this.canvasWidget.render(matrixStack);
        this.paletteWidget.render(matrixStack);
        this.slidersWidget.render(matrixStack);
        this.colorCodeWidget.func_230430_a_(matrixStack, x, y, partialTicks);
    }

    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.field_230706_i_.field_71439_g.func_71053_j();
            return true;
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        this.canvasWidget.func_231045_a_(mouseX, mouseY, button, dragX, dragY);
        this.slidersWidget.func_231045_a_(mouseX, mouseY, button, dragX, dragY);
        return super.func_231045_a_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        this.canvasWidget.func_231048_c_(mouseX, mouseY, button);
        this.slidersWidget.func_231048_c_(mouseX, mouseY, button);
        return super.func_231048_c_(mouseX, mouseY, button);
    }

    public static boolean isInRect(int x, int y, int xSize, int ySize, int mouseX, int mouseY) {
        return mouseX >= x && mouseX <= x + xSize && mouseY >= y && mouseY <= y + ySize;
    }

    public void func_71110_a(Container containerToSend, NonNullList<ItemStack> itemsList) {
    }

    public void func_71112_a(Container containerIn, int varToUpdate, int newValue) {
    }

    public void func_71111_a(Container containerToSend, int slotInd, ItemStack stack) {
    }
}

