/*
 * Decompiled with CFR 0.152.
 */
package com.dantaeusb.zetter.client.gui.artisttable;

import com.dantaeusb.zetter.canvastracker.ICanvasTracker;
import com.dantaeusb.zetter.client.gui.ArtistTableScreen;
import com.dantaeusb.zetter.client.gui.artisttable.AbstractArtistTableWidget;
import com.dantaeusb.zetter.client.renderer.CanvasRenderer;
import com.dantaeusb.zetter.container.ArtistTableContainer;
import com.dantaeusb.zetter.core.Helper;
import com.dantaeusb.zetter.storage.CanvasData;
import com.dantaeusb.zetter.storage.DummyCanvasData;
import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.Nullable;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.IRenderable;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.Tuple;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class CombinedCanvasWidget
extends AbstractArtistTableWidget
implements IRenderable,
IGuiEventListener {
    private static final int size = Helper.getBasicResolution().getNumeric();

    public CombinedCanvasWidget(ArtistTableScreen parentScreen, int x, int y) {
        super(parentScreen, x, y, size, size, (ITextComponent)new TranslationTextComponent("container.zetter.painting.canvas"));
    }

    public void render(MatrixStack matrixStack) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)this.field_230690_l_, (double)this.field_230691_m_, 1.0);
        DummyCanvasData canvasData = ((ArtistTableContainer)this.parentScreen.func_212873_a_()).getCanvasCombination().canvasData;
        this.drawCanvas(matrixStack, canvasData);
        matrixStack.func_227865_b_();
    }

    private void drawCanvas(MatrixStack matrixStack, @Nullable DummyCanvasData canvasData) {
        if (canvasData != null) {
            int scale = CombinedCanvasWidget.getScale(canvasData);
            Tuple<Integer, Integer> displacement = CombinedCanvasWidget.getDisplacement(canvasData, scale);
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)((Integer)displacement.func_76341_a()).intValue(), (double)((Integer)displacement.func_76340_b()).intValue(), 1.0);
            matrixStack.func_227862_a_((float)scale, (float)scale, 1.0f);
            IRenderTypeBuffer.Impl renderTypeBufferImpl = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
            CanvasRenderer.getInstance().renderCanvas(matrixStack, (IRenderTypeBuffer)renderTypeBufferImpl, canvasData, 0xF000F0);
            renderTypeBufferImpl.func_228461_a_();
            matrixStack.func_227865_b_();
        }
    }

    public static Tuple<Integer, Integer> getDisplacement(@Nullable DummyCanvasData canvasData, int scale) {
        if (canvasData != null) {
            int xSize = canvasData.getWidth() / Helper.getResolution().getNumeric() * Helper.getBasicResolution().getNumeric() * scale;
            int ySize = canvasData.getHeight() / Helper.getResolution().getNumeric() * Helper.getBasicResolution().getNumeric() * scale;
            int width = Helper.getBasicResolution().getNumeric() * 4;
            int height = Helper.getBasicResolution().getNumeric() * 4;
            return new Tuple((Object)((width - xSize) / 2), (Object)((height - ySize) / 2));
        }
        return new Tuple((Object)0, (Object)0);
    }

    public static int getScale(@Nullable DummyCanvasData canvasData) {
        if (canvasData != null) {
            int xScale = 4 / (canvasData.getWidth() / Helper.getResolution().getNumeric());
            int yScale = 4 / (canvasData.getHeight() / Helper.getResolution().getNumeric());
            return Math.min(xScale, yScale);
        }
        return 1;
    }

    @Nullable
    public static CanvasData getCanvasData(World world, String canvasName) {
        ICanvasTracker canvasTracker = Helper.getWorldCanvasTracker(world);
        if (canvasTracker == null) {
            return null;
        }
        return canvasTracker.getCanvasData(canvasName, CanvasData.class);
    }
}

