/*
 * Decompiled with CFR 0.152.
 */
package com.dantaeusb.zetter.client.gui.painting;

import com.dantaeusb.zetter.client.gui.PaintingScreen;
import com.dantaeusb.zetter.client.gui.painting.AbstractPaintingWidget;
import com.dantaeusb.zetter.core.Helper;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.IRenderable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class CanvasWidget
extends AbstractPaintingWidget
implements IRenderable,
IGuiEventListener {
    private static final int CANVAS_SCALE_FACTOR = 5;
    private static final int size = Helper.getResolution().getNumeric() * 5;
    private boolean canvasDragging = false;

    public CanvasWidget(PaintingScreen parentScreen, int x, int y) {
        super(parentScreen, x, y, size, size, (ITextComponent)new TranslationTextComponent("container.zetter.painting.canvas"));
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        int iMouseX = (int)mouseX;
        int iMouseY = (int)mouseY;
        if (this.func_231047_b_(mouseX, mouseY)) {
            this.canvasDragging = true;
            this.handleCanvasInteraction(iMouseX, iMouseY);
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.canvasDragging && this.func_231047_b_(mouseX, mouseY)) {
            int iMouseX = (int)mouseX;
            int iMouseY = (int)mouseY;
            this.handleCanvasInteraction(iMouseX, iMouseY);
            return true;
        }
        return super.func_231045_a_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        this.canvasDragging = false;
        return super.func_231048_c_(mouseX, mouseY, button);
    }

    protected boolean handleCanvasInteraction(int iMouseX, int iMouseY) {
        int canvasX = (iMouseX - this.field_230690_l_) / 5;
        int canvasY = (iMouseY - this.field_230691_m_) / 5;
        this.parentScreen.useTool(canvasX, canvasY);
        return true;
    }

    public void render(MatrixStack matrixStack) {
        if (!this.parentScreen.isCanvasAvailable()) {
            return;
        }
        for (int i = 0; i < Helper.getResolution().getNumeric() * Helper.getResolution().getNumeric(); ++i) {
            int localX = i % 16;
            int localY = i / 16;
            int color = this.parentScreen.getColorAt(i);
            int globalX = this.field_230690_l_ + localX * 5;
            int globalY = this.field_230691_m_ + localY * 5;
            this.func_238468_a_(matrixStack, globalX, globalY, globalX + 5, globalY + 5, color, color);
        }
    }
}

