/*
 * Decompiled with CFR 0.152.
 */
package com.dantaeusb.zetter.client.gui.painting;

import com.dantaeusb.zetter.Zetter;
import com.dantaeusb.zetter.client.gui.PaintingScreen;
import com.dantaeusb.zetter.client.gui.painting.AbstractPaintingWidget;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.IRenderable;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class ColorCodeWidget
extends AbstractPaintingWidget
implements IRenderable,
IGuiEventListener {
    static final int TEXTBOX_WIDTH = 82;
    static final int TEXTBOX_HEIGHT = 16;
    static final int TEXTBOX_TEXT_OFFSET = 8;
    static final int MODE_BUTTON_HEIGHT = 16;
    private static final Pattern HEX_COLOR_PATTERN = Pattern.compile("\\p{XDigit}{1,6}");
    private static final Pattern HEX_COLOR_STRICT_PATTERN = Pattern.compile("(\\p{XDigit}{3}|\\p{XDigit}{6})");
    TextFieldWidget textField;
    Predicate<String> hexColorValidator = text -> {
        if (StringUtils.func_151246_b((String)text)) {
            return true;
        }
        Matcher matcher = HEX_COLOR_PATTERN.matcher((CharSequence)text);
        return matcher.matches();
    };

    public ColorCodeWidget(PaintingScreen parentScreen, int x, int y) {
        super(parentScreen, x, y, 82, 16, (ITextComponent)new TranslationTextComponent("container.zetter.painting.tools"));
    }

    public void initFields() {
        this.textField = new TextFieldWidget(this.parentScreen.getFont(), this.field_230690_l_ + 8 + 4, this.field_230691_m_ + 4, 75, 12, (ITextComponent)new TranslationTextComponent("container.zetter.easel"));
        this.textField.func_146205_d(false);
        this.textField.func_146193_g(-1);
        this.textField.func_146204_h(-1);
        this.textField.func_146185_a(false);
        this.textField.func_146203_f(32);
        this.textField.func_212954_a(this::applyColor);
        this.textField.func_200675_a(this.hexColorValidator);
        this.parentScreen.addChildren((IGuiEventListener)this.textField);
    }

    public void tick() {
        this.textField.func_146178_a();
    }

    public void updateColorValue(int color) {
        this.textField.func_146180_a(Integer.toHexString(color &= 0xFFFFFF));
    }

    private void applyColor(String text) {
        Matcher matcher = HEX_COLOR_STRICT_PATTERN.matcher(text);
        if (!matcher.matches()) {
            return;
        }
        try {
            if (text.length() == 3) {
                StringBuilder longText = new StringBuilder();
                for (int i = 0; i < 3; ++i) {
                    longText.append(text.charAt(i));
                    longText.append(text.charAt(i));
                }
                text = longText.toString();
            }
            int color = Integer.parseInt(text, 16) | 0xFF000000;
            this.parentScreen.updateCurrentPaletteColor(color);
            this.parentScreen.pushPaletteUpdateColor();
        }
        catch (NumberFormatException exception) {
            Zetter.LOG.error("Invalid color number");
            return;
        }
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (this.textField.func_230999_j_()) {
            return this.textField.func_231046_a_(keyCode, scanCode, modifiers) || this.textField.func_212955_f();
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        int iMouseX = (int)mouseX;
        int iMouseY = (int)mouseY;
        if (PaintingScreen.isInRect(this.field_230690_l_, this.field_230691_m_, 82, 16, iMouseX, iMouseY)) {
            this.textField.func_146195_b(true);
            return super.func_231044_a_(mouseX, mouseY, button);
        }
        this.textField.func_146195_b(false);
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public boolean func_231042_a_(char codePoint, int modifiers) {
        return this.textField.func_231042_a_(codePoint, modifiers);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.drawTextbox(matrixStack);
        this.textField.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    protected void drawTextbox(MatrixStack matrixStack) {
        boolean TEXTBOX_POSITION_U = false;
        int TEXTBOX_POSITION_V = 185;
        int textboxV = 185 + (this.textField.func_230999_j_() ? 16 : 0);
        this.func_238474_b_(matrixStack, this.field_230690_l_, this.field_230691_m_, 0, textboxV, 82, 16);
    }
}

