/*
 * Decompiled with CFR 0.152.
 */
package com.dantaeusb.zetter.client.gui.painting;

import com.dantaeusb.zetter.client.gui.PaintingScreen;
import com.dantaeusb.zetter.client.gui.painting.AbstractPaintingWidget;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.IRenderable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class PaletteWidget
extends AbstractPaintingWidget
implements IRenderable,
IGuiEventListener {
    static final int PALETTE_SCALE_FACTOR = 10;
    static final int PALETTE_OFFSET = 11;
    static final int PALETTE_COLS = 2;
    static final int WIDTH = 21;
    static final int HEIGHT = 87;
    private int currentPaletteSlot = 0;

    public PaletteWidget(PaintingScreen parentScreen, int x, int y) {
        super(parentScreen, x, y, 21, 87, (ITextComponent)new TranslationTextComponent("container.zetter.painting.palette"));
    }

    public int getCurrentPaletteSlot() {
        return this.currentPaletteSlot;
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        int iMouseX = (int)mouseX;
        int iMouseY = (int)mouseY;
        int slotIndex = -1;
        if (!this.func_231047_b_(mouseX, mouseY)) {
            return false;
        }
        for (int i = 0; i < 14; ++i) {
            int slotX = this.field_230690_l_ + i % 2 * 11;
            int slotY = this.field_230691_m_ + i / 2 * 11;
            if (!PaintingScreen.isInRect(slotX, slotY, 10, 10, iMouseX, iMouseY) || !this.func_230987_a_(button)) continue;
            slotIndex = i;
            break;
        }
        if (slotIndex == -1) {
            return false;
        }
        this.setCurrentPaletteSlot(slotIndex);
        return true;
    }

    public void render(MatrixStack matrixStack) {
        this.drawPalette(matrixStack);
        this.drawPaletteSelector(matrixStack);
    }

    protected void drawPalette(MatrixStack matrixStack) {
        if (!this.parentScreen.isPaletteAvailable()) {
            return;
        }
        for (int i = 0; i < 14; ++i) {
            int fromX = this.field_230690_l_ + i % 2 * 11;
            int fromY = this.field_230691_m_ + i / 2 * 11;
            int color = this.parentScreen.getPaletteColor(i);
            this.func_238468_a_(matrixStack, fromX, fromY, fromX + 10, fromY + 10, color, color);
        }
    }

    protected void drawPaletteSelector(MatrixStack matrixStack) {
        if (!this.parentScreen.isPaletteAvailable()) {
            return;
        }
        int SELECTOR_POSITION_U = 82;
        int SELECTOR_POSITION_V = 185;
        int PALETTE_BORDER = 3;
        int selectorPositionX = this.field_230690_l_ + (this.currentPaletteSlot % 2 != 0 ? 11 : 0) - 3;
        int selectorPositionY = this.field_230691_m_ + this.currentPaletteSlot / 2 * 11 - 3;
        this.func_238474_b_(matrixStack, selectorPositionX, selectorPositionY, 82, 185, 16, 16);
    }

    protected void setCurrentPaletteSlot(int slotIndex) {
        this.currentPaletteSlot = slotIndex;
        this.parentScreen.updateSlidersWithCurrentColor();
    }
}

