/*
 * Decompiled with CFR 0.152.
 */
package com.dantaeusb.zetter.client.gui.painting;

import com.dantaeusb.zetter.Zetter;
import com.dantaeusb.zetter.client.gui.PaintingScreen;
import com.dantaeusb.zetter.client.gui.painting.AbstractPaintingWidget;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.awt.Color;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.IRenderable;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class SlidersWidget
extends AbstractPaintingWidget
implements IRenderable,
IGuiEventListener {
    static final int SLIDER_WIDTH = 150;
    static final int SLIDER_HEIGHT = 9;
    static final int SLIDER_DISTANCE = 5;
    static final int WIDTH = 150;
    static final int HEIGHT = 37;
    private float sliderHuePercent = 0.0f;
    private float sliderSaturationPercent = 0.0f;
    private float sliderValuePercent = 0.0f;
    private Integer sliderDraggingIndex;

    public SlidersWidget(PaintingScreen parentScreen, int x, int y) {
        super(parentScreen, x, y, 150, 37, (ITextComponent)new TranslationTextComponent("container.zetter.painting.sliders"));
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        int iMouseX = (int)mouseX;
        int iMouseY = (int)mouseY;
        if (this.func_231047_b_(mouseX, mouseY)) {
            this.handleSliderInteraction(iMouseX, iMouseY);
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.sliderDraggingIndex != null) {
            int iMouseX = (int)mouseX;
            int iMouseY = (int)mouseY;
            this.handleSliderInteraction(iMouseX, iMouseY, this.sliderDraggingIndex);
            return true;
        }
        return super.func_231045_a_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        if (this.sliderDraggingIndex != null) {
            this.parentScreen.pushPaletteUpdateColor();
        }
        this.sliderDraggingIndex = null;
        return super.func_231048_c_(mouseX, mouseY, button);
    }

    public void render(MatrixStack matrixStack) {
        this.drawSliderBackground(matrixStack, 0, this.isDraggingSlider(0));
        this.drawSliderBackground(matrixStack, 1, this.isDraggingSlider(1));
        this.drawSliderBackground(matrixStack, 2, this.isDraggingSlider(2));
        this.drawSliderForeground(matrixStack, 0, SlidersWidget::getHue, this.isDraggingSlider(0));
        this.drawSliderForeground(matrixStack, 1, SlidersWidget::getSaturation, this.isDraggingSlider(1));
        this.drawSliderForeground(matrixStack, 2, SlidersWidget::getValue, this.isDraggingSlider(2));
        this.drawHandler(matrixStack, 0, this.sliderHuePercent, this.isDraggingSlider(0));
        this.drawHandler(matrixStack, 1, this.sliderSaturationPercent, this.isDraggingSlider(1));
        this.drawHandler(matrixStack, 2, this.sliderValuePercent, this.isDraggingSlider(2));
    }

    protected void drawSliderBackground(MatrixStack matrixStack, int verticalOffset, boolean active) {
        int SLIDER_POSITION_U = 5;
        int SLIDER_POSITION_V = 217;
        int top = this.field_230691_m_ + verticalOffset * 14;
        int sliderV = 217;
        if (active) {
            sliderV += 9;
        }
        this.func_238474_b_(matrixStack, this.field_230690_l_, top, 5, sliderV, 150, 9);
    }

    protected void drawSliderForeground(MatrixStack matrixStack, int verticalOffset, BiFunction<float[], Float, Integer> getColorLambda, boolean active) {
        int sliderContentGlobalLeft = this.field_230690_l_ + 3;
        int sliderContentGlobalTop = this.field_230691_m_ + verticalOffset * 14 + 3;
        int sliderContentWidth = 144;
        int sliderContentHeight = 3;
        if (active) {
            sliderContentGlobalTop -= 2;
            sliderContentHeight += 4;
        }
        Color currentColor = new Color(this.parentScreen.getCurrentColor());
        float[] currentColorHSB = Color.RGBtoHSB(currentColor.getRed(), currentColor.getGreen(), currentColor.getBlue(), null);
        for (int i = 0; i < sliderContentWidth; ++i) {
            int color = getColorLambda.apply(currentColorHSB, Float.valueOf((float)i / (float)sliderContentWidth));
            this.func_238468_a_(matrixStack, sliderContentGlobalLeft + i, sliderContentGlobalTop, sliderContentGlobalLeft + i + 1, sliderContentGlobalTop + sliderContentHeight, color, color);
        }
    }

    protected static Integer getHue(float[] inColorHSB, float percent) {
        return Color.HSBtoRGB(percent, 1.0f, 1.0f);
    }

    protected static Integer getSaturation(float[] inColorHSB, float percent) {
        return Color.HSBtoRGB(inColorHSB[0], 1.0f - percent, inColorHSB[2]);
    }

    protected static Integer getValue(float[] inColorHSB, float percent) {
        return Color.HSBtoRGB(inColorHSB[0], inColorHSB[1], 1.0f - percent);
    }

    public void updateSlidersWithCurrentColor() {
        Color currentColor = new Color(this.parentScreen.getCurrentColor());
        float[] currentColorHSB = Color.RGBtoHSB(currentColor.getRed(), currentColor.getGreen(), currentColor.getBlue(), null);
        this.sliderHuePercent = currentColorHSB[0];
        this.sliderSaturationPercent = 1.0f - currentColorHSB[1];
        this.sliderValuePercent = 1.0f - currentColorHSB[2];
    }

    protected void handleSliderInteraction(int mouseX, int mouseY) {
        this.handleSliderInteraction(mouseX, mouseY, null);
    }

    protected boolean isDraggingSlider(int index) {
        return this.sliderDraggingIndex != null && this.sliderDraggingIndex == index;
    }

    protected void handleSliderInteraction(int mouseX, int mouseY, @Nullable Integer sliderIndex) {
        if (sliderIndex == null) {
            for (int i = 0; i < 3; ++i) {
                int top = this.field_230691_m_ + i * 14;
                if (!PaintingScreen.isInRect(this.field_230690_l_, top, 150, 9, mouseX, mouseY)) continue;
                sliderIndex = i;
                break;
            }
            if (sliderIndex == null) {
                Zetter.LOG.warn("Cannot find slider!");
                return;
            }
        }
        this.sliderDraggingIndex = sliderIndex;
        float percent = (float)(mouseX - this.field_230690_l_ - 3) / 144.0f;
        float percentC = MathHelper.func_76131_a((float)percent, (float)0.0f, (float)1.0f);
        this.updateSliderPosition(sliderIndex, percentC);
    }

    protected void updateSliderPosition(int sliderIndex, float percent) {
        int newColor;
        Color currentColor = new Color(this.parentScreen.getCurrentColor());
        float[] currentColorHSB = Color.RGBtoHSB(currentColor.getRed(), currentColor.getGreen(), currentColor.getBlue(), null);
        switch (sliderIndex) {
            case 0: {
                newColor = Color.HSBtoRGB(percent, currentColorHSB[1], currentColorHSB[2]);
                this.sliderHuePercent = percent;
                break;
            }
            case 1: {
                newColor = Color.HSBtoRGB(this.sliderHuePercent, 1.0f - percent, currentColorHSB[2]);
                this.sliderSaturationPercent = percent;
                break;
            }
            case 2: {
                newColor = Color.HSBtoRGB(this.sliderHuePercent, currentColorHSB[1], 1.0f - percent);
                this.sliderValuePercent = percent;
                break;
            }
            default: {
                newColor = this.parentScreen.getCurrentColor();
            }
        }
        this.parentScreen.updateCurrentPaletteColor(newColor);
    }

    protected void drawHandler(MatrixStack matrixStack, int verticalOffset, float percent, boolean active) {
        boolean HANDLER_POSITION_U = false;
        int HANDLER_POSITION_V = 216;
        int HANDLER_WIDTH = 5;
        int HANDLER_HEIGHT = 11;
        int sliderContentWidth = 144;
        int sliderGlobalLeft = this.field_230690_l_ + (int)((float)sliderContentWidth * percent) + 3 - 2;
        int sliderGlobalTop = this.field_230691_m_ + verticalOffset * 14 - 1;
        int sliderV = 216;
        if (active) {
            sliderV += 11;
        }
        this.func_238474_b_(matrixStack, sliderGlobalLeft, sliderGlobalTop, 0, sliderV, 5, 11);
    }
}

