/*
 * Decompiled with CFR 0.152.
 */
package com.dantaeusb.zetter.client.gui.painting;

import com.dantaeusb.zetter.client.gui.PaintingScreen;
import com.dantaeusb.zetter.client.gui.painting.AbstractPaintingWidget;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.IRenderable;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class ToolsWidget
extends AbstractPaintingWidget
implements IRenderable,
IGuiEventListener {
    private Tool currentTool = Tool.PENCIL;
    static final int TOOLS_SIZE = 16;
    static final int TOOLS_OFFSET = 17;

    public ToolsWidget(PaintingScreen parentScreen, int x, int y) {
        super(parentScreen, x, y, 16, 50, (ITextComponent)new TranslationTextComponent("container.zetter.painting.tools"));
    }

    public Tool getCurrentTool() {
        return this.currentTool;
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        int iMouseX = (int)mouseX;
        int iMouseY = (int)mouseY;
        if (!this.func_231047_b_(mouseX, mouseY)) {
            return false;
        }
        int i = 0;
        for (Tool tool : Tool.values()) {
            int fromY = this.field_230691_m_ + i * 17;
            if (PaintingScreen.isInRect(this.field_230690_l_, fromY, 16, 16, iMouseX, iMouseY) && this.func_230987_a_(button)) {
                this.setCurrentTool(tool);
                this.func_230988_a_(Minecraft.func_71410_x().func_147118_V());
                return true;
            }
            ++i;
        }
        return false;
    }

    public void render(MatrixStack matrixStack) {
        int i = 0;
        for (Tool tool : Tool.values()) {
            int fromY = this.field_230691_m_ + i * 17;
            int vOffset = tool.vPosition + (this.currentTool == tool ? 16 : 0);
            this.func_238474_b_(matrixStack, this.field_230690_l_, fromY, tool.uPosition, vOffset, 16, 16);
            ++i;
        }
    }

    protected void setCurrentTool(Tool tool) {
        this.currentTool = tool;
        this.parentScreen.updateSlidersWithCurrentColor();
    }

    public static enum Tool implements IStringSerializable
    {
        PENCIL("Pencil", 176, 0),
        EYEDROPPER("Eyedropper", 192, 0),
        BUCKET("Bucket", 208, 0);

        private final String name;
        public final int uPosition;
        public final int vPosition;

        private Tool(String name, int uPosition, int vPosition) {
            this.name = name;
            this.uPosition = uPosition;
            this.vPosition = vPosition;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

