/*
 * Decompiled with CFR 0.152.
 */
package com.dantaeusb.zetter.client.renderer;

import com.dantaeusb.zetter.Zetter;
import com.dantaeusb.zetter.core.Helper;
import com.dantaeusb.zetter.core.ModNetwork;
import com.dantaeusb.zetter.network.packet.CCanvasRequestPacket;
import com.dantaeusb.zetter.network.packet.CCanvasUnloadRequestPacket;
import com.dantaeusb.zetter.storage.AbstractCanvasData;
import com.dantaeusb.zetter.storage.CanvasData;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Timer;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CanvasRenderer
implements AutoCloseable {
    private static CanvasRenderer instance;
    private final TextureManager textureManager;
    private final Map<String, Instance> canvasRendererInstances = Maps.newHashMap();
    private final Timer timer = new Timer(20.0f, 0L);
    private final Map<String, Integer> ticksSinceRenderRequested = Maps.newHashMap();
    private final Map<String, TextureRequest> textureRequestTimeout = Maps.newHashMap();

    public CanvasRenderer(TextureManager textureManagerIn) {
        this.textureManager = textureManagerIn;
        instance = this;
    }

    public static CanvasRenderer getInstance() {
        return instance;
    }

    public void updateCanvasTexture(CanvasData canvas) {
        this.getCanvasRendererInstance(canvas, true).updateCanvasTexture(canvas);
    }

    public void addCanvas(AbstractCanvasData canvas) {
        this.canvasRendererInstances.remove(canvas.func_195925_e());
        this.createCanvasRendererInstance(canvas);
    }

    public void renderCanvas(MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, AbstractCanvasData canvas, int combinedLight) {
        if (canvas.func_195925_e().equals(CanvasData.getCanvasCode(0))) {
            return;
        }
        this.ticksSinceRenderRequested.put(canvas.func_195925_e(), 0);
        Instance rendererInstance = this.getCanvasRendererInstance(canvas, false);
        if (rendererInstance == null) {
            this.queueCanvasTextureUpdate(canvas.getType(), canvas.func_195925_e());
            return;
        }
        rendererInstance.render(matrixStack, renderTypeBuffer, combinedLight);
    }

    public void update(long gameTime) {
        int partialTicks = this.timer.func_238400_a_(gameTime);
        if (partialTicks > 0) {
            this.updateTicksSinceRender(partialTicks);
            this.updateTextureRequestTimeout(partialTicks);
        }
    }

    private void updateTicksSinceRender(int partialTicks) {
        Iterator<Map.Entry<String, Integer>> iterator = this.ticksSinceRenderRequested.entrySet().iterator();
        while (iterator.hasNext()) {
            String canvasCode = iterator.next().getKey();
            int timeSinceRenderRequested = this.ticksSinceRenderRequested.getOrDefault(canvasCode, 0);
            if ((float)(timeSinceRenderRequested += partialTicks) < 3600.0f) {
                this.ticksSinceRenderRequested.put(canvasCode, timeSinceRenderRequested);
                continue;
            }
            this.unloadCanvas(canvasCode);
            iterator.remove();
        }
    }

    private void updateTextureRequestTimeout(int partialTicks) {
        for (Map.Entry<String, TextureRequest> textureRequestEntry : this.textureRequestTimeout.entrySet()) {
            TextureRequest textureRequest = textureRequestEntry.getValue();
            if (textureRequest.canUpdate()) {
                this.requestCanvasTexture(textureRequest);
                continue;
            }
            textureRequest.tick(partialTicks);
        }
    }

    protected void unloadCanvas(String canvasCode) {
        Zetter.LOG.debug("Unloading canvas " + canvasCode);
        this.canvasRendererInstances.remove(canvasCode);
        this.textureRequestTimeout.remove(canvasCode);
        CCanvasUnloadRequestPacket unloadPacket = new CCanvasUnloadRequestPacket(canvasCode);
        ModNetwork.simpleChannel.sendToServer((Object)unloadPacket);
    }

    public void queueCanvasTextureUpdate(AbstractCanvasData.Type type, String canvasCode) {
        if (canvasCode == null) {
            Zetter.LOG.debug("Tried to queue null canvas");
            return;
        }
        if (type == AbstractCanvasData.Type.DUMMY) {
            Zetter.LOG.debug("Tried to queue dummy canvas");
            return;
        }
        if (this.textureRequestTimeout.containsKey(canvasCode)) {
            TextureRequest textureRequest = this.textureRequestTimeout.get(canvasCode);
            if (textureRequest.isNeedUpdate()) {
                return;
            }
            textureRequest.markDirty();
        } else {
            this.textureRequestTimeout.put(canvasCode, new TextureRequest(type, canvasCode));
        }
    }

    protected void requestCanvasTexture(TextureRequest request) {
        CCanvasRequestPacket requestSyncPacket = new CCanvasRequestPacket(request.getCanvasType(), request.getCanvasCode());
        ModNetwork.simpleChannel.sendToServer((Object)requestSyncPacket);
        request.update();
    }

    @Nullable
    private Instance getCanvasRendererInstance(AbstractCanvasData canvas, boolean create) {
        Instance canvasRendererInstance = this.canvasRendererInstances.get(canvas.func_195925_e());
        if (create && canvasRendererInstance == null) {
            this.createCanvasRendererInstance(canvas);
        }
        return canvasRendererInstance;
    }

    private void createCanvasRendererInstance(AbstractCanvasData canvas) {
        Instance canvasRendererInstance = new Instance(canvas.func_195925_e(), canvas.getWidth(), canvas.getHeight(), canvas.getResolution());
        canvasRendererInstance.updateCanvasTexture(canvas);
        this.canvasRendererInstances.put(canvas.func_195925_e(), canvasRendererInstance);
    }

    public void clearLoadedCanvases() {
        for (Instance canvasRendererInstance : this.canvasRendererInstances.values()) {
            canvasRendererInstance.close();
        }
        this.canvasRendererInstances.clear();
    }

    @Override
    public void close() {
        this.clearLoadedCanvases();
    }

    static class TextureRequest {
        private final int TEXTURE_REQUEST_TIMEOUT = 20;
        private final AbstractCanvasData.Type type;
        private final String code;
        private boolean needUpdate = true;
        private int timeout = 0;

        TextureRequest(AbstractCanvasData.Type type, String canvasCode) {
            this.type = type;
            this.code = canvasCode;
        }

        public void markDirty() {
            this.needUpdate = true;
        }

        public boolean isNeedUpdate() {
            return this.needUpdate;
        }

        public void update() {
            this.needUpdate = false;
            this.timeout = 20;
        }

        public String getCanvasCode() {
            return this.code;
        }

        public AbstractCanvasData.Type getCanvasType() {
            return this.type;
        }

        public void tick(int ticks) {
            if (!this.needUpdate && this.timeout <= 0) {
                return;
            }
            this.timeout -= ticks;
        }

        public boolean canUpdate() {
            return this.needUpdate && this.timeout < 0;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    class Instance
    implements AutoCloseable {
        private final String code;
        private final DynamicTexture canvasTexture;
        private final RenderType renderType;
        private final int width;
        private final int height;
        private final int blockPixelWidth;
        private final int blockPixelHeight;

        private Instance(String canvasCode, int width, int height, AbstractCanvasData.Resolution resolution) {
            this.code = canvasCode;
            this.canvasTexture = new DynamicTexture(width, height, true);
            ResourceLocation dynamicTextureLocation = CanvasRenderer.this.textureManager.func_110578_a("canvas/" + canvasCode, this.canvasTexture);
            this.renderType = RenderType.func_228658_l_((ResourceLocation)dynamicTextureLocation);
            this.width = width;
            this.height = height;
            int downScale = resolution.getNumeric() / Helper.getBasicResolution().getNumeric();
            this.blockPixelWidth = width / downScale;
            this.blockPixelHeight = height / downScale;
        }

        private void updateCanvasTexture(AbstractCanvasData canvas) {
            for (int pixelY = 0; pixelY < canvas.getHeight(); ++pixelY) {
                for (int pixelX = 0; pixelX < canvas.getWidth(); ++pixelX) {
                    int color = canvas.getColorAt(pixelX, pixelY);
                    this.canvasTexture.func_195414_e().func_195700_a(pixelX, pixelY, this.ARGBtoABGR(color));
                }
            }
            this.canvasTexture.func_110564_a();
        }

        private int ARGBtoABGR(int x) {
            return x & 0xFF000000 | (x & 0xFF0000) >> 16 | x & 0xFF00 | (x & 0xFF) << 16;
        }

        private void render(MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int combinedLight) {
            Matrix4f matrix4f = matrixStack.func_227866_c_().func_227870_a_();
            IVertexBuilder ivertexbuilder = renderTypeBuffer.getBuffer(this.renderType);
            ivertexbuilder.func_227888_a_(matrix4f, 0.0f, (float)this.blockPixelHeight, 0.0f).func_225586_a_(255, 255, 255, 255).func_225583_a_(0.0f, 1.0f).func_227886_a_(combinedLight).func_181675_d();
            ivertexbuilder.func_227888_a_(matrix4f, (float)this.blockPixelWidth, (float)this.blockPixelHeight, 0.0f).func_225586_a_(255, 255, 255, 255).func_225583_a_(1.0f, 1.0f).func_227886_a_(combinedLight).func_181675_d();
            ivertexbuilder.func_227888_a_(matrix4f, (float)this.blockPixelWidth, 0.0f, 0.0f).func_225586_a_(255, 255, 255, 255).func_225583_a_(1.0f, 0.0f).func_227886_a_(combinedLight).func_181675_d();
            ivertexbuilder.func_227888_a_(matrix4f, 0.0f, 0.0f, 0.0f).func_225586_a_(255, 255, 255, 255).func_225583_a_(0.0f, 0.0f).func_227886_a_(combinedLight).func_181675_d();
        }

        @Override
        public void close() {
            this.canvasTexture.close();
        }
    }
}

