/*
 * Decompiled with CFR 0.152.
 */
package com.dantaeusb.zetter.client.renderer.entity;

import com.dantaeusb.zetter.canvastracker.ICanvasTracker;
import com.dantaeusb.zetter.client.renderer.CanvasRenderer;
import com.dantaeusb.zetter.core.Helper;
import com.dantaeusb.zetter.entity.item.CustomPaintingEntity;
import com.dantaeusb.zetter.storage.AbstractCanvasData;
import com.dantaeusb.zetter.storage.PaintingData;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class CustomPaintingRenderer
extends EntityRenderer<CustomPaintingEntity> {
    public static final String[] MODEL_CODES = new String[]{"1x1", "top_left", "top", "top_right", "left", "right", "bottom_left", "bottom", "bottom_right", "top_u", "bottom_u", "left_u", "right_u", "center", "center_horizontal", "center_vertical"};
    public static final HashMap<String, ModelResourceLocation> FRAME_MODELS = new HashMap();
    public static final HashMap<String, ResourceLocation> PLATE_TEXTURES = new HashMap();
    private final ModelRenderer plate = new ModelRenderer(16, 16, 0, 0);

    public CustomPaintingRenderer(EntityRendererManager renderManager) {
        super(renderManager);
        this.plate.func_78793_a(0.0f, 0.0f, 0.0f);
        this.plate.func_228303_a_(-3.0f, -1.0f, -2.0f, 6.0f, 2.0f, 2.0f, 0.0f, false);
    }

    public void render(CustomPaintingEntity entity, float entityYaw, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer renderBuffers, int combinedLight) {
        PaintingData canvasData;
        World world = entity.func_130014_f_();
        matrixStack.func_227860_a_();
        Vector3d vector3d = this.func_225627_b_((Entity)entity, partialTicks);
        matrixStack.func_227861_a_(-vector3d.func_82615_a(), -vector3d.func_82617_b(), -vector3d.func_82616_c());
        Direction facingDirection = entity.func_174811_aO();
        double offsetAlignment = 0.46875;
        matrixStack.func_227861_a_((double)facingDirection.func_82601_c() * 0.46875, (double)facingDirection.func_96559_d() * 0.46875, (double)facingDirection.func_82599_e() * 0.46875);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f - entity.field_70177_z));
        boolean flag = entity.func_82150_aj();
        double[] renderOffset = entity.getRenderOffset();
        int blockWidth = entity.getBlockWidth();
        int blockHeight = entity.getBlockHeight();
        if (!flag) {
            int offsetCombinedLight;
            int v;
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(renderOffset[0] - 1.0, renderOffset[1] - 1.0, 0.4375);
            if (blockWidth == 1 && blockHeight == 1) {
                this.renderModel(entity, "1x1", matrixStack, renderBuffers, combinedLight);
            } else if (blockWidth == 1) {
                for (v = 0; v < blockHeight; ++v) {
                    matrixStack.func_227861_a_(0.0, (double)(-v), 0.0);
                    offsetCombinedLight = WorldRenderer.func_228421_a_((IBlockDisplayReader)entity.field_70170_p, (BlockPos)CustomPaintingRenderer.getOffsetBlockPos(entity, 0, v));
                    if (v == 0) {
                        this.renderModel(entity, "top_u", matrixStack, renderBuffers, offsetCombinedLight);
                    } else if (v + 1 == blockHeight) {
                        this.renderModel(entity, "bottom_u", matrixStack, renderBuffers, offsetCombinedLight);
                    } else {
                        this.renderModel(entity, "center_vertical", matrixStack, renderBuffers, offsetCombinedLight);
                    }
                    matrixStack.func_227861_a_(0.0, (double)v, 0.0);
                }
            } else if (blockHeight == 1) {
                for (int h = 0; h < blockWidth; ++h) {
                    matrixStack.func_227861_a_((double)(-h), 0.0, 0.0);
                    offsetCombinedLight = WorldRenderer.func_228421_a_((IBlockDisplayReader)entity.field_70170_p, (BlockPos)CustomPaintingRenderer.getOffsetBlockPos(entity, h, 0));
                    if (h == 0) {
                        this.renderModel(entity, "left_u", matrixStack, renderBuffers, offsetCombinedLight);
                    } else if (h + 1 == blockWidth) {
                        this.renderModel(entity, "right_u", matrixStack, renderBuffers, offsetCombinedLight);
                    } else {
                        this.renderModel(entity, "center_horizontal", matrixStack, renderBuffers, offsetCombinedLight);
                    }
                    matrixStack.func_227861_a_((double)h, 0.0, 0.0);
                }
            } else {
                for (v = 0; v < blockHeight; ++v) {
                    for (int h = 0; h < blockWidth; ++h) {
                        matrixStack.func_227861_a_((double)(-h), (double)(-v), 0.0);
                        int offsetCombinedLight2 = WorldRenderer.func_228421_a_((IBlockDisplayReader)entity.field_70170_p, (BlockPos)CustomPaintingRenderer.getOffsetBlockPos(entity, h, v));
                        if (v == 0) {
                            if (h == 0) {
                                this.renderModel(entity, "top_left", matrixStack, renderBuffers, offsetCombinedLight2);
                            } else if (h + 1 == blockWidth) {
                                this.renderModel(entity, "top_right", matrixStack, renderBuffers, offsetCombinedLight2);
                            } else {
                                this.renderModel(entity, "top", matrixStack, renderBuffers, offsetCombinedLight2);
                            }
                        } else if (v + 1 == blockHeight) {
                            if (h == 0) {
                                this.renderModel(entity, "bottom_left", matrixStack, renderBuffers, offsetCombinedLight2);
                            } else if (h + 1 == blockWidth) {
                                this.renderModel(entity, "bottom_right", matrixStack, renderBuffers, offsetCombinedLight2);
                            } else {
                                this.renderModel(entity, "bottom", matrixStack, renderBuffers, offsetCombinedLight2);
                            }
                        } else if (h == 0) {
                            this.renderModel(entity, "left", matrixStack, renderBuffers, offsetCombinedLight2);
                        } else if (h + 1 == blockWidth) {
                            this.renderModel(entity, "right", matrixStack, renderBuffers, offsetCombinedLight2);
                        } else {
                            this.renderModel(entity, "center", matrixStack, renderBuffers, offsetCombinedLight2);
                        }
                        matrixStack.func_227861_a_((double)h, (double)v, 0.0);
                    }
                }
            }
            matrixStack.func_227865_b_();
        }
        if ((canvasData = CustomPaintingRenderer.getCanvasData(world, entity.getCanvasCode())) != null) {
            matrixStack.func_227860_a_();
            double canvasOffsetZ = entity.getMaterial().hasOffset() ? 0.46875 : 0.4375;
            matrixStack.func_227861_a_(renderOffset[0] - 1.0, renderOffset[1] - 1.0, canvasOffsetZ);
            float scaleFactor = 0.0625f;
            matrixStack.func_227862_a_(0.0625f, 0.0625f, 0.0625f);
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
            matrixStack.func_227861_a_(-16.0, -16.0, 0.0);
            CanvasRenderer.getInstance().renderCanvas(matrixStack, renderBuffers, canvasData, combinedLight);
            matrixStack.func_227865_b_();
        } else {
            CanvasRenderer.getInstance().queueCanvasTextureUpdate(AbstractCanvasData.Type.PAINTING, entity.getCanvasCode());
        }
        if (canvasData != null && entity.hasPlate()) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.0, (double)blockHeight / -2.0, 0.5);
            String material = entity.getMaterial().toString();
            IVertexBuilder vertexBuilder = renderBuffers.getBuffer(RenderType.func_228638_b_((ResourceLocation)PLATE_TEXTURES.get(material)));
            this.plate.func_228309_a_(matrixStack, vertexBuilder, combinedLight, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
            matrixStack.func_227865_b_();
        }
        matrixStack.func_227865_b_();
        super.func_225623_a_((Entity)entity, entityYaw, partialTicks, matrixStack, renderBuffers, combinedLight);
    }

    private void renderModel(CustomPaintingEntity entity, String key, MatrixStack matrixStack, IRenderTypeBuffer renderBuffers, int combinedLight) {
        ModelResourceLocation modelResourceLocation = FRAME_MODELS.get((Object)((Object)entity.getMaterial()) + "/" + key);
        MatrixStack.Entry currentMatrix = matrixStack.func_227866_c_();
        IVertexBuilder vertexBuffer = renderBuffers.getBuffer(RenderType.func_228639_c_());
        IBakedModel frameModel = Minecraft.func_71410_x().func_209506_al().func_174953_a(modelResourceLocation);
        BlockRendererDispatcher rendererDispatcher = Minecraft.func_71410_x().func_175602_ab();
        rendererDispatcher.func_175019_b().renderModel(currentMatrix, vertexBuffer, null, frameModel, 1.0f, 1.0f, 1.0f, combinedLight, OverlayTexture.field_229196_a_, (IModelData)EmptyModelData.INSTANCE);
    }

    public static BlockPos getOffsetBlockPos(CustomPaintingEntity entity, int h, int v) {
        Direction facingDirection = entity.func_174811_aO();
        facingDirection = facingDirection.func_176735_f();
        int xOffset = (entity.getBlockWidth() + 1) / 2 - 1;
        int yOffset = (entity.getBlockHeight() + 1) / 2 - 1;
        return entity.func_174857_n().func_177982_a((xOffset + h) * facingDirection.func_82601_c(), yOffset + v, (xOffset + h) * facingDirection.func_82599_e());
    }

    @Nullable
    public static PaintingData getCanvasData(World world, String canvasName) {
        ICanvasTracker canvasTracker = Helper.getWorldCanvasTracker(world);
        if (canvasTracker == null) {
            return null;
        }
        return canvasTracker.getCanvasData(canvasName, PaintingData.class);
    }

    public ResourceLocation getEntityTexture(CustomPaintingEntity entity) {
        return PLATE_TEXTURES.get("oak");
    }

    static {
        for (String string : MODEL_CODES) {
            for (CustomPaintingEntity.Materials material : CustomPaintingEntity.Materials.values()) {
                FRAME_MODELS.put((Object)((Object)material) + "/" + string, new ModelResourceLocation("zetter:frame/" + (Object)((Object)material) + "/" + string));
            }
        }
        for (CustomPaintingEntity.Materials materials : CustomPaintingEntity.Materials.values()) {
            if (!materials.canHavePlate()) continue;
            PLATE_TEXTURES.put(materials.toString(), new ResourceLocation("zetter", "textures/entity/frame/plate/" + (Object)((Object)materials) + ".png"));
        }
    }
}

