/*
 * Decompiled with CFR 0.152.
 */
package com.dantaeusb.zetter.client.renderer.tileentity;

import com.dantaeusb.zetter.block.EaselBlock;
import com.dantaeusb.zetter.canvastracker.ICanvasTracker;
import com.dantaeusb.zetter.client.renderer.CanvasRenderer;
import com.dantaeusb.zetter.core.Helper;
import com.dantaeusb.zetter.core.ModBlocks;
import com.dantaeusb.zetter.storage.AbstractCanvasData;
import com.dantaeusb.zetter.storage.CanvasData;
import com.dantaeusb.zetter.tileentity.EaselTileEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.ChestBlock;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;

public class EaselTileEntityRenderer
extends TileEntityRenderer<EaselTileEntity> {
    private final ModelRenderer rack = new ModelRenderer(64, 64, 0, 0);
    private final ModelRenderer canvas;
    private final ModelRenderer topPlank;
    private final ModelRenderer backLeg;
    private final ModelRenderer frontLegs;
    public static final ResourceLocation TEXTURE = new ResourceLocation("zetter:textures/entity/easel.png");
    private boolean stoopidUpdate = false;

    public EaselTileEntityRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
        this.rack.func_78793_a(0.0f, 0.0f, 0.0f);
        this.rack.func_228303_a_(1.0f, 11.5f, 3.5f, 14.0f, 1.0f, 4.0f, 0.0f, false);
        this.canvas = new ModelRenderer(64, 64, 6, 5);
        this.canvas.func_78793_a(0.0f, 0.0f, 0.0f);
        EaselTileEntityRenderer.setRotationAngle(this.canvas, 0.1745f, 0.0f, 0.0f);
        this.canvas.func_228303_a_(0.0f, 12.0f, 3.0f, 16.0f, 18.0f, 1.0f, 0.0f, false);
        this.topPlank = new ModelRenderer(64, 64, 0, 0);
        this.topPlank.func_78793_a(0.0f, 0.0f, 0.0f);
        EaselTileEntityRenderer.setRotationAngle(this.topPlank, 0.1745f, 0.0f, 0.0f);
        this.topPlank.func_228303_a_(1.0f, 26.0f, 5.0f, 14.0f, 2.0f, 1.0f, 0.0f, false);
        this.backLeg = new ModelRenderer(64, 64, 0, 6);
        this.backLeg.func_78793_a(0.0f, 0.0f, 15.0f);
        EaselTileEntityRenderer.setRotationAngle(this.backLeg, -0.2182f, 0.0f, 0.0f);
        this.backLeg.func_228303_a_(7.0f, 0.0f, 0.0f, 2.0f, 30.0f, 1.0f, 0.0f, false);
        this.frontLegs = new ModelRenderer(64, 64, 0, 6);
        this.frontLegs.func_78793_a(0.0f, 0.0f, -3.0f);
        EaselTileEntityRenderer.setRotationAngle(this.frontLegs, 0.1745f, 0.0f, 0.0f);
        this.frontLegs.func_228303_a_(12.0f, 1.0f, 7.0f, 2.0f, 30.0f, 1.0f, 0.0f, false);
        this.frontLegs.func_228303_a_(2.0f, 1.0f, 7.0f, 2.0f, 30.0f, 1.0f, 0.0f, false);
    }

    public void render(EaselTileEntity tileEntity, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int combinedLight, int combinedOverlay) {
        World world = tileEntity.func_145831_w();
        boolean flag = world != null;
        BlockState blockState = flag ? tileEntity.func_195044_w() : (BlockState)ModBlocks.EASEL.func_176223_P().func_206870_a((Property)EaselBlock.FACING, (Comparable)Direction.SOUTH);
        IVertexBuilder vertexBuilder = renderTypeBuffer.getBuffer(RenderType.func_228638_b_((ResourceLocation)TEXTURE));
        matrixStack.func_227860_a_();
        float facingAngle = ((Direction)blockState.func_177229_b((Property)ChestBlock.field_176459_a)).func_185119_l();
        matrixStack.func_227861_a_(0.5, 0.5, 0.5);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-facingAngle));
        matrixStack.func_227861_a_(-0.5, -0.5, -0.5);
        this.rack.func_228308_a_(matrixStack, vertexBuilder, combinedLight, combinedOverlay);
        this.topPlank.func_228308_a_(matrixStack, vertexBuilder, combinedLight, combinedOverlay);
        this.backLeg.func_228308_a_(matrixStack, vertexBuilder, combinedLight, combinedOverlay);
        this.frontLegs.func_228308_a_(matrixStack, vertexBuilder, combinedLight, combinedOverlay);
        this.canvas.func_228308_a_(matrixStack, vertexBuilder, combinedLight, combinedOverlay);
        if (tileEntity.hasCanvas()) {
            CanvasData canvasData = EaselTileEntityRenderer.getCanvasData(world, tileEntity.getCanvasName());
            if (canvasData != null) {
                float scaleFactor = 0.0625f;
                matrixStack.func_227862_a_(0.0625f, 0.0625f, 0.0625f);
                matrixStack.func_227861_a_(0.0, 12.5, 5.0);
                matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229193_c_(0.1745f));
                matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
                matrixStack.func_227861_a_(-16.0, -16.0, 0.1);
                CanvasRenderer.getInstance().renderCanvas(matrixStack, renderTypeBuffer, canvasData, combinedLight);
            } else {
                CanvasRenderer.getInstance().queueCanvasTextureUpdate(AbstractCanvasData.Type.CANVAS, tileEntity.getCanvasName());
            }
        }
        matrixStack.func_227865_b_();
    }

    public static void setRotationAngle(ModelRenderer modelRenderer, float x, float y, float z) {
        modelRenderer.field_78795_f = x;
        modelRenderer.field_78796_g = y;
        modelRenderer.field_78808_h = z;
    }

    @Nullable
    public static CanvasData getCanvasData(World world, String canvasName) {
        ICanvasTracker canvasTracker = Helper.getWorldCanvasTracker(world);
        if (canvasTracker == null) {
            return null;
        }
        return canvasTracker.getCanvasData(canvasName, CanvasData.class);
    }
}

