/*
 * Decompiled with CFR 0.152.
 */
package com.dantaeusb.zetter.container;

import com.dantaeusb.zetter.container.artisttable.CanvasCombination;
import com.dantaeusb.zetter.core.Helper;
import com.dantaeusb.zetter.core.ModContainers;
import com.dantaeusb.zetter.core.ModItems;
import com.dantaeusb.zetter.item.FrameItem;
import com.dantaeusb.zetter.storage.DummyCanvasData;
import com.dantaeusb.zetter.storage.PaintingData;
import com.dantaeusb.zetter.tileentity.ArtistTableTileEntity;
import com.dantaeusb.zetter.tileentity.storage.ArtistTableCanvasStorage;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.world.World;
import org.apache.commons.lang3.StringUtils;

public class ArtistTableContainer
extends Container {
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    public static final int CANVAS_ROW_COUNT = 4;
    public static final int CANVAS_COLUMN_COUNT = 4;
    public static final int CANVAS_SLOT_COUNT = 16;
    private final IWorldPosCallable worldPosCallable;
    private final PlayerEntity player;
    private final World world;
    private ArtistTableCanvasStorage canvasStorage;
    private CanvasCombination canvasCombination;
    private String paintingName = "";
    protected final Inventory inventoryOut = new Inventory(1);
    public static final int PLAYER_INVENTORY_XPOS = 8;
    public static final int PLAYER_INVENTORY_YPOS = 138;

    public ArtistTableContainer(int windowID, PlayerInventory invPlayer, ArtistTableCanvasStorage canvasStorage, IWorldPosCallable worldPosCallable) {
        super(ModContainers.ARTIST_TABLE, windowID);
        this.worldPosCallable = worldPosCallable;
        this.player = invPlayer.field_70458_d;
        this.world = invPlayer.field_70458_d.field_70170_p;
        this.canvasStorage = canvasStorage;
        this.canvasStorage.setMarkDirtyNotificationLambda(this::updateCanvasCombination);
        int SLOT_X_SPACING = 18;
        int SLOT_Y_SPACING = 18;
        int HOTBAR_XPOS = 8;
        int HOTBAR_YPOS = 196;
        for (int x = 0; x < 9; ++x) {
            this.func_75146_a(new Slot((IInventory)invPlayer, x, 8 + 18 * x, 196));
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                int slotNumber = 9 + y * 9 + x;
                int xpos = 8 + x * 18;
                int ypos = 138 + y * 18;
                this.func_75146_a(new Slot((IInventory)invPlayer, slotNumber, xpos, ypos));
            }
        }
        int CANVAS_INVENTORY_XPOS = 12;
        int CANVAS_INVENTORY_YPOS = 24;
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 4; ++x) {
                int slotNumber = y * 4 + x;
                int xpos = 12 + x * 18;
                int ypos = 24 + y * 18;
                this.func_75146_a(new SlotCanvas(this.canvasStorage, slotNumber, xpos, ypos));
            }
        }
        int OUTPUT_XPOS = 152;
        int OUTPUT_YPOS = 107;
        this.func_75146_a(new SlotOutput((IInventory)this.inventoryOut, 0, 152, 107));
        this.updateCanvasCombination();
    }

    public static ArtistTableContainer createContainerServerSide(int windowID, PlayerInventory playerInventory, ArtistTableCanvasStorage canvasStorage, IWorldPosCallable worldPosCallable) {
        return new ArtistTableContainer(windowID, playerInventory, canvasStorage, worldPosCallable);
    }

    public static ArtistTableContainer createContainerClientSide(int windowID, PlayerInventory playerInventory, PacketBuffer networkBuffer) {
        ArtistTableCanvasStorage canvasStorage = ArtistTableCanvasStorage.createForClientSideContainer();
        return new ArtistTableContainer(windowID, playerInventory, canvasStorage, IWorldPosCallable.field_221489_a);
    }

    public void updatePaintingName(String newPaintingName) {
        this.paintingName = newPaintingName;
        this.updatePaintingOutput();
    }

    public void updatePaintingOutput() {
        ItemStack existingStack = this.inventoryOut.func_70301_a(0);
        ItemStack outStack = this.isCanvasReady() ? (existingStack.func_190926_b() ? new ItemStack((IItemProvider)ModItems.PAINTING) : existingStack) : ItemStack.field_190927_a;
        if (!outStack.func_190926_b()) {
            if (StringUtils.isBlank((CharSequence)this.paintingName)) {
                if (existingStack.func_82837_s()) {
                    existingStack.func_135074_t();
                }
                FrameItem.setCachedPaintingName(outStack, this.paintingName);
            } else if (!this.paintingName.equals(FrameItem.getCachedAuthorName(outStack))) {
                FrameItem.setCachedPaintingName(outStack, this.paintingName);
            }
            String authorName = this.player.func_200200_C_().getString();
            if (!authorName.equals(FrameItem.getCachedAuthorName(outStack))) {
                FrameItem.setCachedAuthorName(outStack, authorName);
            }
        }
        this.inventoryOut.func_70299_a(0, outStack);
    }

    protected ItemStack takePainting(PlayerEntity player, ItemStack outStack) {
        DummyCanvasData combinedCanvasData = this.getCanvasCombination().canvasData;
        PaintingData paintingData = Helper.createNewPainting(this.world, combinedCanvasData, player.func_200200_C_().getString(), this.paintingName);
        FrameItem.setPaintingData(outStack, paintingData);
        FrameItem.setBlockSize(outStack, new int[]{paintingData.getWidth() / paintingData.getResolution().getNumeric(), paintingData.getHeight() / paintingData.getResolution().getNumeric()});
        if (!player.func_184812_l_()) {
            this.canvasStorage.func_174888_l();
        }
        return outStack;
    }

    public void updateCanvasCombination() {
        this.canvasCombination = new CanvasCombination(this.canvasStorage, this.world);
        this.updatePaintingOutput();
    }

    public CanvasCombination getCanvasCombination() {
        return this.canvasCombination;
    }

    public boolean isCanvasReady() {
        return this.canvasCombination.state == CanvasCombination.State.READY;
    }

    public boolean canvasLoading() {
        return this.canvasCombination.state == CanvasCombination.State.NOT_LOADED;
    }

    public boolean func_94530_a(ItemStack stack, Slot slotIn) {
        return slotIn.field_75224_c != this.inventoryOut && super.func_94530_a(stack, slotIn);
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int sourceSlotIndex) {
        ItemStack outStack = ItemStack.field_190927_a;
        Slot sourceSlot = (Slot)this.field_75151_b.get(sourceSlotIndex);
        if (sourceSlot != null && sourceSlot.func_75216_d()) {
            ItemStack sourceStack = sourceSlot.func_75211_c();
            outStack = sourceStack.func_77946_l();
            if (sourceSlotIndex == 0) {
                if (!this.func_75135_a(sourceStack, 2, 10, true)) {
                    return ItemStack.field_190927_a;
                }
                sourceSlot.func_75220_a(sourceStack, outStack);
            } else if (sourceStack.func_77973_b() == ModItems.PALETTE) {
                if (!this.func_75135_a(sourceStack, 0, 1, false)) {
                    return ItemStack.field_190927_a;
                }
            } else {
                return ItemStack.field_190927_a;
            }
            if (sourceStack.func_190926_b()) {
                sourceSlot.func_75215_d(ItemStack.field_190927_a);
            } else {
                sourceSlot.func_75218_e();
            }
            if (sourceStack.func_190916_E() == outStack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            sourceSlot.func_190901_a(playerIn, sourceStack);
        }
        return outStack;
    }

    public boolean func_75145_c(PlayerEntity player) {
        return this.canvasStorage.func_70300_a(player);
    }

    public class SlotOutput
    extends Slot {
        public SlotOutput(IInventory inventoryIn, int index, int xPosition, int yPosition) {
            super(inventoryIn, index, xPosition, yPosition);
        }

        public boolean func_75214_a(ItemStack stack) {
            return false;
        }

        public ItemStack func_190901_a(PlayerEntity player, ItemStack stack) {
            return ArtistTableContainer.this.takePainting(player, stack);
        }
    }

    public class SlotFrameInput
    extends Slot {
        public SlotFrameInput(IInventory inventoryIn, int index, int xPosition, int yPosition) {
            super(inventoryIn, index, xPosition, yPosition);
        }

        public boolean func_75214_a(ItemStack stack) {
            return ArtistTableTileEntity.isItemValidForCanvasArea(stack);
        }
    }

    public class SlotCanvas
    extends Slot {
        public SlotCanvas(IInventory inventoryIn, int index, int xPosition, int yPosition) {
            super(inventoryIn, index, xPosition, yPosition);
        }

        public boolean func_75214_a(ItemStack stack) {
            return ArtistTableTileEntity.isItemValidForCanvasArea(stack);
        }
    }
}

