/*
 * Decompiled with CFR 0.152.
 */
package com.dantaeusb.zetter.container;

import com.dantaeusb.zetter.Zetter;
import com.dantaeusb.zetter.canvastracker.CanvasServerTracker;
import com.dantaeusb.zetter.canvastracker.CanvasTrackerCapability;
import com.dantaeusb.zetter.canvastracker.ICanvasTracker;
import com.dantaeusb.zetter.client.renderer.CanvasRenderer;
import com.dantaeusb.zetter.container.painting.PaintingFrame;
import com.dantaeusb.zetter.container.painting.PaintingFrameBuffer;
import com.dantaeusb.zetter.core.Helper;
import com.dantaeusb.zetter.core.ModContainers;
import com.dantaeusb.zetter.core.ModItems;
import com.dantaeusb.zetter.core.ModNetwork;
import com.dantaeusb.zetter.item.CanvasItem;
import com.dantaeusb.zetter.item.PaletteItem;
import com.dantaeusb.zetter.network.packet.CCanvasBucketToolPacket;
import com.dantaeusb.zetter.network.packet.CPaintingFrameBufferPacket;
import com.dantaeusb.zetter.network.packet.CPaletteUpdatePacket;
import com.dantaeusb.zetter.network.packet.SCanvasNamePacket;
import com.dantaeusb.zetter.network.packet.SEaselCanvasChangePacket;
import com.dantaeusb.zetter.storage.CanvasData;
import com.dantaeusb.zetter.tileentity.EaselTileEntity;
import com.dantaeusb.zetter.tileentity.storage.EaselStorage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.Vector;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.play.NetworkPlayerInfo;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Tuple;
import net.minecraft.util.Util;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.PacketDistributor;

public class EaselContainer
extends Container {
    public static int FRAME_TIMEOUT = 5000;
    private final PlayerEntity player;
    private final World world;
    public static final int PALETTE_SLOTS = 14;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private boolean canvasReady = false;
    private CanvasData canvas;
    private EaselTileEntity tileEntity;
    private final EaselStorage easelStorage;
    private PaintingFrameBuffer canvasChanges;
    private final LinkedList<PaintingFrame> lastFrames = new LinkedList();
    private long lastFrameBufferSendClock = 0L;
    private long lastSyncReceivedClock = 0L;
    private long lastPushedFrameClock = 0L;
    private Notify firstLoadNotification = () -> {};

    public EaselContainer(int windowID, PlayerInventory invPlayer, EaselStorage easelStorage) {
        super(ModContainers.PAINTING, windowID);
        if (ModContainers.PAINTING == null) {
            throw new IllegalStateException("Must initialise containerTypeLockTableContainer before constructing a LockTableContainer!");
        }
        this.player = invPlayer.field_70458_d;
        this.world = invPlayer.field_70458_d.field_70170_p;
        this.easelStorage = easelStorage;
        this.canvasChanges = new PaintingFrameBuffer(System.currentTimeMillis());
        int PALETTE_SLOT_X_SPACING = 152;
        int PALETTE_SLOT_Y_SPACING = 94;
        int HOTBAR_XPOS = 8;
        int HOTBAR_YPOS = 161;
        int SLOT_X_SPACING = 18;
        this.func_75146_a(new Slot(this.easelStorage, 1, 152, 94){

            public boolean func_75214_a(ItemStack stack) {
                return stack.func_77973_b() == ModItems.PALETTE;
            }
        });
        if (!this.world.func_201670_d()) {
            ItemStack canvasStack = this.easelStorage.func_70301_a(0);
            String canvasName = CanvasItem.getCanvasCode(canvasStack);
            this.setCanvas(canvasName);
        }
        for (int x = 0; x < 9; ++x) {
            int slotNumber = x;
            this.func_75146_a(new Slot((IInventory)invPlayer, slotNumber, 8 + 18 * x, 161));
        }
    }

    public static EaselContainer createContainerServerSide(int windowID, PlayerInventory playerInventory, EaselTileEntity tileEntity, EaselStorage easelStorage) {
        EaselContainer easelContainer = new EaselContainer(windowID, playerInventory, easelStorage);
        easelContainer.tileEntity = tileEntity;
        easelStorage.setMarkDirtyNotificationLambda(easelContainer::markDirty);
        return easelContainer;
    }

    public static EaselContainer createContainerClientSide(int windowID, PlayerInventory playerInventory, PacketBuffer networkBuffer) {
        EaselStorage easelStorage = EaselStorage.createForClientSideContainer();
        String canvasName = SCanvasNamePacket.readCanvasName(networkBuffer);
        EaselContainer easelContainer = new EaselContainer(windowID, playerInventory, easelStorage);
        easelContainer.setCanvas(canvasName);
        return easelContainer;
    }

    @Nullable
    public EaselTileEntity getTileEntityReference() {
        return this.tileEntity;
    }

    public EaselStorage getEaselStorage() {
        return this.easelStorage;
    }

    public void setFirstLoadNotification(Notify firstLoadNotification) {
        this.firstLoadNotification = firstLoadNotification;
    }

    public void markDirty() {
        SEaselCanvasChangePacket canvasSyncMessage = new SEaselCanvasChangePacket(this.field_75152_c, this.easelStorage.getCanvasStack());
        ModNetwork.simpleChannel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)this.player), (Object)canvasSyncMessage);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190896_a(List<ItemStack> itemStacks) {
        super.func_190896_a(itemStacks);
        if (this.firstLoadNotification != null) {
            this.firstLoadNotification.invoke();
        }
    }

    public void handleCanvasChange(ItemStack canvasStack) {
        if (canvasStack.func_77973_b() == ModItems.CANVAS) {
            this.canvas = CanvasItem.getCanvasData(canvasStack, this.world);
            this.canvasReady = true;
        } else {
            this.canvas = null;
            this.canvasReady = false;
        }
        if (this.firstLoadNotification != null) {
            this.firstLoadNotification.invoke();
        }
    }

    public void setCanvas(String canvasName) {
        if (canvasName.isEmpty() || canvasName.equals(CanvasData.getCanvasCode(0))) {
            this.canvas = null;
            this.canvasReady = false;
            return;
        }
        ICanvasTracker canvasTracker = this.world.func_201670_d() ? (ICanvasTracker)this.world.getCapability(CanvasTrackerCapability.CAPABILITY_CANVAS_TRACKER).orElse(null) : (ICanvasTracker)this.world.func_73046_m().func_241755_D_().getCapability(CanvasTrackerCapability.CAPABILITY_CANVAS_TRACKER).orElse(null);
        if (canvasTracker == null) {
            Zetter.LOG.error("Cannot find world canvas capability");
            this.canvas = null;
            this.canvasReady = false;
            return;
        }
        CanvasData canvas = canvasTracker.getCanvasData(canvasName, CanvasData.class);
        if (canvas == null) {
            this.canvas = null;
            this.canvasReady = false;
            return;
        }
        this.canvas = canvas;
        this.canvasReady = true;
    }

    public int getPaletteColor(int paletteSlot) {
        ItemStack paletteStack = this.easelStorage.getPaletteStack();
        if (paletteStack.func_190926_b()) {
            return -16777216;
        }
        return PaletteItem.getPaletteColors(paletteStack)[paletteSlot];
    }

    public void setPaletteColor(int paletteSlot, int color) {
        ItemStack paletteStack = this.easelStorage.getPaletteStack();
        if (paletteStack.func_190926_b()) {
            return;
        }
        PaletteItem.updatePaletteColor(paletteStack, paletteSlot, color);
        this.easelStorage.func_70296_d();
    }

    public void sendPaletteUpdatePacket(int paletteSlot, int color) {
        if (!this.isPaletteAvailable()) {
            return;
        }
        CPaletteUpdatePacket paletteUpdatePacket = new CPaletteUpdatePacket(paletteSlot, color);
        Zetter.LOG.debug("Sending Palette Update: " + paletteUpdatePacket);
        ModNetwork.simpleChannel.sendToServer((Object)paletteUpdatePacket);
    }

    public CanvasData getCanvasData() {
        return this.canvas;
    }

    public boolean isCanvasAvailable() {
        return this.canvasReady;
    }

    public boolean isPaletteAvailable() {
        ItemStack paletteStack = this.easelStorage.getPaletteStack();
        return !paletteStack.func_190926_b();
    }

    public void tick() {
        this.checkFrameBuffer();
        this.dropOldFrames();
    }

    public void writePixelOnCanvasClientSide(int pixelX, int pixelY, int color, UUID playerId) {
        if (!this.canvasReady) {
            return;
        }
        int index = this.canvas.getPixelIndex(pixelX, pixelY);
        if (this.writePixelOnCanvas(index, color)) {
            this.checkFrameBuffer();
            this.getCanvasChanges().writeChange(this.world.func_82737_E(), index, color);
            PaintingFrame newFrame = new PaintingFrame(System.currentTimeMillis(), (short)index, color, playerId);
            this.placeFrame(newFrame);
            this.updateTextureClient();
        }
    }

    public void eyedropper(int slotIndex, int pixelX, int pixelY) {
        int newColor = this.canvas.getColorAt(pixelX, pixelY);
        this.setPaletteColor(slotIndex, newColor);
        this.sendPaletteUpdatePacket(slotIndex, newColor);
    }

    public void bucket(int pixelX, int pixelY, int color) {
        int position = this.canvas.getPixelIndex(pixelX, pixelY);
        CCanvasBucketToolPacket bucketToolPacket = new CCanvasBucketToolPacket(position, color);
        Zetter.LOG.debug("Sending Bucket Tool Packet: " + bucketToolPacket);
        ModNetwork.simpleChannel.sendToServer((Object)bucketToolPacket);
    }

    protected void updateTextureClient() {
        CanvasRenderer.getInstance().updateCanvasTexture(this.canvas);
    }

    private void writePixelOnCanvasServerSide(int index, int color) {
        this.writePixelOnCanvas(index, color);
        this.easelStorage.getPaletteStack().func_222118_a(1, (LivingEntity)this.player, player -> {});
    }

    private boolean writePixelOnCanvas(int index, int color) {
        if (!this.canvasReady) {
            return false;
        }
        if (!this.isPaletteAvailable()) {
            return false;
        }
        if (this.canvas.getColorAt(index) == color) {
            return false;
        }
        this.getCanvasData().updateCanvasPixel(index, color);
        return true;
    }

    protected void checkFrameBuffer() {
        if (this.getCanvasChanges().isEmpty()) {
            try {
                this.canvasChanges.updateStartFrameTime(System.currentTimeMillis());
            }
            catch (Exception e) {
                Zetter.LOG.error("Cannot update Painting Frame Buffer start time: " + e.getMessage());
            }
            return;
        }
        if (this.canvasChanges.shouldBeSent(System.currentTimeMillis())) {
            if (this.world.func_201670_d()) {
                this.canvasChanges.getFrames(this.player.func_110124_au());
                CPaintingFrameBufferPacket paintingFrameBufferPacket = new CPaintingFrameBufferPacket(this.canvasChanges);
                ModNetwork.simpleChannel.sendToServer((Object)paintingFrameBufferPacket);
                this.lastFrameBufferSendClock = System.currentTimeMillis();
            } else {
                Zetter.LOG.warn("Unnecessary Painting Frame Buffer check on server");
            }
            this.canvasChanges = null;
        }
    }

    protected PaintingFrameBuffer getCanvasChanges() {
        if (this.canvasChanges == null) {
            this.canvasChanges = new PaintingFrameBuffer(System.currentTimeMillis());
        }
        return this.canvasChanges;
    }

    public void processFrameBufferServer(PaintingFrameBuffer paintingFrameBuffer, UUID ownerId) {
        long currentTime = this.world.func_82737_E();
        for (PaintingFrame frame : paintingFrameBuffer.getFrames(ownerId)) {
            if (currentTime - frame.getFrameTime() > (long)FRAME_TIMEOUT) {
                Zetter.LOG.debug("Skipping painting frame, too old");
                continue;
            }
            this.writePixelOnCanvasServerSide(frame.getPixelIndex(), frame.getColor());
        }
        ((CanvasServerTracker)Helper.getWorldCanvasTracker(this.world)).markCanvasDesync(this.canvas.func_195925_e());
    }

    public void processBucketToolServer(int position, int bucketColor) {
        int width = this.canvas.getWidth();
        int height = this.canvas.getHeight();
        int length = width * height;
        int replacedColor = this.canvas.getColorAt(position);
        LinkedList<Integer> positionsQueue = new LinkedList<Integer>();
        Vector checkedQueue = new Vector();
        Vector<Integer> paintQueue = new Vector<Integer>();
        positionsQueue.add(position);
        paintQueue.add(position);
        do {
            EaselContainer.getNeighborPositions((Integer)positionsQueue.pop(), width, length).filter(currentPosition -> !checkedQueue.contains(currentPosition)).forEach(currentPosition -> {
                if (this.canvas.getColorAt((int)currentPosition) == replacedColor) {
                    positionsQueue.add((Integer)currentPosition);
                    paintQueue.add((Integer)currentPosition);
                }
                checkedQueue.add(currentPosition);
            });
        } while (!positionsQueue.isEmpty());
        Iterator iterator = paintQueue.iterator();
        while (iterator.hasNext()) {
            int updatePosition = (Integer)iterator.next();
            this.writePixelOnCanvasServerSide(updatePosition, bucketColor);
        }
        ((CanvasServerTracker)Helper.getWorldCanvasTracker(this.world)).markCanvasDesync(this.canvas.func_195925_e());
    }

    public static Stream<Integer> getNeighborPositions(int currentCenter, int width, int length) {
        int bottomPosition;
        int rightPosition;
        int leftPosition;
        ArrayList<Integer> neighborPositions = new ArrayList<Integer>(4);
        int topPosition = currentCenter - width;
        if (topPosition >= 0) {
            neighborPositions.add(topPosition);
        }
        if ((leftPosition = currentCenter - 1) >= 0 && leftPosition / width == currentCenter / width) {
            neighborPositions.add(leftPosition);
        }
        if ((rightPosition = currentCenter + 1) < length && rightPosition / width == currentCenter / width) {
            neighborPositions.add(rightPosition);
        }
        if ((bottomPosition = currentCenter + width) < length) {
            neighborPositions.add(bottomPosition);
        }
        return neighborPositions.stream();
    }

    public void processSync(CanvasData canvasData, long packetTimestamp) {
        long timestamp = System.currentTimeMillis();
        NetworkPlayerInfo playerInfo = Minecraft.func_71410_x().func_147114_u().func_175102_a(this.player.func_110124_au());
        int latency = playerInfo.func_178853_c();
        latency = (int)((double)latency * 1.1);
        latency = Math.max(latency, 50);
        long timeSinceLastFrameBufferSent = timestamp - this.lastFrameBufferSendClock;
        long adjustedTimestamp = System.currentTimeMillis();
        adjustedTimestamp -= (long)latency * 2L;
        boolean mightDesync = false;
        Tuple lowTrustInterval = new Tuple((Object)(adjustedTimestamp -= timeSinceLastFrameBufferSent), (Object)(timestamp - this.lastFrameBufferSendClock));
        Zetter.LOG.debug("Latency: " + latency);
        for (PaintingFrame oldFrame : this.lastFrames) {
            if (oldFrame.getFrameTime() < (Long)lowTrustInterval.func_76341_a()) continue;
            if (oldFrame.getFrameTime() < (Long)lowTrustInterval.func_76340_b()) {
                mightDesync = true;
            }
            canvasData.updateCanvasPixel(oldFrame.getPixelIndex(), oldFrame.getColor());
        }
        if (mightDesync) {
            CanvasRenderer.getInstance().queueCanvasTextureUpdate(canvasData.getType(), canvasData.func_195925_e());
        }
        this.canvas = canvasData;
        this.lastSyncReceivedClock = System.currentTimeMillis();
    }

    protected void placeFrame(PaintingFrame frame) {
        this.lastFrames.add(frame);
        this.lastPushedFrameClock = System.currentTimeMillis();
    }

    protected void dropOldFrames() {
        long minTime = Util.func_211177_b() - (long)(FRAME_TIMEOUT * 50);
        Iterator iterator = this.lastFrames.iterator();
        while (iterator.hasNext()) {
            PaintingFrame oldFrame = (PaintingFrame)iterator.next();
            if (oldFrame.getFrameTime() < minTime) {
                iterator.remove();
                continue;
            }
            return;
        }
    }

    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
        if (this.world.func_201670_d() && !this.getCanvasChanges().isEmpty()) {
            this.canvasChanges.getFrames(playerIn.func_110124_au());
            CPaintingFrameBufferPacket modePacket = new CPaintingFrameBufferPacket(this.canvasChanges);
            ModNetwork.simpleChannel.sendToServer((Object)modePacket);
            this.lastFrameBufferSendClock = System.currentTimeMillis();
        }
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int sourceSlotIndex) {
        ItemStack outStack = ItemStack.field_190927_a;
        Slot sourceSlot = (Slot)this.field_75151_b.get(sourceSlotIndex);
        if (sourceSlot != null && sourceSlot.func_75216_d()) {
            ItemStack sourceStack = sourceSlot.func_75211_c();
            outStack = sourceStack.func_77946_l();
            if (sourceSlotIndex == 0) {
                if (!this.func_75135_a(sourceStack, 2, 10, true)) {
                    return ItemStack.field_190927_a;
                }
                sourceSlot.func_75220_a(sourceStack, outStack);
            } else if (sourceStack.func_77973_b() == ModItems.PALETTE) {
                if (!this.func_75135_a(sourceStack, 0, 1, false)) {
                    return ItemStack.field_190927_a;
                }
            } else {
                return ItemStack.field_190927_a;
            }
            if (sourceStack.func_190926_b()) {
                sourceSlot.func_75215_d(ItemStack.field_190927_a);
            } else {
                sourceSlot.func_75218_e();
            }
            if (sourceStack.func_190916_E() == outStack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            sourceSlot.func_190901_a(playerIn, sourceStack);
        }
        return outStack;
    }

    public boolean func_75145_c(PlayerEntity player) {
        return this.easelStorage.func_70300_a(player);
    }

    @FunctionalInterface
    public static interface Notify {
        public void invoke();
    }
}

