/*
 * Decompiled with CFR 0.152.
 */
package com.dantaeusb.zetter.container.artisttable;

import com.dantaeusb.zetter.client.renderer.CanvasRenderer;
import com.dantaeusb.zetter.core.Helper;
import com.dantaeusb.zetter.core.ModItems;
import com.dantaeusb.zetter.item.CanvasItem;
import com.dantaeusb.zetter.storage.AbstractCanvasData;
import com.dantaeusb.zetter.storage.CanvasData;
import com.dantaeusb.zetter.storage.DummyCanvasData;
import com.dantaeusb.zetter.tileentity.storage.ArtistTableCanvasStorage;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Tuple;
import net.minecraft.world.World;

public class CanvasCombination {
    public static final int[][] paintingShapes = new int[][]{{1, 1}, {1, 2}, {1, 3}, {2, 1}, {2, 2}, {2, 3}, {2, 4}, {3, 1}, {3, 2}, {3, 3}, {3, 4}, {4, 2}, {4, 3}, {4, 4}};
    public final State state;
    public final Rectangle rectangle;
    @Nullable
    public final DummyCanvasData canvasData;

    public CanvasCombination(ArtistTableCanvasStorage canvasStorage, World world) {
        Tuple min = null;
        Tuple max = null;
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 4; ++x) {
                if (canvasStorage.func_70301_a(y * 4 + x) == ItemStack.field_190927_a) continue;
                if (min == null) {
                    min = new Tuple((Object)x, (Object)y);
                }
                if (max == null) {
                    max = new Tuple((Object)x, (Object)y);
                    continue;
                }
                if ((Integer)max.func_76341_a() < x) {
                    max = new Tuple((Object)x, max.func_76340_b());
                }
                if ((Integer)max.func_76340_b() >= y) continue;
                max = new Tuple(max.func_76341_a(), (Object)y);
            }
        }
        if (min == null || max == null) {
            this.state = State.INVALID_SHAPE;
            this.rectangle = CanvasCombination.getZeroRect();
            this.canvasData = null;
            return;
        }
        boolean canvasesReady = true;
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 4; ++x) {
                ItemStack currentStack = canvasStorage.func_70301_a(y * 4 + x);
                if (currentStack == ItemStack.field_190927_a) {
                    if (x < (Integer)min.func_76341_a() || x > (Integer)max.func_76341_a() || y < (Integer)min.func_76340_b() || y > (Integer)max.func_76340_b()) continue;
                    this.state = State.INVALID_SHAPE;
                    this.rectangle = CanvasCombination.getZeroRect();
                    this.canvasData = null;
                    return;
                }
                if (currentStack.func_77973_b() != ModItems.CANVAS) continue;
                if (x < (Integer)min.func_76341_a() || x > (Integer)max.func_76341_a() || y < (Integer)min.func_76340_b() || y > (Integer)max.func_76340_b()) {
                    this.state = State.INVALID_SHAPE;
                    this.rectangle = CanvasCombination.getZeroRect();
                    this.canvasData = null;
                    return;
                }
                if (CanvasItem.getCanvasData(currentStack, world) != null) continue;
                CanvasRenderer.getInstance().queueCanvasTextureUpdate(AbstractCanvasData.Type.CANVAS, CanvasItem.getCanvasCode(currentStack));
                canvasesReady = false;
            }
        }
        if (!canvasesReady) {
            this.state = State.NOT_LOADED;
            this.rectangle = CanvasCombination.getZeroRect();
            this.canvasData = null;
            return;
        }
        Rectangle rectangle = CanvasCombination.getRect(min, max);
        boolean shapeAvailable = false;
        for (int[] shape : paintingShapes) {
            if (rectangle.width != shape[0] || rectangle.height != shape[1]) continue;
            shapeAvailable = true;
        }
        if (!shapeAvailable) {
            this.state = State.INVALID_SHAPE;
            this.rectangle = CanvasCombination.getZeroRect();
            this.canvasData = null;
            return;
        }
        this.state = State.READY;
        this.rectangle = rectangle;
        this.canvasData = CanvasCombination.createCanvasData(canvasStorage, rectangle, world);
    }

    public static DummyCanvasData createCanvasData(ArtistTableCanvasStorage canvasStorage, Rectangle rectangle, World world) {
        int pixelWidth = rectangle.width * Helper.getResolution().getNumeric();
        int pixelHeight = rectangle.height * Helper.getResolution().getNumeric();
        ByteBuffer color = ByteBuffer.allocate(pixelWidth * pixelHeight * 4);
        for (int slotY = rectangle.y; slotY < rectangle.y + rectangle.height; ++slotY) {
            for (int slotX = rectangle.x; slotX < rectangle.x + rectangle.width; ++slotX) {
                int colorIndex;
                int bigY;
                int bigX;
                int smallX;
                int smallY;
                ItemStack canvasStack = canvasStorage.func_70301_a(slotY * 4 + slotX);
                CanvasData smallCanvasData = CanvasItem.getCanvasData(canvasStack, world);
                int relativeX = slotX - rectangle.x;
                int relativeY = slotY - rectangle.y;
                if (smallCanvasData != null) {
                    for (smallY = 0; smallY < smallCanvasData.getHeight(); ++smallY) {
                        for (smallX = 0; smallX < smallCanvasData.getWidth(); ++smallX) {
                            bigX = relativeX * Helper.getResolution().getNumeric() + smallX;
                            bigY = relativeY * Helper.getResolution().getNumeric() + smallY;
                            colorIndex = (bigY * pixelWidth + bigX) * 4;
                            color.putInt(colorIndex, smallCanvasData.getColorAt(smallX, smallY));
                        }
                    }
                    continue;
                }
                for (smallY = 0; smallY < Helper.getResolution().getNumeric(); ++smallY) {
                    for (smallX = 0; smallX < Helper.getResolution().getNumeric(); ++smallX) {
                        bigX = relativeX * Helper.getResolution().getNumeric() + smallX;
                        bigY = relativeY * Helper.getResolution().getNumeric() + smallY;
                        colorIndex = (bigY * pixelWidth + bigX) * 4;
                        color.putInt(colorIndex, Helper.CANVAS_COLOR);
                    }
                }
            }
        }
        DummyCanvasData combinedCanvasData = Helper.getCombinedCanvas();
        combinedCanvasData.initData(Helper.getResolution(), pixelWidth, pixelHeight, color.array());
        if (world.func_201670_d()) {
            Helper.getWorldCanvasTracker(world).registerCanvasData(combinedCanvasData);
        }
        return combinedCanvasData;
    }

    public static Rectangle getRect(Tuple<Integer, Integer> min, Tuple<Integer, Integer> max) {
        int width = (Integer)max.func_76341_a() + 1 - (Integer)min.func_76341_a();
        int height = (Integer)max.func_76340_b() + 1 - (Integer)min.func_76340_b();
        return new Rectangle((Integer)min.func_76341_a(), (Integer)min.func_76340_b(), width, height);
    }

    public static Rectangle getZeroRect() {
        return new Rectangle(0, 0, 0, 0);
    }

    private static class Rectangle {
        public final int x;
        public final int y;
        public final int width;
        public final int height;

        Rectangle(int x, int y, int width, int height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }
    }

    public static enum State {
        INVALID_SHAPE,
        NOT_LOADED,
        READY;

    }
}

