/*
 * Decompiled with CFR 0.152.
 */
package com.dantaeusb.zetter.core;

import com.dantaeusb.zetter.Zetter;
import com.dantaeusb.zetter.canvastracker.CanvasTrackerCapability;
import com.dantaeusb.zetter.canvastracker.ICanvasTracker;
import com.dantaeusb.zetter.entity.item.CustomPaintingEntity;
import com.dantaeusb.zetter.storage.AbstractCanvasData;
import com.dantaeusb.zetter.storage.CanvasData;
import com.dantaeusb.zetter.storage.DummyCanvasData;
import com.dantaeusb.zetter.storage.PaintingData;
import javax.annotation.Nullable;
import net.minecraft.world.World;

public class Helper {
    public static int CANVAS_COLOR = -2041138;
    private static Helper instance;
    public static final String COMBINED_CANVAS_CODE = "zetter_combined_canvas";
    public static final String FALLBACK_CANVAS_CODE = "zetter_fallback_canvas";
    private final DummyCanvasData combinedCanvas = new DummyCanvasData("zetter_combined_canvas");
    private final DummyCanvasData fallbackCanvas = new DummyCanvasData();

    private Helper() {
    }

    public static Helper getInstance() {
        if (instance == null) {
            instance = new Helper();
        }
        return instance;
    }

    public static AbstractCanvasData.Resolution getBasicResolution() {
        return AbstractCanvasData.Resolution.x16;
    }

    public static AbstractCanvasData.Resolution getResolution() {
        return AbstractCanvasData.Resolution.x16;
    }

    @Nullable
    public static ICanvasTracker getWorldCanvasTracker(World world) {
        ICanvasTracker canvasTracker = !world.func_201670_d() ? (ICanvasTracker)world.func_73046_m().func_241755_D_().getCapability(CanvasTrackerCapability.CAPABILITY_CANVAS_TRACKER).orElse(null) : (ICanvasTracker)world.getCapability(CanvasTrackerCapability.CAPABILITY_CANVAS_TRACKER).orElse(null);
        if (canvasTracker == null) {
            Zetter.LOG.error("Cannot find world canvas capability");
            return null;
        }
        return canvasTracker;
    }

    public static DummyCanvasData getCombinedCanvas() {
        return Helper.getInstance().combinedCanvas;
    }

    public static DummyCanvasData getFallbackCanvas() {
        return Helper.getInstance().fallbackCanvas;
    }

    public static PaintingData createNewPainting(World world, AbstractCanvasData combinedCanvasData, String authorName, String title) {
        ICanvasTracker canvasTracker = Helper.getWorldCanvasTracker(world);
        int newId = canvasTracker.getNextPaintingId();
        PaintingData paintingData = new PaintingData(newId);
        paintingData.copyFrom(combinedCanvasData);
        paintingData.setMetaProperties(authorName, title);
        canvasTracker.registerCanvasData(paintingData);
        return paintingData;
    }

    public static CanvasData createNewCanvas(World worldIn) {
        ICanvasTracker canvasTracker = Helper.getWorldCanvasTracker(worldIn);
        int newId = canvasTracker.getNextCanvasId();
        CanvasData canvasData = new CanvasData(newId);
        canvasTracker.registerCanvasData(canvasData);
        return canvasData;
    }

    public static String getFrameKey(CustomPaintingEntity.Materials material, boolean plated) {
        String key = material.toString();
        if (plated) {
            key = key + "/plated";
        }
        return key;
    }

    private class DataStorage {
        private DataStorage() {
        }
    }
}

