/*
 * Decompiled with CFR 0.152.
 */
package com.dantaeusb.zetter.core;

import com.dantaeusb.zetter.core.Helper;
import com.dantaeusb.zetter.core.ModBlocks;
import com.dantaeusb.zetter.entity.item.CustomPaintingEntity;
import com.dantaeusb.zetter.item.CanvasItem;
import com.dantaeusb.zetter.item.FrameItem;
import com.dantaeusb.zetter.item.PaintingItem;
import com.dantaeusb.zetter.item.PaintsItem;
import com.dantaeusb.zetter.item.PaletteItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="zetter", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModItems {
    private static final List<Item> ITEMS = new ArrayList<Item>();
    public static final BlockItem EASEL = ModItems.registerBlockItem("easel", ModBlocks.EASEL);
    public static final BlockItem ARTIST = ModItems.registerBlockItem("artist_table", ModBlocks.ARTIST_TABLE);
    public static final CanvasItem CANVAS = (CanvasItem)ModItems.register("canvas", new CanvasItem());
    public static final PaintingItem PAINTING = (PaintingItem)ModItems.register("painting", new PaintingItem());
    public static final PaintsItem PAINTS = (PaintsItem)ModItems.register("paints", new PaintsItem());
    public static final PaletteItem PALETTE = (PaletteItem)ModItems.register("palette", new PaletteItem());
    public static final HashMap<String, Item> FRAMES = new HashMap();
    public static final FrameItem ACACIA_FRAME = ModItems.registerFrame("acacia_basic_frame", new FrameItem(CustomPaintingEntity.Materials.ACACIA, false));
    public static final FrameItem BIRCH_FRAME = ModItems.registerFrame("birch_basic_frame", new FrameItem(CustomPaintingEntity.Materials.BIRCH, false));
    public static final FrameItem DARK_OAK_FRAME = ModItems.registerFrame("dark_oak_basic_frame", new FrameItem(CustomPaintingEntity.Materials.DARK_OAK, false));
    public static final FrameItem JUNGLE_FRAME = ModItems.registerFrame("jungle_basic_frame", new FrameItem(CustomPaintingEntity.Materials.JUNGLE, false));
    public static final FrameItem OAK_FRAME = ModItems.registerFrame("oak_basic_frame", new FrameItem(CustomPaintingEntity.Materials.OAK, false));
    public static final FrameItem SPRUCE_FRAME = ModItems.registerFrame("spruce_basic_frame", new FrameItem(CustomPaintingEntity.Materials.SPRUCE, false));
    public static final FrameItem CRIMSON_FRAME = ModItems.registerFrame("crimson_basic_frame", new FrameItem(CustomPaintingEntity.Materials.CRIMSON, false));
    public static final FrameItem WARPED_FRAME = ModItems.registerFrame("warped_basic_frame", new FrameItem(CustomPaintingEntity.Materials.WARPED, false));
    public static final FrameItem ACACIA_PLATED_FRAME = ModItems.registerFrame("acacia_plated_frame", new FrameItem(CustomPaintingEntity.Materials.ACACIA, true));
    public static final FrameItem BIRCH_PLATED_FRAME = ModItems.registerFrame("birch_plated_frame", new FrameItem(CustomPaintingEntity.Materials.BIRCH, true));
    public static final FrameItem DARK_OAK_PLATED_FRAME = ModItems.registerFrame("dark_oak_plated_frame", new FrameItem(CustomPaintingEntity.Materials.DARK_OAK, true));
    public static final FrameItem JUNGLE_PLATED_FRAME = ModItems.registerFrame("jungle_plated_frame", new FrameItem(CustomPaintingEntity.Materials.JUNGLE, true));
    public static final FrameItem OAK_PLATED_FRAME = ModItems.registerFrame("oak_plated_frame", new FrameItem(CustomPaintingEntity.Materials.OAK, true));
    public static final FrameItem SPRUCE_PLATED_FRAME = ModItems.registerFrame("spruce_plated_frame", new FrameItem(CustomPaintingEntity.Materials.SPRUCE, true));
    public static final FrameItem CRIMSON_PLATED_FRAME = ModItems.registerFrame("crimson_plated_frame", new FrameItem(CustomPaintingEntity.Materials.CRIMSON, true));
    public static final FrameItem WARPED_PLATED_FRAME = ModItems.registerFrame("warped_plated_frame", new FrameItem(CustomPaintingEntity.Materials.WARPED, true));
    public static final FrameItem IRON_FRAME = ModItems.registerFrame("iron_frame", new FrameItem(CustomPaintingEntity.Materials.IRON, false));
    public static final FrameItem GOLD_FRAME = ModItems.registerFrame("gold_basic_frame", new FrameItem(CustomPaintingEntity.Materials.GOLD, false));
    public static final FrameItem GOLD_PLATE_FRAME = ModItems.registerFrame("gold_plated_frame", new FrameItem(CustomPaintingEntity.Materials.GOLD, true));

    private static BlockItem registerBlockItem(String name, Block block) {
        Item.Properties itemProps = new Item.Properties().func_200916_a(ItemGroup.field_78040_i);
        BlockItem blockItem = new BlockItem(block, itemProps);
        return (BlockItem)ModItems.register(name, (Item)blockItem);
    }

    private static FrameItem registerFrame(String name, FrameItem item) {
        item.setRegistryName("zetter", name);
        ITEMS.add(item);
        FRAMES.put(Helper.getFrameKey(item.getMaterial(), item.hasPlate()), item);
        return item;
    }

    private static Item register(String name, Item item) {
        item.setRegistryName("zetter", name);
        ITEMS.add(item);
        return item;
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        ITEMS.forEach(item -> event.getRegistry().register((IForgeRegistryEntry)item));
        ITEMS.clear();
    }
}

