/*
 * Decompiled with CFR 0.152.
 */
package com.dantaeusb.zetter.core;

import com.dantaeusb.zetter.network.packet.CCanvasBucketToolPacket;
import com.dantaeusb.zetter.network.packet.CCanvasRequestPacket;
import com.dantaeusb.zetter.network.packet.CCanvasUnloadRequestPacket;
import com.dantaeusb.zetter.network.packet.CPaintingFrameBufferPacket;
import com.dantaeusb.zetter.network.packet.CPaletteUpdatePacket;
import com.dantaeusb.zetter.network.packet.CUpdatePaintingPacket;
import com.dantaeusb.zetter.network.packet.SCanvasSyncMessage;
import com.dantaeusb.zetter.network.packet.SEaselCanvasChangePacket;
import com.dantaeusb.zetter.network.packet.SPaintingSyncMessage;
import java.util.Optional;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;

@Mod.EventBusSubscriber(modid="zetter", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModNetwork {
    public static SimpleChannel simpleChannel;
    public static final ResourceLocation simpleChannelRL;
    public static final String MESSAGE_PROTOCOL_VERSION = "0.1";
    public static final byte PAINTING_FRAME = 21;
    public static final byte PAINTING_REQUEST_CANVAS = 22;
    public static final byte PAINTING_UNLOAD_CANVAS = 23;
    public static final byte CANVAS_SYNC = 24;
    public static final byte PALETTE_UPDATE = 25;
    public static final byte PAINTING_CREATE = 27;
    public static final byte EASEL_CANVAS_CHANGE = 28;
    public static final byte PAINTING_SYNC = 29;
    public static final byte PAINTING_BUCKET = 30;

    @SubscribeEvent
    public static void onCommonSetupEvent(FMLCommonSetupEvent event) {
        simpleChannel = NetworkRegistry.newSimpleChannel((ResourceLocation)simpleChannelRL, () -> MESSAGE_PROTOCOL_VERSION, ModNetwork::isThisProtocolAcceptedByClient, ModNetwork::isThisProtocolAcceptedByServer);
        simpleChannel.registerMessage(21, CPaintingFrameBufferPacket.class, CPaintingFrameBufferPacket::writePacketData, CPaintingFrameBufferPacket::readPacketData, CPaintingFrameBufferPacket::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        simpleChannel.registerMessage(22, CCanvasRequestPacket.class, CCanvasRequestPacket::writePacketData, CCanvasRequestPacket::readPacketData, CCanvasRequestPacket::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        simpleChannel.registerMessage(23, CCanvasUnloadRequestPacket.class, CCanvasUnloadRequestPacket::writePacketData, CCanvasUnloadRequestPacket::readPacketData, CCanvasUnloadRequestPacket::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        simpleChannel.registerMessage(24, SCanvasSyncMessage.class, SCanvasSyncMessage::writePacketData, SCanvasSyncMessage::readPacketData, SCanvasSyncMessage::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        simpleChannel.registerMessage(29, SPaintingSyncMessage.class, SPaintingSyncMessage::writePacketData, SPaintingSyncMessage::readPacketData, SPaintingSyncMessage::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        simpleChannel.registerMessage(25, CPaletteUpdatePacket.class, CPaletteUpdatePacket::writePacketData, CPaletteUpdatePacket::readPacketData, CPaletteUpdatePacket::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        simpleChannel.registerMessage(27, CUpdatePaintingPacket.class, CUpdatePaintingPacket::writePacketData, CUpdatePaintingPacket::readPacketData, CUpdatePaintingPacket::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        simpleChannel.registerMessage(28, SEaselCanvasChangePacket.class, SEaselCanvasChangePacket::writePacketData, SEaselCanvasChangePacket::readPacketData, SEaselCanvasChangePacket::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        simpleChannel.registerMessage(30, CCanvasBucketToolPacket.class, CCanvasBucketToolPacket::writePacketData, CCanvasBucketToolPacket::readPacketData, CCanvasBucketToolPacket::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
    }

    public static boolean isThisProtocolAcceptedByClient(String protocolVersion) {
        return MESSAGE_PROTOCOL_VERSION.equals(protocolVersion);
    }

    public static boolean isThisProtocolAcceptedByServer(String protocolVersion) {
        return MESSAGE_PROTOCOL_VERSION.equals(protocolVersion);
    }

    static {
        simpleChannelRL = new ResourceLocation("zetter", "zetter_channel");
    }
}

