/*
 * Decompiled with CFR 0.152.
 */
package com.dantaeusb.zetter.entity.item;

import com.dantaeusb.zetter.core.Helper;
import com.dantaeusb.zetter.core.ModEntities;
import com.dantaeusb.zetter.core.ModItems;
import com.dantaeusb.zetter.item.FrameItem;
import com.dantaeusb.zetter.storage.PaintingData;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.item.HangingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;
import org.apache.commons.lang3.Validate;

public class CustomPaintingEntity
extends HangingEntity
implements IEntityAdditionalSpawnData {
    public static final String NBT_TAG_FACING = "Facing";
    public static final String NBT_TAG_PAINTING_CODE = "PaintingCode";
    public static final String NBT_TAG_BLOCK_SIZE = "BlockSize";
    public static final String NBT_TAG_MATERIAL = "Material";
    public static final String NBT_TAG_HAS_PLATE = "HasPlate";
    protected String canvasCode;
    protected int blockWidth;
    protected int blockHeight;
    protected boolean hasPlate;
    protected Materials material;

    public CustomPaintingEntity(EntityType<? extends CustomPaintingEntity> type, World world) {
        super(type, world);
    }

    public CustomPaintingEntity(World world, BlockPos pos, Direction facing, Materials material, boolean hasPlate, String canvasCode, int[] blockSize) {
        super(ModEntities.CUSTOM_PAINTING_ENTITY, world, pos);
        this.material = material;
        this.hasPlate = hasPlate;
        this.canvasCode = canvasCode;
        this.blockWidth = blockSize[0];
        this.blockHeight = blockSize[1];
        this.func_174859_a(facing);
    }

    public String getCanvasCode() {
        if (this.canvasCode == null) {
            return "zetter_fallback_canvas";
        }
        return this.canvasCode;
    }

    public int getBlockWidth() {
        return this.blockWidth;
    }

    public int getBlockHeight() {
        return this.blockHeight;
    }

    public Materials getMaterial() {
        return this.material;
    }

    public boolean hasPlate() {
        return this.hasPlate;
    }

    protected float func_213316_a(Pose poseIn, EntitySize sizeIn) {
        return 0.0f;
    }

    protected void func_174859_a(Direction facingDirectionIn) {
        Validate.notNull((Object)facingDirectionIn);
        this.field_174860_b = facingDirectionIn;
        if (facingDirectionIn.func_176740_k().func_176722_c()) {
            this.field_70125_A = 0.0f;
            this.field_70177_z = this.field_174860_b.func_176736_b() * 90;
        } else {
            this.field_70125_A = -90 * facingDirectionIn.func_176743_c().func_179524_a();
            this.field_70177_z = 0.0f;
        }
        this.field_70127_C = this.field_70125_A;
        this.field_70126_B = this.field_70177_z;
        this.func_174856_o();
    }

    protected void func_174856_o() {
        if (this.field_174860_b != null) {
            double xCenter = (double)this.field_174861_a.func_177958_n() + 0.5;
            double yCenter = (double)this.field_174861_a.func_177956_o() + 0.5;
            double zCenter = (double)this.field_174861_a.func_177952_p() + 0.5;
            double thicknessOffset = 0.46875;
            double hCenterOffset = this.offs(this.func_82329_d());
            double vCenterOffset = this.offs(this.func_82330_g());
            xCenter -= (double)this.field_174860_b.func_82601_c() * thicknessOffset;
            zCenter -= (double)this.field_174860_b.func_82599_e() * thicknessOffset;
            Direction direction = this.field_174860_b.func_176735_f();
            this.func_226288_n_(xCenter += hCenterOffset * (double)direction.func_82601_c(), yCenter += vCenterOffset, zCenter += hCenterOffset * (double)direction.func_82599_e());
            double xWidth = this.func_82329_d();
            double yHeight = this.func_82330_g();
            double zWidth = this.func_82329_d();
            if (this.field_174860_b.func_176740_k() == Direction.Axis.Z) {
                zWidth = 1.0;
            } else {
                xWidth = 1.0;
            }
            xWidth = xWidth / 16.0 / 2.0;
            yHeight = yHeight / 16.0 / 2.0;
            zWidth = zWidth / 16.0 / 2.0;
            this.func_174826_a(new AxisAlignedBB(xCenter - xWidth, yCenter - yHeight, zCenter - zWidth, xCenter + xWidth, yCenter + yHeight, zCenter + zWidth));
        }
    }

    private double offs(int pixelSize) {
        return pixelSize % (Helper.getResolution().getNumeric() * 2) == 0 ? 0.5 : 0.0;
    }

    public double[] getRenderOffset() {
        double xOffset = (double)this.blockWidth / 2.0;
        double yOffset = (double)this.blockHeight / 2.0;
        return new double[]{xOffset, yOffset};
    }

    public ActionResultType func_184230_a(PlayerEntity player, Hand hand) {
        if (!this.hasPlate()) {
            return ActionResultType.PASS;
        }
        if (!player.func_130014_f_().func_201670_d()) {
            return ActionResultType.CONSUME;
        }
        PaintingData paintingData = Helper.getWorldCanvasTracker(this.field_70170_p).getCanvasData(this.canvasCode, PaintingData.class);
        String paintingName = paintingData.getPaintingName();
        String authorName = paintingData.getAuthorName();
        if (StringUtils.func_151246_b((String)paintingName)) {
            paintingName = new TranslationTextComponent("item.zetter.painting.unnamed").getString();
        }
        if (StringUtils.func_151246_b((String)authorName)) {
            authorName = new TranslationTextComponent("item.zetter.painting.unknown").getString();
        }
        player.func_146105_b((ITextComponent)new TranslationTextComponent("item.zetter.customPaintingByAuthor", new Object[]{paintingName, authorName}), true);
        return ActionResultType.CONSUME;
    }

    public void func_213281_b(CompoundNBT compound) {
        compound.func_74774_a(NBT_TAG_FACING, (byte)this.field_174860_b.func_176736_b());
        compound.func_74778_a(NBT_TAG_PAINTING_CODE, this.canvasCode);
        compound.func_74783_a(NBT_TAG_BLOCK_SIZE, new int[]{this.blockWidth, this.blockHeight});
        compound.func_74778_a(NBT_TAG_MATERIAL, this.material.toString());
        compound.func_74757_a(NBT_TAG_HAS_PLATE, this.hasPlate);
        super.func_213281_b(compound);
    }

    public void func_70037_a(CompoundNBT compound) {
        this.field_174860_b = Direction.func_176731_b((int)compound.func_74771_c(NBT_TAG_FACING));
        this.canvasCode = compound.func_74779_i(NBT_TAG_PAINTING_CODE);
        if (compound.func_74764_b(NBT_TAG_BLOCK_SIZE)) {
            int[] blockSize = compound.func_74759_k(NBT_TAG_BLOCK_SIZE);
            this.blockWidth = blockSize[0];
            this.blockHeight = blockSize[1];
        }
        this.material = compound.func_74764_b(NBT_TAG_MATERIAL) ? Materials.fromString(compound.func_74779_i(NBT_TAG_MATERIAL)) : Materials.DARK_OAK;
        this.hasPlate = compound.func_74764_b(NBT_TAG_HAS_PLATE) ? compound.func_74767_n(NBT_TAG_HAS_PLATE) : false;
        super.func_70037_a(compound);
        this.func_174859_a(this.field_174860_b);
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.func_179255_a(this.field_174861_a);
        buffer.writeByte((int)((byte)this.field_174860_b.func_176736_b()));
        buffer.func_211400_a(this.canvasCode, 64);
        buffer.writeInt(this.blockWidth);
        buffer.writeInt(this.blockHeight);
        buffer.func_211400_a(this.material.toString(), 64);
        buffer.writeBoolean(this.hasPlate);
    }

    public void readSpawnData(PacketBuffer buffer) {
        this.field_174861_a = buffer.func_179259_c();
        this.field_174860_b = Direction.func_176731_b((int)buffer.readByte());
        this.canvasCode = buffer.func_150789_c(64);
        this.blockWidth = buffer.readInt();
        this.blockHeight = buffer.readInt();
        this.material = Materials.fromString(buffer.func_150789_c(64));
        this.hasPlate = buffer.readBoolean();
        this.func_174859_a(this.field_174860_b);
    }

    public int func_82329_d() {
        return this.blockWidth * Helper.getResolution().getNumeric();
    }

    public int func_82330_g() {
        return this.blockHeight * Helper.getResolution().getNumeric();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = 16.0;
        return distance < (d0 = d0 * 64.0 * CustomPaintingEntity.func_184183_bd()) * d0;
    }

    public void func_110128_b(@Nullable Entity brokenEntity) {
        if (this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
            this.func_184185_a(SoundEvents.field_187691_dJ, 1.0f, 1.0f);
            ItemStack canvasStack = new ItemStack((IItemProvider)ModItems.FRAMES.get(Helper.getFrameKey(this.material, this.hasPlate)));
            PaintingData paintingData = Helper.getWorldCanvasTracker(this.field_70170_p).getCanvasData(this.canvasCode, PaintingData.class);
            FrameItem.setPaintingData(canvasStack, paintingData);
            FrameItem.setBlockSize(canvasStack, new int[]{this.blockWidth, this.blockHeight});
            this.func_199701_a_(canvasStack);
        }
    }

    public void func_70012_b(double x, double y, double z, float yaw, float pitch) {
        this.func_70107_b(x, y, z);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        BlockPos blockpos = this.field_174861_a.func_177963_a(x - this.func_226277_ct_(), y - this.func_226278_cu_(), z - this.func_226281_cx_());
        this.func_70107_b(blockpos.func_177958_n(), blockpos.func_177956_o(), blockpos.func_177952_p());
    }

    public void func_184523_o() {
        this.func_184185_a(SoundEvents.field_187694_dK, 1.0f, 1.0f);
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public static enum Materials {
        ACACIA("acacia", true, true),
        BIRCH("birch", true, true),
        DARK_OAK("dark_oak", true, true),
        JUNGLE("jungle", true, true),
        OAK("oak", true, true),
        SPRUCE("spruce", true, true),
        CRIMSON("crimson", true, true),
        WARPED("warped", true, true),
        IRON("iron", false, false),
        GOLD("gold", true, true);

        private static final Map<String, Materials> LOOKUP;
        private final String text;
        private final boolean canvasOffset;
        private final boolean canHavePlate;

        private Materials(String text, boolean canvasOffset, boolean canHavePlate) {
            this.text = text;
            this.canvasOffset = canvasOffset;
            this.canHavePlate = canHavePlate;
        }

        public String toString() {
            return this.text;
        }

        public boolean hasOffset() {
            return this.canvasOffset;
        }

        public boolean canHavePlate() {
            return this.canHavePlate;
        }

        @Nullable
        public static Materials fromString(String stringValue) {
            return LOOKUP.get(stringValue);
        }

        static {
            LOOKUP = Maps.uniqueIndex(Arrays.asList(Materials.values()), Materials::toString);
        }
    }
}

