/*
 * Decompiled with CFR 0.152.
 */
package com.dantaeusb.zetter.item;

import com.dantaeusb.zetter.Zetter;
import com.dantaeusb.zetter.canvastracker.ICanvasTracker;
import com.dantaeusb.zetter.core.Helper;
import com.dantaeusb.zetter.storage.CanvasData;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class CanvasItem
extends Item {
    public static final String NBT_TAG_CANVAS_CODE = "CanvasCode";

    public CanvasItem() {
        super(new Item.Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78040_i));
    }

    @Nullable
    public static CanvasData getCanvasData(ItemStack stack, World worldIn) {
        Item canvas = stack.func_77973_b();
        if (canvas instanceof CanvasItem) {
            return ((CanvasItem)canvas).getCustomCanvasData(stack, worldIn);
        }
        return null;
    }

    @Nullable
    protected CanvasData getCustomCanvasData(ItemStack stack, World world) {
        CanvasData canvasData = null;
        ICanvasTracker canvasTracker = Helper.getWorldCanvasTracker(world);
        if (canvasTracker != null) {
            canvasData = canvasTracker.getCanvasData(CanvasItem.getCanvasCode(stack), CanvasData.class);
        } else {
            Zetter.LOG.error("Unable to find CanvasTracker capability");
        }
        if ((canvasData == null || canvasData.func_195925_e().equals("zetter_fallback_canvas")) && world instanceof ServerWorld) {
            canvasData = CanvasItem.createCanvasData(stack, world);
        }
        return canvasData;
    }

    public static String getCanvasCode(ItemStack stack) {
        CompoundNBT compoundNBT = stack.func_77978_p();
        String canvasCode = "zetter_fallback_canvas";
        if (compoundNBT != null && compoundNBT.func_74764_b(NBT_TAG_CANVAS_CODE)) {
            canvasCode = compoundNBT.func_74779_i(NBT_TAG_CANVAS_CODE);
        }
        return canvasCode;
    }

    public static void setCanvasCode(ItemStack stack, String canvasCode) {
        stack.func_196082_o().func_74778_a(NBT_TAG_CANVAS_CODE, canvasCode);
    }

    public void func_77622_d(ItemStack stack, World worldIn, PlayerEntity playerIn) {
        if (worldIn.field_72995_K) {
            return;
        }
        CanvasItem.createCanvasData(stack, worldIn);
    }

    private static CanvasData createCanvasData(ItemStack stack, World worldIn) {
        CanvasData canvasData = Helper.createNewCanvas(worldIn);
        canvasData.initData(Helper.getResolution().getNumeric(), Helper.getResolution().getNumeric());
        CanvasItem.setCanvasCode(stack, canvasData.func_195925_e());
        return canvasData;
    }
}

