/*
 * Decompiled with CFR 0.152.
 */
package com.dantaeusb.zetter.item;

import com.dantaeusb.zetter.entity.item.CustomPaintingEntity;
import com.dantaeusb.zetter.item.PaintingItem;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class FrameItem
extends PaintingItem {
    private CustomPaintingEntity.Materials material;
    private boolean hasPlate;

    public FrameItem(CustomPaintingEntity.Materials material, boolean plated) {
        super(new Item.Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78040_i));
        this.material = material;
        this.hasPlate = plated;
    }

    public CustomPaintingEntity.Materials getMaterial() {
        return this.material;
    }

    public boolean hasPlate() {
        return this.hasPlate;
    }

    public static byte getHasPaintingPropertyOverride(ItemStack stack, @Nullable World world, @Nullable LivingEntity livingEntity) {
        EnumFrameStyle hasPainting = StringUtils.func_151246_b((String)FrameItem.getPaintingCode(stack)) ? EnumFrameStyle.EMPTY : EnumFrameStyle.PAINTING;
        return hasPainting.getPropertyOverrideValue();
    }

    public static void setBlockSize(ItemStack stack, int[] blockSize) {
        stack.func_196082_o().func_74783_a("BlockSize", blockSize);
    }

    @Nullable
    public static int[] getBlockSize(ItemStack stack) {
        CompoundNBT compoundNBT = stack.func_77978_p();
        if (compoundNBT == null) {
            return null;
        }
        return compoundNBT.func_74759_k("BlockSize");
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        BlockPos blockPos = context.func_195995_a();
        Direction direction = context.func_196000_l();
        BlockPos facePos = blockPos.func_177972_a(direction);
        PlayerEntity player = context.func_195999_j();
        ItemStack stack = context.func_195996_i();
        if (player != null && !this.canPlace(player, direction, stack, facePos)) {
            return ActionResultType.FAIL;
        }
        if (StringUtils.func_151246_b((String)FrameItem.getPaintingCode(stack))) {
            return ActionResultType.FAIL;
        }
        World world = context.func_195991_k();
        CustomPaintingEntity paintingEntity = new CustomPaintingEntity(world, facePos, direction, this.material, this.hasPlate, FrameItem.getPaintingCode(stack), FrameItem.getBlockSize(stack));
        if (paintingEntity.func_70518_d()) {
            if (!world.field_72995_K) {
                paintingEntity.func_184523_o();
                world.func_217376_c((Entity)paintingEntity);
            }
            player.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
            return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
        }
        return ActionResultType.CONSUME;
    }

    protected boolean canPlace(PlayerEntity playerIn, Direction directionIn, ItemStack itemStackIn, BlockPos posIn) {
        return !directionIn.func_176740_k().func_200128_b() && playerIn.func_175151_a(posIn, directionIn, itemStackIn);
    }

    public static enum EnumFrameStyle implements IStringSerializable
    {
        EMPTY(0, "empty", "Missing painting"),
        PAINTING(1, "painting", "Framed painting");

        private final byte nbtId;
        private final String name;
        private final String description;

        private EnumFrameStyle(int nbtId, String name, String description) {
            this.nbtId = (byte)nbtId;
            this.name = name;
            this.description = description;
        }

        public String toString() {
            return this.description;
        }

        public String func_176610_l() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public byte getPropertyOverrideValue() {
            return this.nbtId;
        }

        public static EnumFrameStyle fromNBT(CompoundNBT compoundNBT, String tagname) {
            byte hasPaintingValue = 0;
            if (compoundNBT != null && compoundNBT.func_74764_b(tagname)) {
                hasPaintingValue = compoundNBT.func_74771_c(tagname);
            }
            Optional<EnumFrameStyle> hasPainting = EnumFrameStyle.getEnumFromValue(hasPaintingValue);
            return hasPainting.orElse(EMPTY);
        }

        public void putIntoNBT(CompoundNBT compoundNBT, String tagName) {
            compoundNBT.func_74774_a(tagName, this.nbtId);
        }

        private static Optional<EnumFrameStyle> getEnumFromValue(byte ID) {
            for (EnumFrameStyle fullness : EnumFrameStyle.values()) {
                if (fullness.nbtId != ID) continue;
                return Optional.of(fullness);
            }
            return Optional.empty();
        }
    }
}

