/*
 * Decompiled with CFR 0.152.
 */
package com.dantaeusb.zetter.item;

import com.dantaeusb.zetter.storage.PaintingData;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PaintingItem
extends Item {
    public static final String NBT_TAG_CACHED_PAINTING_NAME = "CachedPaintingName";
    public static final String NBT_TAG_CACHED_AUTHOR_NAME = "CachedAuthorName";
    public static final String NBT_TAG_CACHED_STRING_SIZE = "CachedStringSize";

    public PaintingItem() {
        super(new Item.Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78040_i));
    }

    public PaintingItem(Item.Properties properties) {
        super(properties);
    }

    public static void setPaintingData(ItemStack stack, PaintingData paintingData) {
        PaintingItem.setPaintingCode(stack, paintingData.func_195925_e());
        PaintingItem.setCachedAuthorName(stack, paintingData.getAuthorName());
        PaintingItem.setCachedPaintingName(stack, paintingData.getPaintingName());
        String widthBlocks = Integer.toString(paintingData.getWidth() / paintingData.getResolution().getNumeric());
        String heightBlocks = Integer.toString(paintingData.getHeight() / paintingData.getResolution().getNumeric());
        TranslationTextComponent blockSizeString = new TranslationTextComponent("item.zetter.painting.size", new Object[]{widthBlocks, heightBlocks});
        PaintingItem.setCachedStringSize(stack, blockSizeString.getString());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (stack.func_77942_o()) {
            String authorName = PaintingItem.getCachedAuthorName(stack);
            if (StringUtils.func_151246_b((String)authorName)) {
                authorName = new TranslationTextComponent("item.zetter.painting.unknown").getString();
            }
            tooltip.add((ITextComponent)new TranslationTextComponent("book.byAuthor", new Object[]{authorName}).func_240699_a_(TextFormatting.GRAY));
            String stringSize = PaintingItem.getCachedStringSize(stack);
            if (!StringUtils.func_151246_b((String)stringSize)) {
                tooltip.add((ITextComponent)new StringTextComponent(stringSize).func_240699_a_(TextFormatting.GRAY));
            }
        }
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        if (stack.func_77942_o()) {
            String paintingName = PaintingItem.getCachedPaintingName(stack);
            if (StringUtils.func_151246_b((String)paintingName)) {
                if (StringUtils.func_151246_b((String)PaintingItem.getPaintingCode(stack))) {
                    return super.func_200295_i(stack);
                }
                paintingName = new TranslationTextComponent("item.zetter.painting.unnamed").getString();
            }
            if (!StringUtils.func_151246_b((String)paintingName)) {
                return new StringTextComponent(paintingName);
            }
        }
        return super.func_200295_i(stack);
    }

    public static void setPaintingCode(ItemStack stack, String canvasCode) {
        stack.func_196082_o().func_74778_a("PaintingCode", canvasCode);
    }

    @Nullable
    public static String getPaintingCode(ItemStack stack) {
        CompoundNBT compoundNBT = stack.func_77978_p();
        if (compoundNBT == null) {
            return null;
        }
        return compoundNBT.func_74779_i("PaintingCode");
    }

    public static void setCachedAuthorName(ItemStack stack, String authorName) {
        stack.func_196082_o().func_74778_a(NBT_TAG_CACHED_AUTHOR_NAME, authorName);
    }

    @Nullable
    public static String getCachedAuthorName(ItemStack stack) {
        CompoundNBT compoundNBT = stack.func_77978_p();
        if (compoundNBT == null) {
            return null;
        }
        return compoundNBT.func_74779_i(NBT_TAG_CACHED_AUTHOR_NAME);
    }

    public static void setCachedPaintingName(ItemStack stack, String paintingName) {
        stack.func_196082_o().func_74778_a(NBT_TAG_CACHED_PAINTING_NAME, paintingName);
    }

    @Nullable
    public static String getCachedPaintingName(ItemStack stack) {
        CompoundNBT compoundNBT = stack.func_77978_p();
        if (compoundNBT == null) {
            return null;
        }
        return compoundNBT.func_74779_i(NBT_TAG_CACHED_PAINTING_NAME);
    }

    public static void setCachedStringSize(ItemStack stack, String stringSize) {
        stack.func_196082_o().func_74778_a(NBT_TAG_CACHED_STRING_SIZE, stringSize);
    }

    @Nullable
    public static String getCachedStringSize(ItemStack stack) {
        CompoundNBT compoundNBT = stack.func_77978_p();
        if (compoundNBT == null) {
            return null;
        }
        return compoundNBT.func_74779_i(NBT_TAG_CACHED_STRING_SIZE);
    }
}

