/*
 * Decompiled with CFR 0.152.
 */
package com.dantaeusb.zetter.item;

import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;

public class PaletteItem
extends Item {
    public static final String NBT_TAG_NAME_PALETTE_COLORS = "paletteColors";
    public static int PALETTE_SIZE = 14;

    public PaletteItem() {
        super(new Item.Properties().func_200918_c(512).func_200916_a(ItemGroup.field_78040_i));
    }

    public static int[] getPaletteColors(ItemStack stack) {
        CompoundNBT compoundNBT = stack.func_77978_p();
        int[] paletteColors = null;
        paletteColors = compoundNBT != null && compoundNBT.func_74764_b(NBT_TAG_NAME_PALETTE_COLORS) ? compoundNBT.func_74759_k(NBT_TAG_NAME_PALETTE_COLORS) : PaletteItem.getDefaultPaletteColors();
        return paletteColors;
    }

    public static int[] getDefaultPaletteColors() {
        int[] paletteColors = new int[PALETTE_SIZE];
        paletteColors[0] = -5636096;
        paletteColors[1] = -43691;
        paletteColors[2] = -22016;
        paletteColors[3] = -171;
        paletteColors[4] = -16733696;
        paletteColors[5] = -11141291;
        paletteColors[6] = -11141121;
        paletteColors[7] = -16733526;
        paletteColors[8] = -16777046;
        paletteColors[9] = -11184641;
        paletteColors[10] = -43521;
        paletteColors[11] = -5635926;
        paletteColors[12] = -5592406;
        paletteColors[13] = -11184811;
        return paletteColors;
    }

    public static void setPaletteColors(ItemStack stack, int[] paletteColors) {
        if (paletteColors.length != PALETTE_SIZE) {
            return;
        }
        CompoundNBT compoundNBT = stack.func_196082_o();
        compoundNBT.func_74783_a(NBT_TAG_NAME_PALETTE_COLORS, paletteColors);
    }

    public static void updatePaletteColor(ItemStack stack, int paletteSlot, int color) {
        int[] colors = PaletteItem.getPaletteColors(stack);
        colors[paletteSlot] = color;
        PaletteItem.setPaletteColors(stack, colors);
    }
}

