/*
 * Decompiled with CFR 0.152.
 */
package com.dantaeusb.zetter.item.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class FramingRecipe
extends SpecialRecipe {
    public static final Serializer SERIALIZER = new Serializer();
    public static final ResourceLocation TYPE_ID = new ResourceLocation("zetter", "framing");
    private final Ingredient inputFrame;
    private final Ingredient inputPainting;

    public FramingRecipe(ResourceLocation id, Ingredient inputFrame, Ingredient inputPainting) {
        super(id);
        this.inputFrame = inputFrame;
        this.inputPainting = inputPainting;
    }

    public String toString() {
        return "FramingRecipe [inputFrame=" + this.inputFrame + ", inputPainting=" + this.inputPainting + "]";
    }

    public boolean matches(CraftingInventory craftingInventory, World world) {
        ItemStack frameStack = ItemStack.field_190927_a;
        ItemStack paintingStack = ItemStack.field_190927_a;
        for (int i = 0; i < craftingInventory.func_70302_i_(); ++i) {
            if (craftingInventory.func_70301_a(i).func_190926_b()) continue;
            if (this.inputFrame.test(craftingInventory.func_70301_a(i))) {
                if (!frameStack.func_190926_b()) {
                    return false;
                }
                frameStack = craftingInventory.func_70301_a(i);
                continue;
            }
            if (!this.inputPainting.test(craftingInventory.func_70301_a(i))) continue;
            if (!paintingStack.func_190926_b()) {
                return false;
            }
            paintingStack = craftingInventory.func_70301_a(i);
        }
        return !frameStack.func_190926_b() && !paintingStack.func_190926_b() && paintingStack.func_77942_o();
    }

    public ItemStack getCraftingResult(CraftingInventory craftingInventory) {
        ItemStack frameStack = ItemStack.field_190927_a;
        ItemStack paintingStack = ItemStack.field_190927_a;
        for (int i = 0; i < craftingInventory.func_70302_i_(); ++i) {
            if (this.inputFrame.test(craftingInventory.func_70301_a(i))) {
                if (!frameStack.func_190926_b()) {
                    return ItemStack.field_190927_a;
                }
                frameStack = craftingInventory.func_70301_a(i);
                continue;
            }
            if (!this.inputPainting.test(craftingInventory.func_70301_a(i))) continue;
            if (!paintingStack.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            paintingStack = craftingInventory.func_70301_a(i);
        }
        if (!paintingStack.func_190926_b() && paintingStack.func_77942_o()) {
            ItemStack outStack = frameStack.func_77946_l();
            CompoundNBT compoundnbt = paintingStack.func_77978_p().func_74737_b();
            outStack.func_77982_d(compoundnbt);
            return outStack;
        }
        return ItemStack.field_190927_a;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public boolean func_194133_a(int width, int height) {
        return width >= 2 && height >= 2;
    }

    private static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<FramingRecipe> {
        Serializer() {
            this.setRegistryName(new ResourceLocation("zetter", "framing"));
        }

        public FramingRecipe read(ResourceLocation recipeId, JsonObject json) {
            JsonObject inputFrameJson = JSONUtils.func_152754_s((JsonObject)json, (String)"frame");
            Ingredient inputFrame = Ingredient.func_199802_a((JsonElement)inputFrameJson);
            JsonObject inputPaintingJson = JSONUtils.func_152754_s((JsonObject)json, (String)"painting");
            Ingredient inputPainting = Ingredient.func_199802_a((JsonElement)inputPaintingJson);
            return new FramingRecipe(recipeId, inputFrame, inputPainting);
        }

        public FramingRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            Ingredient frameIngredient = Ingredient.func_199566_b((PacketBuffer)buffer);
            Ingredient paintingIngredient = Ingredient.func_199566_b((PacketBuffer)buffer);
            return new FramingRecipe(recipeId, frameIngredient, paintingIngredient);
        }

        public void write(PacketBuffer buffer, FramingRecipe recipe) {
            recipe.inputFrame.func_199564_a(buffer);
            recipe.inputPainting.func_199564_a(buffer);
        }
    }
}

