/*
 * Decompiled with CFR 0.152.
 */
package com.dantaeusb.zetter.item.crafting;

import com.dantaeusb.zetter.core.ModItems;
import com.dantaeusb.zetter.item.FrameItem;
import com.dantaeusb.zetter.item.PaintingItem;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class UnframingRecipe
extends SpecialRecipe {
    public static final Serializer SERIALIZER = new Serializer();
    public static final ResourceLocation TYPE_ID = new ResourceLocation("zetter", "unframing");
    private final Ingredient inputFrame;

    public UnframingRecipe(ResourceLocation id, Ingredient inputFrame) {
        super(id);
        this.inputFrame = inputFrame;
    }

    public String toString() {
        return "UnframingRecipe [inputFrame=" + this.inputFrame + "]";
    }

    public boolean matches(CraftingInventory craftingInventory, World world) {
        ItemStack frameStack = ItemStack.field_190927_a;
        for (int i = 0; i < craftingInventory.func_70302_i_(); ++i) {
            if (craftingInventory.func_70301_a(i).func_190926_b() || !this.inputFrame.test(craftingInventory.func_70301_a(i))) continue;
            if (!frameStack.func_190926_b()) {
                return false;
            }
            frameStack = craftingInventory.func_70301_a(i);
        }
        return !frameStack.func_190926_b() && PaintingItem.getPaintingCode(frameStack) != null;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        NonNullList remainingItems = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < remainingItems.size(); ++i) {
            ItemStack stackInSlot = inv.func_70301_a(i);
            if (!(stackInSlot.func_77973_b() instanceof FrameItem)) continue;
            Item keepItem = stackInSlot.func_77973_b();
            ItemStack keepStack = new ItemStack((IItemProvider)keepItem);
            keepStack.func_190920_e(1);
            remainingItems.set(i, (Object)keepStack);
            break;
        }
        return remainingItems;
    }

    public ItemStack getCraftingResult(CraftingInventory craftingInventory) {
        ItemStack frameStack = ItemStack.field_190927_a;
        for (int i = 0; i < craftingInventory.func_70302_i_(); ++i) {
            if (!this.inputFrame.test(craftingInventory.func_70301_a(i))) continue;
            if (!frameStack.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            frameStack = craftingInventory.func_70301_a(i);
        }
        if (!frameStack.func_190926_b() && frameStack.func_77942_o()) {
            ItemStack outStack = new ItemStack((IItemProvider)ModItems.PAINTING);
            CompoundNBT compoundnbt = frameStack.func_77978_p().func_74737_b();
            outStack.func_77982_d(compoundnbt);
            return outStack;
        }
        return ItemStack.field_190927_a;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public boolean func_194133_a(int width, int height) {
        return width >= 2 && height >= 2;
    }

    private static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<UnframingRecipe> {
        Serializer() {
            this.setRegistryName(new ResourceLocation("zetter", "unframing"));
        }

        public UnframingRecipe read(ResourceLocation recipeId, JsonObject json) {
            JsonObject inputFrameJson = JSONUtils.func_152754_s((JsonObject)json, (String)"frame");
            Ingredient inputFrame = Ingredient.func_199802_a((JsonElement)inputFrameJson);
            return new UnframingRecipe(recipeId, inputFrame);
        }

        public UnframingRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            Ingredient frameIngredient = Ingredient.func_199566_b((PacketBuffer)buffer);
            return new UnframingRecipe(recipeId, frameIngredient);
        }

        public void write(PacketBuffer buffer, UnframingRecipe recipe) {
            recipe.inputFrame.func_199564_a(buffer);
        }
    }
}

