/*
 * Decompiled with CFR 0.152.
 */
package com.dantaeusb.zetter.network;

import com.dantaeusb.zetter.Zetter;
import com.dantaeusb.zetter.canvastracker.CanvasTrackerCapability;
import com.dantaeusb.zetter.canvastracker.ICanvasTracker;
import com.dantaeusb.zetter.container.ArtistTableContainer;
import com.dantaeusb.zetter.container.EaselContainer;
import com.dantaeusb.zetter.core.Helper;
import com.dantaeusb.zetter.network.packet.SCanvasSyncMessage;
import com.dantaeusb.zetter.network.packet.SEaselCanvasChangePacket;
import com.dantaeusb.zetter.network.packet.SPaintingSyncMessage;
import com.dantaeusb.zetter.storage.AbstractCanvasData;
import com.dantaeusb.zetter.storage.CanvasData;
import com.dantaeusb.zetter.storage.PaintingData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.world.World;

public class ClientHandler {
    public static void processCanvasSync(SCanvasSyncMessage packetIn, ClientWorld world) {
        ICanvasTracker canvasTracker;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        AbstractCanvasData canvasData = packetIn.getCanvasData();
        if (player.field_71070_bA instanceof EaselContainer && ((EaselContainer)player.field_71070_bA).isCanvasAvailable() && canvasData.func_195925_e().equals(((EaselContainer)player.field_71070_bA).getCanvasData().func_195925_e())) {
            ((EaselContainer)player.field_71070_bA).processSync((CanvasData)canvasData, packetIn.getTimestamp());
        }
        if (player.field_71070_bA instanceof ArtistTableContainer) {
            ((ArtistTableContainer)player.field_71070_bA).updateCanvasCombination();
        }
        if ((canvasTracker = (ICanvasTracker)world.getCapability(CanvasTrackerCapability.CAPABILITY_CANVAS_TRACKER).orElse(null)) == null) {
            Zetter.LOG.error("Cannot find world canvas capability");
            return;
        }
        canvasTracker.registerCanvasData(canvasData);
    }

    public static void processPaintingSync(SPaintingSyncMessage packetIn, ClientWorld world) {
        PaintingData canvasData = packetIn.getPaintingData();
        ICanvasTracker canvasTracker = Helper.getWorldCanvasTracker((World)world);
        if (canvasTracker == null) {
            Zetter.LOG.error("Cannot find world canvas capability");
            return;
        }
        canvasTracker.registerCanvasData(canvasData);
    }

    public static void processEaselCanvasUpdate(SEaselCanvasChangePacket packetIn, ClientWorld world) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player.field_71070_bA instanceof EaselContainer) {
            ((EaselContainer)player.field_71070_bA).handleCanvasChange(packetIn.getItem());
        }
    }
}

