/*
 * Decompiled with CFR 0.152.
 */
package com.dantaeusb.zetter.network;

import com.dantaeusb.zetter.Zetter;
import com.dantaeusb.zetter.canvastracker.CanvasServerTracker;
import com.dantaeusb.zetter.canvastracker.CanvasTrackerCapability;
import com.dantaeusb.zetter.container.ArtistTableContainer;
import com.dantaeusb.zetter.container.EaselContainer;
import com.dantaeusb.zetter.core.ModNetwork;
import com.dantaeusb.zetter.network.packet.CCanvasBucketToolPacket;
import com.dantaeusb.zetter.network.packet.CCanvasRequestPacket;
import com.dantaeusb.zetter.network.packet.CCanvasUnloadRequestPacket;
import com.dantaeusb.zetter.network.packet.CPaintingFrameBufferPacket;
import com.dantaeusb.zetter.network.packet.CPaletteUpdatePacket;
import com.dantaeusb.zetter.network.packet.CUpdatePaintingPacket;
import com.dantaeusb.zetter.network.packet.SCanvasSyncMessage;
import com.dantaeusb.zetter.network.packet.SPaintingSyncMessage;
import com.dantaeusb.zetter.storage.AbstractCanvasData;
import com.dantaeusb.zetter.storage.CanvasData;
import com.dantaeusb.zetter.storage.DummyCanvasData;
import com.dantaeusb.zetter.storage.PaintingData;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.PacketDistributor;

public class ServerHandler {
    public static void processFrameBuffer(CPaintingFrameBufferPacket packetIn, ServerPlayerEntity sendingPlayer) {
        if (sendingPlayer.field_71070_bA instanceof EaselContainer) {
            EaselContainer paintingContainer = (EaselContainer)sendingPlayer.field_71070_bA;
            paintingContainer.processFrameBufferServer(packetIn.getFrameBuffer(), sendingPlayer.func_110124_au());
        }
    }

    public static void processRequestSync(CCanvasRequestPacket packetIn, ServerPlayerEntity sendingPlayer) {
        MinecraftServer server = sendingPlayer.func_71121_q().func_73046_m();
        ServerWorld world = server.func_241755_D_();
        CanvasServerTracker canvasTracker = (CanvasServerTracker)world.getCapability(CanvasTrackerCapability.CAPABILITY_CANVAS_TRACKER).orElse(null);
        Zetter.LOG.debug("Got request to sync canvas " + packetIn.getCanvasName());
        if (canvasTracker == null) {
            Zetter.LOG.error("Cannot find world canvas capability");
            return;
        }
        canvasTracker.trackCanvas(sendingPlayer.func_110124_au(), packetIn.getCanvasName());
        AbstractCanvasData canvasData = packetIn.getCanvasType() == AbstractCanvasData.Type.CANVAS ? canvasTracker.getCanvasData(packetIn.getCanvasName(), CanvasData.class) : (packetIn.getCanvasType() == AbstractCanvasData.Type.PAINTING ? canvasTracker.getCanvasData(packetIn.getCanvasName(), PaintingData.class) : canvasTracker.getCanvasData(packetIn.getCanvasName(), DummyCanvasData.class));
        if (canvasData == null) {
            Zetter.LOG.error("Player " + sendingPlayer + " requested non-existent canvas: " + packetIn.getCanvasName());
            return;
        }
        if (canvasData instanceof PaintingData) {
            SPaintingSyncMessage paintingSyncMessage = new SPaintingSyncMessage((PaintingData)canvasData, System.currentTimeMillis());
            ModNetwork.simpleChannel.send(PacketDistributor.PLAYER.with(() -> sendingPlayer), (Object)paintingSyncMessage);
        } else {
            SCanvasSyncMessage canvasSyncMessage = new SCanvasSyncMessage(canvasData, System.currentTimeMillis());
            ModNetwork.simpleChannel.send(PacketDistributor.PLAYER.with(() -> sendingPlayer), (Object)canvasSyncMessage);
        }
    }

    public static void processUnloadRequest(CCanvasUnloadRequestPacket packetIn, ServerPlayerEntity sendingPlayer) {
        MinecraftServer server = sendingPlayer.func_71121_q().func_73046_m();
        ServerWorld world = server.func_241755_D_();
        CanvasServerTracker canvasTracker = (CanvasServerTracker)world.getCapability(CanvasTrackerCapability.CAPABILITY_CANVAS_TRACKER).orElse(null);
        Zetter.LOG.debug("Got request to unload canvas " + packetIn.getCanvasName());
        if (canvasTracker == null) {
            Zetter.LOG.error("Cannot find world canvas capability");
            return;
        }
        canvasTracker.stopTrackingCanvas(sendingPlayer.func_110124_au(), packetIn.getCanvasName());
    }

    public static void processPaletteUpdate(CPaletteUpdatePacket packetIn, ServerPlayerEntity sendingPlayer) {
        if (sendingPlayer.field_71070_bA instanceof EaselContainer) {
            EaselContainer paintingContainer = (EaselContainer)sendingPlayer.field_71070_bA;
            paintingContainer.setPaletteColor(packetIn.getSlotIndex(), packetIn.getColor());
        }
    }

    public static void processCreatePainting(CUpdatePaintingPacket packetIn, ServerPlayerEntity sendingPlayer) {
        if (sendingPlayer.field_71070_bA instanceof ArtistTableContainer) {
            ArtistTableContainer artistTableContainer = (ArtistTableContainer)sendingPlayer.field_71070_bA;
            artistTableContainer.updatePaintingName(packetIn.getPaintingName());
        }
    }

    public static void processBucketTool(CCanvasBucketToolPacket packetIn, ServerPlayerEntity sendingPlayer) {
        if (sendingPlayer.field_71070_bA instanceof EaselContainer) {
            EaselContainer easelContainer = (EaselContainer)sendingPlayer.field_71070_bA;
            easelContainer.processBucketToolServer(packetIn.position, packetIn.color);
        }
    }
}

