/*
 * Decompiled with CFR 0.152.
 */
package com.dantaeusb.zetter.network.packet;

import com.dantaeusb.zetter.Zetter;
import com.dantaeusb.zetter.network.ServerHandler;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class CCanvasUnloadRequestPacket {
    private String canvasName;

    public CCanvasUnloadRequestPacket() {
    }

    public CCanvasUnloadRequestPacket(String canvasName) {
        this.canvasName = canvasName;
    }

    public static CCanvasUnloadRequestPacket readPacketData(PacketBuffer buf) {
        CCanvasUnloadRequestPacket packet = new CCanvasUnloadRequestPacket();
        packet.canvasName = buf.func_150789_c(Short.MAX_VALUE);
        return packet;
    }

    public void writePacketData(PacketBuffer buf) {
        buf.func_180714_a(this.canvasName);
    }

    public String getCanvasName() {
        return this.canvasName;
    }

    public static void handle(CCanvasUnloadRequestPacket packetIn, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        ctx.setPacketHandled(true);
        ServerPlayerEntity sendingPlayer = ctx.getSender();
        if (sendingPlayer == null) {
            Zetter.LOG.warn("EntityPlayerMP was null when CRequestSyncPacket was received");
        }
        ctx.enqueueWork(() -> ServerHandler.processUnloadRequest(packetIn, sendingPlayer));
    }
}

