/*
 * Decompiled with CFR 0.152.
 */
package com.dantaeusb.zetter.network.packet;

import com.dantaeusb.zetter.Zetter;
import com.dantaeusb.zetter.container.painting.PaintingFrameBuffer;
import com.dantaeusb.zetter.network.ServerHandler;
import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class CPaintingFrameBufferPacket {
    private PaintingFrameBuffer paintingFrameBuffer;

    public CPaintingFrameBufferPacket() {
    }

    public CPaintingFrameBufferPacket(PaintingFrameBuffer paintingFrameBuffer) {
        this.paintingFrameBuffer = paintingFrameBuffer;
    }

    public static CPaintingFrameBufferPacket readPacketData(PacketBuffer buf) {
        CPaintingFrameBufferPacket packet = new CPaintingFrameBufferPacket();
        long frameStartTime = buf.readLong();
        ByteBuf bufferData = buf.readBytes(buf.writerIndex() - buf.readerIndex());
        Zetter.LOG.warn((Object)bufferData);
        packet.paintingFrameBuffer = new PaintingFrameBuffer(frameStartTime, bufferData.nioBuffer());
        return packet;
    }

    public void writePacketData(PacketBuffer buf) {
        buf.writeLong(this.paintingFrameBuffer.getFrameStartTime());
        buf.writeBytes(this.paintingFrameBuffer.getBufferData());
    }

    public PaintingFrameBuffer getFrameBuffer() {
        return this.paintingFrameBuffer;
    }

    public static void handle(CPaintingFrameBufferPacket packetIn, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        ctx.setPacketHandled(true);
        ServerPlayerEntity sendingPlayer = ctx.getSender();
        if (sendingPlayer == null) {
            Zetter.LOG.warn("EntityPlayerMP was null when CPaintingUpdatePacket was received");
        }
        ctx.enqueueWork(() -> ServerHandler.processFrameBuffer(packetIn, sendingPlayer));
    }
}

