/*
 * Decompiled with CFR 0.152.
 */
package com.dantaeusb.zetter.network.packet;

import com.dantaeusb.zetter.Zetter;
import com.dantaeusb.zetter.network.ServerHandler;
import com.dantaeusb.zetter.network.packet.CanvasContainer;
import com.dantaeusb.zetter.storage.AbstractCanvasData;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class CUpdatePaintingPacket {
    private int windowId;
    private String paintingName;
    private AbstractCanvasData canvasData;

    public CUpdatePaintingPacket() {
    }

    public CUpdatePaintingPacket(int windowId, String paintingName, AbstractCanvasData canvasData) {
        this.windowId = windowId;
        this.paintingName = paintingName;
        this.canvasData = canvasData;
    }

    public static CUpdatePaintingPacket readPacketData(PacketBuffer buf) {
        CUpdatePaintingPacket packet = new CUpdatePaintingPacket();
        try {
            packet.windowId = buf.readByte();
            packet.paintingName = buf.func_150789_c(Short.MAX_VALUE);
            packet.canvasData = CanvasContainer.readPacketCanvasData(buf);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            Zetter.LOG.warn("Exception while reading CCreatePaintingPacket: " + e);
            return packet;
        }
        return packet;
    }

    public void writePacketData(PacketBuffer buf) {
        buf.writeByte(this.windowId);
        buf.func_180714_a(this.paintingName);
        CanvasContainer.writePacketCanvasData(buf, this.canvasData);
    }

    public int getWindowId() {
        return this.windowId;
    }

    public String getPaintingName() {
        return this.paintingName;
    }

    public AbstractCanvasData getCanvasData() {
        return this.canvasData;
    }

    public static void handle(CUpdatePaintingPacket packetIn, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        ctx.setPacketHandled(true);
        ServerPlayerEntity sendingPlayer = ctx.getSender();
        if (sendingPlayer == null) {
            Zetter.LOG.warn("EntityPlayerMP was null when CCreatePaintingPacket was received");
        }
        ctx.enqueueWork(() -> ServerHandler.processCreatePainting(packetIn, sendingPlayer));
    }
}

