/*
 * Decompiled with CFR 0.152.
 */
package com.dantaeusb.zetter.network.packet;

import com.dantaeusb.zetter.Zetter;
import com.dantaeusb.zetter.storage.AbstractCanvasData;
import com.dantaeusb.zetter.storage.CanvasData;
import com.dantaeusb.zetter.storage.DummyCanvasData;
import com.dantaeusb.zetter.storage.PaintingData;
import java.nio.ByteBuffer;
import net.minecraft.network.PacketBuffer;

public abstract class CanvasContainer {
    private static final AbstractCanvasData.Type[] typeValues = AbstractCanvasData.Type.values();

    public static AbstractCanvasData readPacketCanvasData(PacketBuffer networkBuffer) {
        try {
            AbstractCanvasData readCanvasData;
            int type = networkBuffer.readInt();
            String canvasName = networkBuffer.func_150789_c(Short.MAX_VALUE);
            int resolutionOrdinal = networkBuffer.readInt();
            AbstractCanvasData.Resolution resolution = AbstractCanvasData.Resolution.values()[resolutionOrdinal];
            int width = networkBuffer.readInt();
            int height = networkBuffer.readInt();
            int colorDataSize = networkBuffer.readInt();
            ByteBuffer colorData = networkBuffer.readBytes(colorDataSize).nioBuffer();
            byte[] unwrappedColorData = new byte[width * height * 4];
            colorData.get(unwrappedColorData);
            switch (typeValues[type]) {
                case CANVAS: {
                    readCanvasData = new CanvasData(canvasName);
                    break;
                }
                case PAINTING: {
                    readCanvasData = new PaintingData(canvasName);
                    break;
                }
                default: {
                    readCanvasData = new DummyCanvasData(canvasName);
                }
            }
            readCanvasData.initData(resolution, width, height, unwrappedColorData);
            return readCanvasData;
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            Zetter.LOG.warn("Exception while extracting canvas from container: " + e);
            return null;
        }
    }

    public static void writePacketCanvasData(PacketBuffer networkBuffer, AbstractCanvasData canvasData) {
        networkBuffer.writeInt(canvasData.getType().ordinal());
        networkBuffer.func_180714_a(canvasData.func_195925_e());
        networkBuffer.writeInt(canvasData.getResolution().ordinal());
        networkBuffer.writeInt(canvasData.getWidth());
        networkBuffer.writeInt(canvasData.getHeight());
        networkBuffer.writeInt(canvasData.getColorDataBuffer().remaining());
        networkBuffer.writeBytes(canvasData.getColorDataBuffer());
    }
}

