/*
 * Decompiled with CFR 0.152.
 */
package com.dantaeusb.zetter.network.packet;

import com.dantaeusb.zetter.Zetter;
import com.dantaeusb.zetter.network.ClientHandler;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.network.NetworkEvent;

public class SEaselCanvasChangePacket {
    private int windowId;
    private ItemStack item = ItemStack.field_190927_a;

    public SEaselCanvasChangePacket(int windowId, ItemStack item) {
        this.windowId = windowId;
        this.item = item.func_77946_l();
    }

    public static SEaselCanvasChangePacket readPacketData(PacketBuffer networkBuffer) {
        try {
            byte windowId = networkBuffer.readByte();
            ItemStack item = networkBuffer.func_150791_c();
            return new SEaselCanvasChangePacket(windowId, item);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            Zetter.LOG.warn("Exception while reading SEaselCanvasChangePacket: " + e);
            return null;
        }
    }

    public void writePacketData(PacketBuffer networkBuffer) {
        networkBuffer.writeByte(this.windowId);
        networkBuffer.func_150788_a(this.item);
    }

    public int getWindowId() {
        return this.windowId;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public static void handle(SEaselCanvasChangePacket packetIn, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        Optional clientWorld = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
        if (!clientWorld.isPresent()) {
            Zetter.LOG.warn("SEaselCanvasChangePacket context could not provide a ClientWorld.");
            return;
        }
        ctx.enqueueWork(() -> ClientHandler.processEaselCanvasUpdate(packetIn, (ClientWorld)clientWorld.get()));
    }

    public String toString() {
        return "SEaselCanvasChangePacket[windowId=" + this.windowId + ",stack=" + this.item + "]";
    }
}

