/*
 * Decompiled with CFR 0.152.
 */
package com.dantaeusb.zetter.network.packet;

import com.dantaeusb.zetter.Zetter;
import com.dantaeusb.zetter.network.ClientHandler;
import com.dantaeusb.zetter.network.packet.CanvasContainer;
import com.dantaeusb.zetter.storage.PaintingData;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.network.NetworkEvent;

public class SPaintingSyncMessage {
    private final PaintingData paintingData;
    private final long timestamp;

    public SPaintingSyncMessage(PaintingData paintingData, long timestamp) {
        this.paintingData = paintingData;
        this.timestamp = timestamp;
    }

    public PaintingData getPaintingData() {
        return this.paintingData;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public static SPaintingSyncMessage readPacketData(PacketBuffer networkBuffer) {
        try {
            long timestamp = networkBuffer.readLong();
            PaintingData readCanvasData = (PaintingData)CanvasContainer.readPacketCanvasData(networkBuffer);
            String paintingName = networkBuffer.func_218666_n();
            String authorName = networkBuffer.func_218666_n();
            readCanvasData.setMetaProperties(authorName, paintingName);
            return new SPaintingSyncMessage(readCanvasData, timestamp);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            Zetter.LOG.warn("Exception while reading SPaintingSyncMessage: " + e);
            return null;
        }
    }

    public void writePacketData(PacketBuffer networkBuffer) {
        networkBuffer.writeLong(this.timestamp);
        CanvasContainer.writePacketCanvasData(networkBuffer, this.paintingData);
        networkBuffer.func_211400_a(this.paintingData.getPaintingName(), 64);
        networkBuffer.func_211400_a(this.paintingData.getAuthorName(), 64);
    }

    public static void handle(SPaintingSyncMessage packetIn, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        Optional clientWorld = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
        if (!clientWorld.isPresent()) {
            Zetter.LOG.warn("SCanvasSyncMessage context could not provide a ClientWorld.");
            return;
        }
        ctx.enqueueWork(() -> ClientHandler.processPaintingSync(packetIn, (ClientWorld)clientWorld.get()));
    }

    public String toString() {
        return "SPaintingSyncMessage[painting=" + (Object)((Object)this.paintingData) + ",timestamp=" + this.timestamp + "]";
    }
}

