/*
 * Decompiled with CFR 0.152.
 */
package com.dantaeusb.zetter.storage;

import com.dantaeusb.zetter.Zetter;
import com.dantaeusb.zetter.core.Helper;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.storage.WorldSavedData;

public abstract class AbstractCanvasData
extends WorldSavedData {
    protected static final String NBT_TAG_TYPE = "type";
    protected static final String NBT_TAG_WIDTH = "width";
    protected static final String NBT_TAG_HEIGHT = "height";
    protected static final String NBT_TAG_RESOLUTION = "resolution";
    protected static final String NBT_TAG_COLOR = "color";
    protected byte[] color;
    protected ByteBuffer canvasBuffer;
    protected Resolution resolution;
    protected int width;
    protected int height;

    public AbstractCanvasData(String canvasCode) {
        super(canvasCode);
    }

    public final void initData(Resolution resolution, int width, int height, byte[] color) {
        if (width % resolution.getNumeric() != 0 || height % resolution.getNumeric() != 0) {
            throw new IllegalArgumentException("Canvas size is not proportional to given canvas resolution");
        }
        this.resolution = resolution;
        this.width = width;
        this.height = height;
        this.updateColorData(color);
        this.func_76185_a();
    }

    protected void updateColorData(byte[] color) {
        if (this.color != null && color.length != this.color.length) {
            throw new IllegalArgumentException("Color data size mismatch");
        }
        this.color = color;
        this.canvasBuffer = ByteBuffer.wrap(this.color);
        this.canvasBuffer.order(ByteOrder.BIG_ENDIAN);
    }

    public boolean updateCanvasPixel(int index, int color) {
        if (!this.isEditable()) {
            Zetter.LOG.warn("Tried to update sealed canvas " + (Object)((Object)this));
            return false;
        }
        this.canvasBuffer.putInt(index * 4, color);
        this.func_76185_a();
        return true;
    }

    public int getColorAt(int pixelX, int pixelY) {
        return this.getColorAt(this.getPixelIndex(pixelX, pixelY));
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Resolution getResolution() {
        return this.resolution;
    }

    public abstract boolean isEditable();

    public abstract Type getType();

    public ByteBuffer getColorDataBuffer() {
        this.canvasBuffer.rewind();
        return this.canvasBuffer.asReadOnlyBuffer();
    }

    public int getColorAt(int index) {
        return this.canvasBuffer.getInt(index * 4);
    }

    public int getPixelIndex(int pixelX, int pixelY) {
        pixelX = MathHelper.func_76125_a((int)pixelX, (int)0, (int)(this.width - 1));
        pixelY = MathHelper.func_76125_a((int)pixelY, (int)0, (int)(this.height - 1));
        return pixelY * this.width + pixelX;
    }

    public void func_76184_a(CompoundNBT compound) {
        this.width = compound.func_74762_e(NBT_TAG_WIDTH);
        this.height = compound.func_74762_e(NBT_TAG_HEIGHT);
        if (compound.func_74764_b(NBT_TAG_RESOLUTION)) {
            int resolutionOrdinal = compound.func_74762_e(NBT_TAG_RESOLUTION);
            this.resolution = Resolution.values()[resolutionOrdinal];
        } else {
            this.resolution = Helper.getResolution();
        }
        this.updateColorData(compound.func_74770_j(NBT_TAG_COLOR));
    }

    public CompoundNBT func_189551_b(CompoundNBT compound) {
        compound.func_74768_a(NBT_TAG_TYPE, this.getType().ordinal());
        compound.func_74768_a(NBT_TAG_WIDTH, this.width);
        compound.func_74768_a(NBT_TAG_HEIGHT, this.height);
        compound.func_74768_a(NBT_TAG_RESOLUTION, this.resolution.ordinal());
        compound.func_74773_a(NBT_TAG_COLOR, this.color);
        return compound;
    }

    public static enum Resolution {
        x16(16),
        x32(32),
        x64(64);

        private final int numeric;

        private Resolution(int numeric) {
            this.numeric = numeric;
        }

        public int getNumeric() {
            return this.numeric;
        }
    }

    public static enum Type {
        DUMMY,
        CANVAS,
        PAINTING;

    }
}

