/*
 * Decompiled with CFR 0.152.
 */
package com.dantaeusb.zetter.storage;

import com.dantaeusb.zetter.core.Helper;
import com.dantaeusb.zetter.storage.AbstractCanvasData;
import java.nio.ByteBuffer;

public class CanvasData
extends AbstractCanvasData {
    public static final String CODE_PREFIX = "zetter_canvas_";

    public CanvasData(String canvasCode) {
        super(canvasCode);
    }

    public CanvasData(int canvasId) {
        super(CanvasData.getCanvasCode(canvasId));
    }

    public static String getCanvasCode(int canvasId) {
        return CODE_PREFIX + canvasId;
    }

    public void initData(int width, int height) {
        byte[] defaultColor = new byte[width * height * 4];
        ByteBuffer defaultColorBuffer = ByteBuffer.wrap(defaultColor);
        for (int x = 0; x < width * height; ++x) {
            defaultColorBuffer.putInt(x * 4, Helper.CANVAS_COLOR);
        }
        this.initData(Helper.getResolution(), width, height, defaultColor);
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    @Override
    public AbstractCanvasData.Type getType() {
        return AbstractCanvasData.Type.CANVAS;
    }
}

