/*
 * Decompiled with CFR 0.152.
 */
package com.dantaeusb.zetter.storage;

import com.dantaeusb.zetter.Zetter;
import com.dantaeusb.zetter.storage.AbstractCanvasData;
import net.minecraft.nbt.CompoundNBT;

public class PaintingData
extends AbstractCanvasData {
    public static final String CODE_PREFIX = "zetter_painting_";
    protected static final String NBT_TAG_AUTHOR_NAME = "author_name";
    protected static final String NBT_TAG_TITLE = "title";
    protected String authorName;
    protected String title;

    public PaintingData(String canvasCode) {
        super(canvasCode);
    }

    public PaintingData(int paintingId) {
        super(PaintingData.getPaintingCode(paintingId));
    }

    public void copyFrom(AbstractCanvasData templateCanvasData) {
        if (this.isEditable()) {
            Zetter.LOG.error("Cannot copy to sealed canvas");
            return;
        }
        this.resolution = templateCanvasData.getResolution();
        this.width = templateCanvasData.getWidth();
        this.height = templateCanvasData.getHeight();
        this.updateColorData(templateCanvasData.color);
        this.func_76185_a();
    }

    public void setMetaProperties(String authorName, String title) {
        this.authorName = authorName;
        this.title = title;
    }

    public String getPaintingName() {
        return this.title;
    }

    public String getAuthorName() {
        return this.authorName;
    }

    public static String getPaintingCode(int paintingId) {
        return CODE_PREFIX + paintingId;
    }

    @Override
    public boolean isEditable() {
        return false;
    }

    @Override
    public AbstractCanvasData.Type getType() {
        return AbstractCanvasData.Type.PAINTING;
    }

    @Override
    public void func_76184_a(CompoundNBT compound) {
        super.func_76184_a(compound);
        this.authorName = compound.func_74779_i(NBT_TAG_AUTHOR_NAME);
        this.title = compound.func_74779_i(NBT_TAG_TITLE);
    }

    @Override
    public CompoundNBT func_189551_b(CompoundNBT compound) {
        super.func_189551_b(compound);
        compound.func_74778_a(NBT_TAG_AUTHOR_NAME, this.authorName);
        compound.func_74778_a(NBT_TAG_TITLE, this.title);
        return compound;
    }
}

