/*
 * Decompiled with CFR 0.152.
 */
package com.dantaeusb.zetter.tileentity;

import com.dantaeusb.zetter.container.EaselContainer;
import com.dantaeusb.zetter.core.ModItems;
import com.dantaeusb.zetter.core.ModTileEntities;
import com.dantaeusb.zetter.item.CanvasItem;
import com.dantaeusb.zetter.storage.CanvasData;
import com.dantaeusb.zetter.tileentity.storage.EaselStorage;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class EaselTileEntity
extends TileEntity
implements ITickableTileEntity,
INamedContainerProvider {
    private final EaselStorage easelStorage;
    private static final String EASEL_STORAGE_TAG = "storage";
    private ArrayList<PlayerEntity> playersUsing = new ArrayList();
    private int ticksSinceSync;

    public EaselTileEntity() {
        super(ModTileEntities.EASEL_TILE_ENTITY);
        this.easelStorage = EaselStorage.createForTileEntity(this::canPlayerAccessInventory, () -> ((EaselTileEntity)this).func_70296_d());
    }

    public boolean canPlayerAccessInventory(PlayerEntity player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_73660_a() {
        if (this.field_145850_b.func_201670_d()) {
            return;
        }
        if (++this.ticksSinceSync > 200) {
            this.playersUsing = this.calculatePlayersUsing();
        }
    }

    public EaselStorage getEaselStorage() {
        return this.easelStorage;
    }

    public boolean hasCanvas() {
        ItemStack canvasStack = this.getCanvasStack();
        return !canvasStack.func_190926_b();
    }

    @Nullable
    public ItemStack getCanvasStack() {
        return this.easelStorage.func_70301_a(0);
    }

    public boolean putCanvasStack(ItemStack itemStack) {
        if (itemStack.func_77973_b() != ModItems.CANVAS) {
            return false;
        }
        if (this.hasCanvas()) {
            return false;
        }
        CanvasItem.getCanvasData(itemStack, this.field_145850_b);
        this.easelStorage.setCanvasStack(itemStack);
        return true;
    }

    public String getCanvasName() {
        ItemStack canvasStack = this.getCanvasStack();
        if (canvasStack != null && canvasStack.func_190926_b()) {
            return "";
        }
        return CanvasItem.getCanvasCode(canvasStack);
    }

    @Nullable
    public CanvasData getCanvasData() {
        ItemStack canvasStack = this.getCanvasStack();
        if (canvasStack.func_190926_b() || canvasStack.func_77973_b() != ModItems.CANVAS) {
            return null;
        }
        return CanvasItem.getCanvasData(canvasStack, this.field_145850_b);
    }

    public ArrayList<PlayerEntity> calculatePlayersUsing() {
        ArrayList<PlayerEntity> usingPlayers = new ArrayList<PlayerEntity>();
        for (PlayerEntity player : this.field_145850_b.func_217357_a(PlayerEntity.class, new AxisAlignedBB(this.field_174879_c.func_177982_a(-5, -5, -5), this.field_174879_c.func_177982_a(5, 5, 5)))) {
            EaselStorage storage;
            if (!(player.field_71070_bA instanceof EaselContainer) || (storage = ((EaselContainer)player.field_71070_bA).getEaselStorage()) != this.getEaselStorage()) continue;
            usingPlayers.add(player);
        }
        return usingPlayers;
    }

    public ArrayList<PlayerEntity> getPlayersUsing() {
        return this.playersUsing;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.func_174877_v(), this.func_174877_v().func_177982_a(1, 2, 1));
    }

    public CompoundNBT func_189515_b(CompoundNBT parentNBTTagCompound) {
        super.func_189515_b(parentNBTTagCompound);
        CompoundNBT inventoryNBT = this.easelStorage.serializeNBT();
        parentNBTTagCompound.func_218657_a(EASEL_STORAGE_TAG, (INBT)inventoryNBT);
        return parentNBTTagCompound;
    }

    public void func_230337_a_(BlockState blockState, CompoundNBT parentNBTTagCompound) {
        super.func_230337_a_(blockState, parentNBTTagCompound);
        CompoundNBT inventoryNBT = parentNBTTagCompound.func_74775_l(EASEL_STORAGE_TAG);
        this.easelStorage.deserializeNBT(inventoryNBT);
        if (this.easelStorage.func_70302_i_() != 2) {
            throw new IllegalArgumentException("Corrupted NBT: Number of inventory slots did not match expected.");
        }
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbtTagCompound = new CompoundNBT();
        this.func_189515_b(nbtTagCompound);
        int tileEntityType = 42;
        return new SUpdateTileEntityPacket(this.field_174879_c, tileEntityType, nbtTagCompound);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        BlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.func_230337_a_(blockState, packet.func_148857_g());
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbtTagCompound = new CompoundNBT();
        this.func_189515_b(nbtTagCompound);
        return nbtTagCompound;
    }

    public void handleUpdateTag(BlockState blockState, CompoundNBT tag) {
        this.func_230337_a_(blockState, tag);
    }

    public void dropAllContents(World world, BlockPos blockPos) {
        InventoryHelper.func_180175_a((World)world, (BlockPos)blockPos, (IInventory)this.easelStorage);
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("container.zetter.easel");
    }

    @Nullable
    public Container createMenu(int windowID, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return EaselContainer.createContainerServerSide(windowID, playerInventory, this, this.easelStorage);
    }
}

