/*
 * Decompiled with CFR 0.152.
 */
package com.dantaeusb.zetter.tileentity.storage;

import com.dantaeusb.zetter.core.ModItems;
import java.util.function.Predicate;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.items.ItemStackHandler;

public class ArtistTableCanvasStorage
implements IInventory {
    public static final int STORAGE_SIZE = 16;
    private final ItemStackHandler stackHandler;
    private Predicate<PlayerEntity> canPlayerAccessInventoryLambda = x -> true;
    private Notify markDirtyNotificationLambda = () -> {};
    private Notify openInventoryNotificationLambda = () -> {};
    private Notify closeInventoryNotificationLambda = () -> {};

    public static ArtistTableCanvasStorage createForTileEntity(Predicate<PlayerEntity> canPlayerAccessInventoryLambda, Notify markDirtyNotificationLambda) {
        return new ArtistTableCanvasStorage(canPlayerAccessInventoryLambda, markDirtyNotificationLambda);
    }

    public static ArtistTableCanvasStorage createForClientSideContainer() {
        return new ArtistTableCanvasStorage();
    }

    private ArtistTableCanvasStorage() {
        this.stackHandler = new ItemStackHandler(16){};
    }

    private ArtistTableCanvasStorage(Predicate<PlayerEntity> canPlayerAccessInventoryLambda, Notify markDirtyNotificationLambda) {
        this();
        this.canPlayerAccessInventoryLambda = canPlayerAccessInventoryLambda;
        this.markDirtyNotificationLambda = markDirtyNotificationLambda;
    }

    public CompoundNBT serializeNBT() {
        return this.stackHandler.serializeNBT();
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.stackHandler.deserializeNBT(nbt);
    }

    public void setCanPlayerAccessInventoryLambda(Predicate<PlayerEntity> canPlayerAccessInventoryLambda) {
        this.canPlayerAccessInventoryLambda = canPlayerAccessInventoryLambda;
    }

    public void setMarkDirtyNotificationLambda(Notify markDirtyNotificationLambda) {
        this.markDirtyNotificationLambda = markDirtyNotificationLambda;
    }

    public void setOpenInventoryNotificationLambda(Notify openInventoryNotificationLambda) {
        this.openInventoryNotificationLambda = openInventoryNotificationLambda;
    }

    public void setCloseInventoryNotificationLambda(Notify closeInventoryNotificationLambda) {
        this.closeInventoryNotificationLambda = closeInventoryNotificationLambda;
    }

    public boolean func_70300_a(PlayerEntity player) {
        return this.canPlayerAccessInventoryLambda.test(player);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (stack.func_77973_b() == ModItems.CANVAS) {
            return this.stackHandler.isItemValid(index, stack);
        }
        return false;
    }

    public void func_70296_d() {
        this.markDirtyNotificationLambda.invoke();
    }

    public void func_174889_b(PlayerEntity player) {
        this.openInventoryNotificationLambda.invoke();
    }

    public void func_174886_c(PlayerEntity player) {
        this.closeInventoryNotificationLambda.invoke();
    }

    public int func_70302_i_() {
        return this.stackHandler.getSlots();
    }

    public boolean func_191420_l() {
        for (int i = 0; i < this.stackHandler.getSlots(); ++i) {
            if (this.stackHandler.getStackInSlot(i).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return this.stackHandler.getStackInSlot(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return this.stackHandler.extractItem(index, count, false);
    }

    public ItemStack func_70304_b(int index) {
        int maxPossibleItemStackSize = this.stackHandler.getSlotLimit(index);
        return this.stackHandler.extractItem(index, maxPossibleItemStackSize, false);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.stackHandler.setStackInSlot(index, stack);
    }

    public void func_174888_l() {
        for (int i = 0; i < this.stackHandler.getSlots(); ++i) {
            this.stackHandler.setStackInSlot(i, ItemStack.field_190927_a);
        }
    }

    @FunctionalInterface
    public static interface Notify {
        public void invoke();
    }
}

