/*
 * Decompiled with CFR 0.152.
 */
package com.dantaeusb.zetter.tileentity.storage;

import java.util.function.Predicate;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.items.ItemStackHandler;

public class EaselStorage
implements IInventory {
    public static final int STORAGE_SIZE = 2;
    public static final int CANVAS_SLOT = 0;
    public static final int PALETTE_SLOT = 1;
    private final ItemStackHandler easelContents;
    private Predicate<PlayerEntity> canPlayerAccessInventoryLambda = x -> true;
    private Notify markDirtyNotificationLambda = () -> {};
    private Notify openInventoryNotificationLambda = () -> {};
    private Notify closeInventoryNotificationLambda = () -> {};

    public static EaselStorage createForTileEntity(Predicate<PlayerEntity> canPlayerAccessInventoryLambda, Notify markDirtyNotificationLambda) {
        return new EaselStorage(canPlayerAccessInventoryLambda, markDirtyNotificationLambda);
    }

    public static EaselStorage createForClientSideContainer() {
        return new EaselStorage();
    }

    private EaselStorage() {
        this.easelContents = new ItemStackHandler(2){};
    }

    private EaselStorage(Predicate<PlayerEntity> canPlayerAccessInventoryLambda, Notify markDirtyNotificationLambda) {
        this();
        this.canPlayerAccessInventoryLambda = canPlayerAccessInventoryLambda;
        this.markDirtyNotificationLambda = markDirtyNotificationLambda;
    }

    public ItemStack getCanvasStack() {
        return this.func_70301_a(0);
    }

    public ItemStack getPaletteStack() {
        return this.func_70301_a(1);
    }

    public ItemStack extractCanvas() {
        ItemStack itemStack = this.easelContents.extractItem(0, 1, false);
        this.func_70296_d();
        return itemStack;
    }

    public void setCanvasStack(ItemStack canvasStack) {
        this.easelContents.setStackInSlot(0, canvasStack);
        this.func_70296_d();
    }

    public CompoundNBT serializeNBT() {
        return this.easelContents.serializeNBT();
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.easelContents.deserializeNBT(nbt);
    }

    public void setCanPlayerAccessInventoryLambda(Predicate<PlayerEntity> canPlayerAccessInventoryLambda) {
        this.canPlayerAccessInventoryLambda = canPlayerAccessInventoryLambda;
    }

    public void setMarkDirtyNotificationLambda(Notify markDirtyNotificationLambda) {
        this.markDirtyNotificationLambda = markDirtyNotificationLambda;
    }

    public void setOpenInventoryNotificationLambda(Notify openInventoryNotificationLambda) {
        this.openInventoryNotificationLambda = openInventoryNotificationLambda;
    }

    public void setCloseInventoryNotificationLambda(Notify closeInventoryNotificationLambda) {
        this.closeInventoryNotificationLambda = closeInventoryNotificationLambda;
    }

    public boolean func_70300_a(PlayerEntity player) {
        return this.canPlayerAccessInventoryLambda.test(player);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return this.easelContents.isItemValid(index, stack);
    }

    public void func_70296_d() {
        this.markDirtyNotificationLambda.invoke();
    }

    public void func_174889_b(PlayerEntity player) {
        this.openInventoryNotificationLambda.invoke();
    }

    public void func_174886_c(PlayerEntity player) {
        this.closeInventoryNotificationLambda.invoke();
    }

    public int func_70302_i_() {
        return this.easelContents.getSlots();
    }

    public boolean func_191420_l() {
        for (int i = 0; i < this.easelContents.getSlots(); ++i) {
            if (this.easelContents.getStackInSlot(i).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return this.easelContents.getStackInSlot(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return this.easelContents.extractItem(index, count, false);
    }

    public ItemStack func_70304_b(int index) {
        int maxPossibleItemStackSize = this.easelContents.getSlotLimit(index);
        return this.easelContents.extractItem(index, maxPossibleItemStackSize, false);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.easelContents.setStackInSlot(index, stack);
    }

    public void func_174888_l() {
        for (int i = 0; i < this.easelContents.getSlots(); ++i) {
            this.easelContents.setStackInSlot(i, ItemStack.field_190927_a);
        }
    }

    @FunctionalInterface
    public static interface Notify {
        public void invoke();
    }
}

