/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterstrongholds.world.jigsaw;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.mojang.datafixers.util.Pair;
import com.yungnickyoung.minecraft.betterstrongholds.BetterStrongholdsCommon;
import com.yungnickyoung.minecraft.betterstrongholds.mixin.accessor.SinglePoolElementAccessor;
import com.yungnickyoung.minecraft.betterstrongholds.world.config.BetterStrongholdFeatureConfiguration;
import com.yungnickyoung.minecraft.yungsapi.mixin.accessor.BoundingBoxAccessor;
import com.yungnickyoung.minecraft.yungsapi.mixin.accessor.StructureTemplatePoolAccessor;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_247;
import net.minecraft.class_2470;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3341;
import net.minecraft.class_3485;
import net.minecraft.class_3499;
import net.minecraft.class_3748;
import net.minecraft.class_3777;
import net.minecraft.class_3778;
import net.minecraft.class_3780;
import net.minecraft.class_3784;
import net.minecraft.class_3785;
import net.minecraft.class_3790;
import net.minecraft.class_5455;
import net.minecraft.class_5468;
import net.minecraft.class_5539;
import net.minecraft.class_5742;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_6622;
import net.minecraft.class_6626;
import net.minecraft.class_6834;
import org.apache.commons.lang3.mutable.MutableObject;

public class BetterStrongholdsJigsawManager {
    public static Optional<class_6622<BetterStrongholdFeatureConfiguration>> assembleJigsawStructure(class_6834.class_6835<BetterStrongholdFeatureConfiguration> jigsawContext, class_3778.class_3779 pieceFactory, class_2338 startPos, boolean doBoundaryAdjustments, boolean useHeightmap, int structureBoundingBoxRadius) {
        int pieceCenterY;
        class_2919 worldgenRandom = new class_2919((class_5819)new class_5820(0L));
        worldgenRandom.method_12663(jigsawContext.comp_308(), jigsawContext.comp_309().field_9181, jigsawContext.comp_309().field_9180);
        class_5455 registryAccess = jigsawContext.comp_314();
        BetterStrongholdFeatureConfiguration config = (BetterStrongholdFeatureConfiguration)jigsawContext.comp_310();
        class_2794 chunkGenerator = jigsawContext.comp_306();
        class_3485 structureManager = jigsawContext.comp_313();
        class_5539 levelHeightAccessor = jigsawContext.comp_311();
        Predicate predicate = jigsawContext.comp_312();
        class_3195.method_28664();
        class_2378 registry = registryAccess.method_30530(class_2378.field_25917);
        class_2470 rotation = class_2470.method_16548((Random)worldgenRandom);
        class_3785 structureTemplatePool = (class_3785)registry.method_10223(config.startPool);
        class_3784 startPieceBlueprint = structureTemplatePool.method_16631((Random)worldgenRandom);
        if (startPieceBlueprint == class_3777.field_16663) {
            return Optional.empty();
        }
        class_3790 startPiece = pieceFactory.create(structureManager, startPieceBlueprint, startPos, startPieceBlueprint.method_19308(), rotation, startPieceBlueprint.method_16628(structureManager, startPos, rotation));
        class_3341 pieceBoundingBox = startPiece.method_14935();
        int pieceCenterX = (pieceBoundingBox.method_35418() + pieceBoundingBox.method_35415()) / 2;
        int pieceCenterZ = (pieceBoundingBox.method_35420() + pieceBoundingBox.method_35417()) / 2;
        int n = pieceCenterY = useHeightmap ? startPos.method_10264() + chunkGenerator.method_20402(pieceCenterX, pieceCenterZ, class_2902.class_2903.field_13194, levelHeightAccessor) : startPos.method_10264();
        if (!predicate.test(chunkGenerator.method_16359(class_5742.method_33100((int)pieceCenterX), class_5742.method_33100((int)pieceCenterY), class_5742.method_33100((int)pieceCenterZ)))) {
            return Optional.empty();
        }
        int yAdjustment = pieceBoundingBox.method_35416() + startPiece.method_16646();
        startPiece.method_14922(0, pieceCenterY - yAdjustment, 0);
        return Optional.of((structurePiecesBuilder, context) -> {
            ArrayList pieces = Lists.newArrayList();
            pieces.add(startPiece);
            if (config.maxDepth <= 0) {
                return;
            }
            class_238 aABB = new class_238((double)(pieceCenterX - structureBoundingBoxRadius), (double)(pieceCenterY - structureBoundingBoxRadius), (double)(pieceCenterZ - structureBoundingBoxRadius), (double)(pieceCenterX + structureBoundingBoxRadius + 1), (double)(pieceCenterY + structureBoundingBoxRadius + 1), (double)(pieceCenterZ + structureBoundingBoxRadius + 1));
            Placer placer = new Placer((class_2378<class_3785>)registry, config.maxDepth, pieceFactory, chunkGenerator, structureManager, pieces, (Random)worldgenRandom);
            PieceState startPieceEntry = new PieceState(startPiece, (MutableObject<class_265>)new MutableObject((Object)class_259.method_1072((class_265)class_259.method_1078((class_238)aABB), (class_265)class_259.method_1078((class_238)class_238.method_19316((class_3341)pieceBoundingBox)), (class_247)class_247.field_16886)), 0);
            placer.placing.addLast(startPieceEntry);
            while (!placer.placing.isEmpty()) {
                PieceState entry = placer.placing.removeFirst();
                placer.processPiece(entry.piece, entry.free, entry.depth, doBoundaryAdjustments, levelHeightAccessor);
            }
            pieces.forEach(arg_0 -> ((class_6626)structurePiecesBuilder).method_35462(arg_0));
        });
    }

    public static final class Placer {
        private final class_2378<class_3785> patternRegistry;
        private final int maxDepth;
        private final class_3778.class_3779 pieceFactory;
        private final class_2794 chunkGenerator;
        private final class_3485 structureManager;
        private final List<? super class_3790> pieces;
        private final Random rand;
        public final Deque<PieceState> placing = Queues.newArrayDeque();
        private final Map<class_2960, Integer> pieceCounts;
        private final int maxY;

        public Placer(class_2378<class_3785> patternRegistry, int maxDepth, class_3778.class_3779 pieceFactory, class_2794 chunkGenerator, class_3485 structureManager, List<? super class_3790> pieces, Random rand) {
            this.patternRegistry = patternRegistry;
            this.maxDepth = maxDepth;
            this.pieceFactory = pieceFactory;
            this.chunkGenerator = chunkGenerator;
            this.structureManager = structureManager;
            this.pieces = pieces;
            this.rand = rand;
            this.pieceCounts = new HashMap<class_2960, Integer>();
            this.pieceCounts.put(new class_2960("betterstrongholds", "rooms/grand_library"), BetterStrongholdsCommon.CONFIG.pieceSettings.grandLibraryMaxCount);
            this.pieceCounts.put(new class_2960("betterstrongholds", "rooms/library_md"), BetterStrongholdsCommon.CONFIG.pieceSettings.smallLibraryMaxCount);
            this.pieceCounts.put(new class_2960("betterstrongholds", "rooms/prison_lg"), BetterStrongholdsCommon.CONFIG.pieceSettings.prisonMaxCount);
            this.pieceCounts.put(new class_2960("betterstrongholds", "rooms/cmd_acarii"), BetterStrongholdsCommon.CONFIG.pieceSettings.cmdAcariiMaxCount);
            this.pieceCounts.put(new class_2960("betterstrongholds", "rooms/cmd_yung"), BetterStrongholdsCommon.CONFIG.pieceSettings.cmdYungMaxCount);
            this.pieceCounts.put(new class_2960("betterstrongholds", "rooms/treasure_room_lg"), BetterStrongholdsCommon.CONFIG.pieceSettings.treasureRoomMaxCount);
            this.pieceCounts.put(new class_2960("betterstrongholds", "portal_rooms/portal_room"), BetterStrongholdsCommon.CONFIG.pieceSettings.portalRoomMaxCount);
            this.pieceCounts.put(new class_2960("betterstrongholds", "rooms/armoury_md"), BetterStrongholdsCommon.CONFIG.pieceSettings.armouryLargeRoomMaxCount);
            this.pieceCounts.put(new class_2960("betterstrongholds", "rooms/armoury_sm"), BetterStrongholdsCommon.CONFIG.pieceSettings.armourySmallRoomMaxCount);
            this.maxY = BetterStrongholdsCommon.CONFIG.general.strongholdMaxY;
        }

        public void processPiece(class_3790 piece, MutableObject<class_265> voxelShape, int depth, boolean doBoundaryAdjustments, class_5539 levelHeightAccessor) {
            class_3784 pieceBlueprint = piece.method_16644();
            class_2338 piecePos = piece.method_16648();
            class_2470 pieceRotation = piece.method_16888();
            class_3341 pieceBoundingBox = piece.method_14935();
            int pieceMinY = pieceBoundingBox.method_35416();
            MutableObject<class_265> tempNewPieceVoxelShape = new MutableObject<class_265>();
            List pieceJigsawBlocks = pieceBlueprint.method_16627(this.structureManager, piecePos, pieceRotation, this.rand);
            for (class_3499.class_3501 jigsawBlock : pieceJigsawBlocks) {
                class_3784 generatedPiece;
                MutableObject<class_265> pieceVoxelShape;
                class_2350 direction = class_3748.method_26378((class_2680)jigsawBlock.field_15596);
                class_2338 jigsawBlockPos = jigsawBlock.field_15597;
                class_2338 jigsawBlockTargetPos = jigsawBlockPos.method_10093(direction);
                class_2960 jigsawBlockPoolId = new class_2960(jigsawBlock.field_15595.method_10558("pool"));
                Optional poolOptional = this.patternRegistry.method_17966(jigsawBlockPoolId);
                if (!poolOptional.isPresent() || ((class_3785)poolOptional.get()).method_16632() == 0 && !Objects.equals(jigsawBlockPoolId, class_5468.field_26254.method_29177())) {
                    BetterStrongholdsCommon.LOGGER.warn("Empty or nonexistent pool: {}", (Object)jigsawBlockPoolId);
                    continue;
                }
                class_2960 jigsawBlockFallback = ((class_3785)poolOptional.get()).method_16634();
                Optional fallbackOptional = this.patternRegistry.method_17966(jigsawBlockFallback);
                if (!fallbackOptional.isPresent() || ((class_3785)fallbackOptional.get()).method_16632() == 0 && !Objects.equals(jigsawBlockFallback, class_5468.field_26254.method_29177())) {
                    BetterStrongholdsCommon.LOGGER.warn("Empty or nonexistent fallback pool: {}", (Object)jigsawBlockFallback);
                    continue;
                }
                boolean isTargetInsideCurrentPiece = pieceBoundingBox.method_14662((class_2382)jigsawBlockTargetPos);
                if (isTargetInsideCurrentPiece) {
                    pieceVoxelShape = tempNewPieceVoxelShape;
                    if (tempNewPieceVoxelShape.getValue() == null) {
                        tempNewPieceVoxelShape.setValue((Object)class_259.method_1078((class_238)class_238.method_19316((class_3341)pieceBoundingBox)));
                    }
                } else {
                    pieceVoxelShape = voxelShape;
                }
                if (depth != this.maxDepth && (generatedPiece = this.processList(new ArrayList<Pair<class_3784, Integer>>(((StructureTemplatePoolAccessor)poolOptional.get()).getRawTemplates()), doBoundaryAdjustments, jigsawBlock, jigsawBlockTargetPos, pieceMinY, jigsawBlockPos, pieceVoxelShape, piece, depth, levelHeightAccessor)) != null) continue;
                this.processList(new ArrayList<Pair<class_3784, Integer>>(((StructureTemplatePoolAccessor)fallbackOptional.get()).getRawTemplates()), doBoundaryAdjustments, jigsawBlock, jigsawBlockTargetPos, pieceMinY, jigsawBlockPos, pieceVoxelShape, piece, depth, levelHeightAccessor);
            }
        }

        private class_3784 processList(List<Pair<class_3784, Integer>> candidatePieces, boolean doBoundaryAdjustments, class_3499.class_3501 jigsawBlock, class_2338 jigsawBlockTargetPos, int pieceMinY, class_2338 jigsawBlockPos, MutableObject<class_265> pieceVoxelShape, class_3790 piece, int depth, class_5539 levelHeightAccessor) {
            class_3785.class_3786 piecePlacementBehavior = piece.method_16644().method_16624();
            boolean isPieceRigid = piecePlacementBehavior == class_3785.class_3786.field_16687;
            int jigsawBlockRelativeY = jigsawBlockPos.method_10264() - pieceMinY;
            int surfaceHeight = -1;
            int totalWeightSum = candidatePieces.stream().mapToInt(Pair::getSecond).reduce(0, Integer::sum);
            while (candidatePieces.size() > 0 && totalWeightSum > 0) {
                class_3784 candidatePiece;
                Object chosenPiecePair = null;
                if (this.pieceCounts.get(new class_2960("betterstrongholds", "portal_rooms/portal_room")) > 0) {
                    for (int i = 0; i < candidatePieces.size(); ++i) {
                        Pair<class_3784, Integer> candidatePiecePair = candidatePieces.get(i);
                        class_3784 class_37842 = (class_3784)candidatePiecePair.getFirst();
                        if (!((class_2960)((SinglePoolElementAccessor)class_37842).getTemplate().left().get()).equals((Object)new class_2960("betterstrongholds", "portal_rooms/portal_room"))) continue;
                        if (depth >= this.maxDepth / 2) {
                            chosenPiecePair = candidatePiecePair;
                            break;
                        }
                        totalWeightSum -= ((Integer)candidatePiecePair.getSecond()).intValue();
                        candidatePieces.remove(candidatePiecePair);
                        break;
                    }
                }
                if (chosenPiecePair == null) {
                    int chosenWeight = this.rand.nextInt(totalWeightSum) + 1;
                    for (Pair pair : candidatePieces) {
                        if ((chosenWeight -= ((Integer)pair.getSecond()).intValue()) > 0) continue;
                        chosenPiecePair = pair;
                        break;
                    }
                }
                if ((candidatePiece = (class_3784)chosenPiecePair.getFirst()) == class_3777.field_16663) {
                    return null;
                }
                class_2960 pieceName = (class_2960)((SinglePoolElementAccessor)candidatePiece).getTemplate().left().get();
                if (this.pieceCounts.containsKey(pieceName) && this.pieceCounts.get(pieceName) <= 0) {
                    totalWeightSum -= ((Integer)chosenPiecePair.getSecond()).intValue();
                    candidatePieces.remove(chosenPiecePair);
                    continue;
                }
                for (class_2470 rotation : class_2470.method_16547((Random)this.rand)) {
                    List candidateJigsawBlocks = candidatePiece.method_16627(this.structureManager, class_2338.field_10980, rotation, this.rand);
                    class_3341 tempCandidateBoundingBox = candidatePiece.method_16628(this.structureManager, class_2338.field_10980, rotation);
                    int candidateHeightAdjustments = doBoundaryAdjustments && tempCandidateBoundingBox.method_14660() <= 16 ? candidateJigsawBlocks.stream().mapToInt(pieceCandidateJigsawBlock -> {
                        if (!tempCandidateBoundingBox.method_14662((class_2382)pieceCandidateJigsawBlock.field_15597.method_10093(class_3748.method_26378((class_2680)pieceCandidateJigsawBlock.field_15596)))) {
                            return 0;
                        }
                        class_2960 candidateTargetPool = new class_2960(pieceCandidateJigsawBlock.field_15595.method_10558("pool"));
                        Optional candidateTargetPoolOptional = this.patternRegistry.method_17966(candidateTargetPool);
                        Optional<Integer> candidateTargetFallbackOptional = candidateTargetPoolOptional.flatMap(StructureTemplatePool -> this.patternRegistry.method_17966(StructureTemplatePool.method_16634()));
                        int tallestCandidateTargetPoolPieceHeight = candidateTargetPoolOptional.map(structureTemplatePool -> structureTemplatePool.method_19309(this.structureManager)).orElse(0);
                        int tallestCandidateTargetFallbackPieceHeight = candidateTargetFallbackOptional.map(structureTemplatePool -> structureTemplatePool.method_19309(this.structureManager)).orElse(0);
                        return Math.max(tallestCandidateTargetPoolPieceHeight, tallestCandidateTargetFallbackPieceHeight);
                    }).max().orElse(0) : 0;
                    for (class_3499.class_3501 candidateJigsawBlock : candidateJigsawBlocks) {
                        int candidateJigsawBlockY;
                        int adjustedCandidatePieceMinY;
                        if (!class_3748.method_16546((class_3499.class_3501)jigsawBlock, (class_3499.class_3501)candidateJigsawBlock)) continue;
                        class_2338 candidateJigsawBlockPos = candidateJigsawBlock.field_15597;
                        class_2338 candidateJigsawBlockRelativePos = jigsawBlockTargetPos.method_10059((class_2382)candidateJigsawBlockPos);
                        class_3341 candidateBoundingBox = candidatePiece.method_16628(this.structureManager, candidateJigsawBlockRelativePos, rotation);
                        class_3785.class_3786 candidatePlacementBehavior = candidatePiece.method_16624();
                        boolean isCandidateRigid = candidatePlacementBehavior == class_3785.class_3786.field_16687;
                        int candidateJigsawBlockRelativeY = candidateJigsawBlockPos.method_10264();
                        int candidateJigsawYOffsetNeeded = jigsawBlockRelativeY - candidateJigsawBlockRelativeY + class_3748.method_26378((class_2680)jigsawBlock.field_15596).method_10164();
                        if (isPieceRigid && isCandidateRigid) {
                            adjustedCandidatePieceMinY = pieceMinY + candidateJigsawYOffsetNeeded;
                        } else {
                            if (surfaceHeight == -1) {
                                surfaceHeight = this.chunkGenerator.method_20402(jigsawBlockPos.method_10263(), jigsawBlockPos.method_10260(), class_2902.class_2903.field_13194, levelHeightAccessor);
                            }
                            adjustedCandidatePieceMinY = surfaceHeight - candidateJigsawBlockRelativeY;
                        }
                        int candidatePieceYOffsetNeeded = adjustedCandidatePieceMinY - candidateBoundingBox.method_35416();
                        class_3341 adjustedCandidateBoundingBox = candidateBoundingBox.method_19311(0, candidatePieceYOffsetNeeded, 0);
                        class_2338 adjustedCandidateJigsawBlockRelativePos = candidateJigsawBlockRelativePos.method_10069(0, candidatePieceYOffsetNeeded, 0);
                        if (candidateHeightAdjustments > 0) {
                            int k2 = Math.max(candidateHeightAdjustments + 1, adjustedCandidateBoundingBox.method_35419() - adjustedCandidateBoundingBox.method_35416());
                            ((BoundingBoxAccessor)adjustedCandidateBoundingBox).setMaxY(adjustedCandidateBoundingBox.method_35416() + k2);
                        }
                        if (adjustedCandidateBoundingBox.method_35419() > this.maxY || class_259.method_1074((class_265)((class_265)pieceVoxelShape.getValue()), (class_265)class_259.method_1078((class_238)class_238.method_19316((class_3341)adjustedCandidateBoundingBox).method_1011(0.25)), (class_247)class_247.field_16893)) continue;
                        pieceVoxelShape.setValue((Object)class_259.method_1082((class_265)((class_265)pieceVoxelShape.getValue()), (class_265)class_259.method_1078((class_238)class_238.method_19316((class_3341)adjustedCandidateBoundingBox)), (class_247)class_247.field_16886));
                        int newPieceGroundLevelDelta = piece.method_16646();
                        int groundLevelDelta = isCandidateRigid ? newPieceGroundLevelDelta - candidateJigsawYOffsetNeeded : candidatePiece.method_19308();
                        class_3790 newPiece = this.pieceFactory.create(this.structureManager, candidatePiece, adjustedCandidateJigsawBlockRelativePos, groundLevelDelta, rotation, adjustedCandidateBoundingBox);
                        if (isPieceRigid) {
                            candidateJigsawBlockY = pieceMinY + jigsawBlockRelativeY;
                        } else if (isCandidateRigid) {
                            candidateJigsawBlockY = adjustedCandidatePieceMinY + candidateJigsawBlockRelativeY;
                        } else {
                            if (surfaceHeight == -1) {
                                surfaceHeight = this.chunkGenerator.method_20402(jigsawBlockPos.method_10263(), jigsawBlockPos.method_10260(), class_2902.class_2903.field_13194, levelHeightAccessor);
                            }
                            candidateJigsawBlockY = surfaceHeight + candidateJigsawYOffsetNeeded / 2;
                        }
                        piece.method_16647(new class_3780(jigsawBlockTargetPos.method_10263(), candidateJigsawBlockY - jigsawBlockRelativeY + newPieceGroundLevelDelta, jigsawBlockTargetPos.method_10260(), candidateJigsawYOffsetNeeded, candidatePlacementBehavior));
                        newPiece.method_16647(new class_3780(jigsawBlockPos.method_10263(), candidateJigsawBlockY - candidateJigsawBlockRelativeY + groundLevelDelta, jigsawBlockPos.method_10260(), -candidateJigsawYOffsetNeeded, piecePlacementBehavior));
                        this.pieces.add((class_3790)newPiece);
                        if (depth + 1 <= this.maxDepth) {
                            this.placing.addLast(new PieceState(newPiece, pieceVoxelShape, depth + 1));
                        }
                        if (this.pieceCounts.containsKey(pieceName)) {
                            this.pieceCounts.put(pieceName, this.pieceCounts.get(pieceName) - 1);
                        }
                        return candidatePiece;
                    }
                }
                totalWeightSum -= ((Integer)chosenPiecePair.getSecond()).intValue();
                candidatePieces.remove(chosenPiecePair);
            }
            return null;
        }
    }

    public static final class PieceState {
        public final class_3790 piece;
        public final MutableObject<class_265> free;
        public final int depth;

        public PieceState(class_3790 piece, MutableObject<class_265> voxelShape, int depth) {
            this.piece = piece;
            this.free = voxelShape;
            this.depth = depth;
        }
    }
}

