/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.world.condition;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.yungnickyoung.minecraft.yungsapi.world.condition.AllOfCondition;
import com.yungnickyoung.minecraft.yungsapi.world.condition.AltitudeCondition;
import com.yungnickyoung.minecraft.yungsapi.world.condition.AnyOfCondition;
import com.yungnickyoung.minecraft.yungsapi.world.condition.StructureCondition;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2960;

public interface StructureConditionType<C extends StructureCondition> {
    public static final Map<class_2960, StructureConditionType<?>> CONDITION_TYPES_BY_NAME = new HashMap();
    public static final Map<StructureConditionType<?>, class_2960> NAME_BY_CONDITION_TYPES = new HashMap();
    public static final Codec<StructureConditionType<?>> CONDITION_TYPE_CODEC = class_2960.field_25139.flatXmap(resourceLocation -> Optional.ofNullable(CONDITION_TYPES_BY_NAME.get(resourceLocation)).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Unknown condition type: " + resourceLocation))), conditionType -> Optional.of(NAME_BY_CONDITION_TYPES.get(conditionType)).map(DataResult::success).orElseGet(() -> DataResult.error((String)("No ID found for condition type " + conditionType + ". Is it registered?"))));
    public static final Codec<StructureCondition> CONDITION_CODEC = CONDITION_TYPE_CODEC.dispatch("type", StructureCondition::type, StructureConditionType::codec);
    public static final StructureConditionType<AltitudeCondition> ALTITUDE = StructureConditionType.register("altitude", AltitudeCondition.CODEC);
    public static final StructureConditionType<AnyOfCondition> ANY_OF = StructureConditionType.register("any_of", AnyOfCondition.CODEC);
    public static final StructureConditionType<AllOfCondition> ALL_OF = StructureConditionType.register("all_of", AllOfCondition.CODEC);

    public static <C extends StructureCondition> StructureConditionType<C> register(class_2960 resourceLocation, Codec<C> codec) {
        StructureConditionType<C> conditionType = () -> codec;
        CONDITION_TYPES_BY_NAME.put(resourceLocation, conditionType);
        NAME_BY_CONDITION_TYPES.put(conditionType, resourceLocation);
        return conditionType;
    }

    private static <C extends StructureCondition> StructureConditionType<C> register(String id, Codec<C> codec) {
        return StructureConditionType.register(new class_2960("yungsapi", id), codec);
    }

    public Codec<C> codec();
}

