/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.world.jigsaw;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.mojang.datafixers.util.Pair;
import com.yungnickyoung.minecraft.yungsapi.YungsApiCommon;
import com.yungnickyoung.minecraft.yungsapi.mixin.accessor.BoundingBoxAccessor;
import com.yungnickyoung.minecraft.yungsapi.mixin.accessor.StructureTemplatePoolAccessor;
import com.yungnickyoung.minecraft.yungsapi.util.BoxOctree;
import com.yungnickyoung.minecraft.yungsapi.world.condition.ConditionContext;
import com.yungnickyoung.minecraft.yungsapi.world.jigsaw.piece.IMaxCountJigsawPiece;
import com.yungnickyoung.minecraft.yungsapi.world.jigsaw.piece.YungJigsawSinglePoolElement;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3341;
import net.minecraft.class_3485;
import net.minecraft.class_3499;
import net.minecraft.class_3748;
import net.minecraft.class_3777;
import net.minecraft.class_3780;
import net.minecraft.class_3784;
import net.minecraft.class_3785;
import net.minecraft.class_3790;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5468;
import net.minecraft.class_5539;
import net.minecraft.class_5819;
import net.minecraft.class_6626;
import net.minecraft.class_6880;
import net.minecraft.class_7138;
import org.apache.commons.lang3.mutable.MutableObject;

public class JigsawManager {
    public static Optional<class_3195.class_7150> assembleJigsawStructure(class_3195.class_7149 generationContext, class_6880<class_3785> startPool, Optional<class_2960> startJigsawNameOptional, int maxDepth, class_2338 startPos, boolean useExpansionHack, Optional<class_2902.class_2903> projectStartToHeightmap, int maxDistanceFromCenter, Optional<Integer> maxY, Optional<Integer> minY) {
        class_2338 blockPos;
        class_5455 registryAccess = generationContext.comp_561();
        class_2794 chunkGenerator = generationContext.comp_562();
        class_3485 structureManager = generationContext.comp_565();
        class_5539 levelHeightAccessor = generationContext.comp_569();
        class_2919 worldgenRandom = generationContext.comp_566();
        class_2378 registry = registryAccess.method_30530(class_2378.field_25917);
        class_2470 rotation = class_2470.method_16548((class_5819)worldgenRandom);
        class_3785 structureTemplatePool = (class_3785)startPool.comp_349();
        class_3784 startPieceBlueprint = structureTemplatePool.method_16631((class_5819)worldgenRandom);
        if (startPieceBlueprint == class_3777.field_16663) {
            return Optional.empty();
        }
        if (startJigsawNameOptional.isPresent()) {
            class_2960 name = startJigsawNameOptional.get();
            Optional<class_2338> optional = JigsawManager.getPosOfJigsawBlockWithName(startPieceBlueprint, name, startPos, rotation, structureManager, worldgenRandom);
            if (optional.isEmpty()) {
                YungsApiCommon.LOGGER.error("No starting jigsaw with Name {} found in start pool {}", (Object)name, (Object)((class_5321)startPool.method_40230().get()).method_29177());
                return Optional.empty();
            }
            blockPos = optional.get();
        } else {
            blockPos = startPos;
        }
        class_2338 startingPosOffset = blockPos.method_10059((class_2382)startPos);
        class_2338 adjustedStartPos = startPos.method_10059((class_2382)startingPosOffset);
        class_3790 startPiece = new class_3790(structureManager, startPieceBlueprint, adjustedStartPos, startPieceBlueprint.method_19308(), rotation, startPieceBlueprint.method_16628(structureManager, adjustedStartPos, rotation));
        class_3341 pieceBoundingBox = startPiece.method_14935();
        int pieceCenterX = (pieceBoundingBox.method_35418() + pieceBoundingBox.method_35415()) / 2;
        int pieceCenterZ = (pieceBoundingBox.method_35420() + pieceBoundingBox.method_35417()) / 2;
        int pieceCenterY = projectStartToHeightmap.map(types -> startPos.method_10264() + chunkGenerator.method_20402(pieceCenterX, pieceCenterZ, types, levelHeightAccessor, generationContext.comp_564())).orElseGet(() -> ((class_2338)adjustedStartPos).method_10264());
        int yAdjustment = pieceBoundingBox.method_35416() + startPiece.method_16646();
        startPiece.method_14922(0, pieceCenterY - yAdjustment, 0);
        int adjustedPieceCenterY = pieceCenterY + startingPosOffset.method_10264();
        return Optional.of(new class_3195.class_7150(new class_2338(pieceCenterX, adjustedPieceCenterY, pieceCenterZ), structurePiecesBuilder -> {
            ArrayList pieces = Lists.newArrayList();
            pieces.add(startPiece);
            if (maxDepth <= 0) {
                return;
            }
            class_238 aABB = new class_238((double)(pieceCenterX - maxDistanceFromCenter), (double)(adjustedPieceCenterY - maxDistanceFromCenter), (double)(pieceCenterZ - maxDistanceFromCenter), (double)(pieceCenterX + maxDistanceFromCenter + 1), (double)(adjustedPieceCenterY + maxDistanceFromCenter + 1), (double)(pieceCenterZ + maxDistanceFromCenter + 1));
            BoxOctree maxStructureBounds = new BoxOctree(aABB);
            maxStructureBounds.addBox(class_238.method_19316((class_3341)pieceBoundingBox));
            Assembler assembler = new Assembler((class_2378<class_3785>)registry, maxDepth, chunkGenerator, structureManager, pieces, (class_5819)worldgenRandom, maxY, minY);
            PieceEntry startPieceEntry = new PieceEntry(startPiece, (MutableObject<BoxOctree>)new MutableObject((Object)maxStructureBounds), 0);
            assembler.pieceQueue.addLast(startPieceEntry);
            while (!assembler.pieceQueue.isEmpty()) {
                PieceEntry entry = assembler.pieceQueue.removeFirst();
                assembler.processPiece(entry.piece, entry.boxOctreeMutableObject, entry.depth, useExpansionHack, levelHeightAccessor, generationContext.comp_564());
            }
            pieces.forEach(arg_0 -> ((class_6626)structurePiecesBuilder).method_35462(arg_0));
        }));
    }

    private static Optional<class_2338> getPosOfJigsawBlockWithName(class_3784 startPieceBlueprint, class_2960 name, class_2338 startPos, class_2470 rotation, class_3485 structureTemplateManager, class_2919 worldgenRandom) {
        List shuffledJigsawBlocks = startPieceBlueprint.method_16627(structureTemplateManager, startPos, rotation, (class_5819)worldgenRandom);
        for (class_3499.class_3501 jigsawBlockInfo : shuffledJigsawBlocks) {
            class_2960 jigsawBlockName = class_2960.method_12829((String)jigsawBlockInfo.field_15595.method_10558("name"));
            if (!name.equals((Object)jigsawBlockName)) continue;
            return Optional.of(jigsawBlockInfo.field_15597);
        }
        return Optional.empty();
    }

    public static final class Assembler {
        private final class_2378<class_3785> poolRegistry;
        private final int maxDepth;
        private final class_2794 chunkGenerator;
        private final class_3485 structureTemplateManager;
        private final List<? super class_3790> pieces;
        private final class_5819 rand;
        public final Deque<PieceEntry> pieceQueue = Queues.newArrayDeque();
        private final Map<String, Integer> pieceCounts;
        private final Map<String, Integer> maxPieceCounts;
        private final Optional<Integer> maxY;
        private final Optional<Integer> minY;

        public Assembler(class_2378<class_3785> poolRegistry, int maxDepth, class_2794 chunkGenerator, class_3485 structureTemplateManager, List<? super class_3790> pieces, class_5819 rand, Optional<Integer> maxY, Optional<Integer> minY) {
            this.poolRegistry = poolRegistry;
            this.maxDepth = maxDepth;
            this.chunkGenerator = chunkGenerator;
            this.structureTemplateManager = structureTemplateManager;
            this.pieces = pieces;
            this.rand = rand;
            this.pieceCounts = new HashMap<String, Integer>();
            this.maxPieceCounts = new HashMap<String, Integer>();
            this.maxY = maxY;
            this.minY = minY;
        }

        public void processPiece(class_3790 piece, MutableObject<BoxOctree> boxOctree, int depth, boolean useExpansionHack, class_5539 levelHeightAccessor, class_7138 randomState) {
            class_3784 pieceBlueprint = piece.method_16644();
            class_2338 piecePos = piece.method_16648();
            class_2470 pieceRotation = piece.method_16888();
            class_3341 pieceBoundingBox = piece.method_14935();
            int pieceMinY = pieceBoundingBox.method_35416();
            MutableObject<BoxOctree> parentOctree = new MutableObject<BoxOctree>();
            List pieceJigsawBlocks = pieceBlueprint.method_16627(this.structureTemplateManager, piecePos, pieceRotation, this.rand);
            for (class_3499.class_3501 jigsawBlockInfo : pieceJigsawBlocks) {
                class_3784 generatedPiece;
                MutableObject<BoxOctree> octreeToUse;
                class_2350 direction = class_3748.method_26378((class_2680)jigsawBlockInfo.field_15596);
                class_2338 jigsawBlockPos = jigsawBlockInfo.field_15597;
                class_2338 jigsawBlockTargetPos = jigsawBlockPos.method_10093(direction);
                class_2960 jigsawBlockPoolId = new class_2960(jigsawBlockInfo.field_15595.method_10558("pool"));
                Optional poolOptional = this.poolRegistry.method_17966(jigsawBlockPoolId);
                if (!poolOptional.isPresent() || ((class_3785)poolOptional.get()).method_16632() == 0 && !Objects.equals(jigsawBlockPoolId, class_5468.field_26254.method_29177())) {
                    YungsApiCommon.LOGGER.warn("Empty or nonexistent pool: {}", (Object)jigsawBlockPoolId);
                    continue;
                }
                class_2960 jigsawBlockFallback = ((class_3785)poolOptional.get()).method_16634();
                Optional fallbackOptional = this.poolRegistry.method_17966(jigsawBlockFallback);
                if (!fallbackOptional.isPresent() || ((class_3785)fallbackOptional.get()).method_16632() == 0 && !Objects.equals(jigsawBlockFallback, class_5468.field_26254.method_29177())) {
                    YungsApiCommon.LOGGER.warn("Empty or nonexistent fallback pool: {}", (Object)jigsawBlockFallback);
                    continue;
                }
                boolean isTargetInsideCurrentPiece = pieceBoundingBox.method_14662((class_2382)jigsawBlockTargetPos);
                if (isTargetInsideCurrentPiece) {
                    octreeToUse = parentOctree;
                    if (parentOctree.getValue() == null) {
                        parentOctree.setValue((Object)new BoxOctree(class_238.method_19316((class_3341)pieceBoundingBox)));
                    }
                } else {
                    octreeToUse = boxOctree;
                }
                if (depth != this.maxDepth && (generatedPiece = this.processList(new ArrayList<Pair<class_3784, Integer>>(((StructureTemplatePoolAccessor)poolOptional.get()).getRawTemplates()), useExpansionHack, jigsawBlockInfo, jigsawBlockTargetPos, pieceMinY, jigsawBlockPos, octreeToUse, piece, depth, levelHeightAccessor, randomState)) != null) continue;
                this.processList(new ArrayList<Pair<class_3784, Integer>>(((StructureTemplatePoolAccessor)fallbackOptional.get()).getRawTemplates()), useExpansionHack, jigsawBlockInfo, jigsawBlockTargetPos, pieceMinY, jigsawBlockPos, octreeToUse, piece, depth, levelHeightAccessor, randomState);
            }
        }

        private class_3784 processList(List<Pair<class_3784, Integer>> candidatePieces, boolean useExpansionHack, class_3499.class_3501 jigsawBlock, class_2338 jigsawBlockTargetPos, int pieceMinY, class_2338 jigsawBlockPos, MutableObject<BoxOctree> boxOctree, class_3790 piece, int depth, class_5539 levelHeightAccessor, class_7138 randomState) {
            boolean isPieceRigid = piece.method_16644().method_16624() == class_3785.class_3786.field_16687;
            int jigsawBlockRelativeY = jigsawBlockPos.method_10264() - pieceMinY;
            int surfaceHeight = -1;
            int totalWeightSum = candidatePieces.stream().mapToInt(Pair::getSecond).reduce(0, Integer::sum);
            while (candidatePieces.size() > 0 && totalWeightSum > 0) {
                YungJigsawSinglePoolElement yungJigsawPiece;
                Pair<class_3784, Integer> chosenPiecePair = null;
                for (Pair<class_3784, Integer> pair : candidatePieces) {
                    YungJigsawSinglePoolElement yungJigsawPiece2;
                    class_3784 candidatePiece = (class_3784)pair.getFirst();
                    if (!(candidatePiece instanceof YungJigsawSinglePoolElement) || !(yungJigsawPiece2 = (YungJigsawSinglePoolElement)candidatePiece).isPriorityPiece()) continue;
                    chosenPiecePair = pair;
                    break;
                }
                if (chosenPiecePair == null) {
                    int chosenWeight = this.rand.method_43048(totalWeightSum) + 1;
                    for (Pair<class_3784, Integer> candidate : candidatePieces) {
                        if ((chosenWeight -= ((Integer)candidate.getSecond()).intValue()) > 0) continue;
                        chosenPiecePair = candidate;
                        break;
                    }
                }
                class_3784 chosenPiece = (class_3784)chosenPiecePair.getFirst();
                int n = (Integer)chosenPiecePair.getSecond();
                if (chosenPiece == class_3777.field_16663) {
                    return null;
                }
                if (chosenPiece instanceof YungJigsawSinglePoolElement) {
                    yungJigsawPiece = (YungJigsawSinglePoolElement)chosenPiece;
                    if (yungJigsawPiece.maxCount.isPresent()) {
                        int pieceMaxCount = yungJigsawPiece.maxCount.get();
                        if (yungJigsawPiece.name.isEmpty()) {
                            YungsApiCommon.LOGGER.error("Found YUNG Jigsaw piece with max_count={} missing \"name\" property.", (Object)pieceMaxCount);
                            YungsApiCommon.LOGGER.error("Max count pieces must be named in order to work properly!");
                            YungsApiCommon.LOGGER.error("Ignoring max_count for this piece...");
                        } else {
                            String pieceName = yungJigsawPiece.name.get();
                            if (this.maxPieceCounts.containsKey(pieceName) && this.maxPieceCounts.get(pieceName) != pieceMaxCount) {
                                YungsApiCommon.LOGGER.error("YUNG Jigsaw Piece with name {} and max_count {} does not match stored max_count of {}!", (Object)pieceName, (Object)pieceMaxCount, (Object)this.maxPieceCounts.get(pieceName));
                                YungsApiCommon.LOGGER.error("This can happen when multiple pieces across pools use the same name, but have different max_count values.");
                                YungsApiCommon.LOGGER.error("Please change these max_count values to match. Using max_count={} for now...", (Object)pieceMaxCount);
                            }
                            this.maxPieceCounts.put(pieceName, pieceMaxCount);
                            if (this.pieceCounts.getOrDefault(pieceName, 0) >= pieceMaxCount) {
                                totalWeightSum -= n;
                                candidatePieces.remove(chosenPiecePair);
                                continue;
                            }
                        }
                    }
                }
                if (chosenPiece instanceof IMaxCountJigsawPiece) {
                    String pieceName = ((IMaxCountJigsawPiece)chosenPiece).getName();
                    int maxCount = ((IMaxCountJigsawPiece)chosenPiece).getMaxCount();
                    if (this.maxPieceCounts.containsKey(pieceName) && this.maxPieceCounts.get(pieceName) != maxCount) {
                        YungsApiCommon.LOGGER.error("Max Count Jigsaw Piece with name {} and max_count {} does not match stored max_count of {}!", (Object)pieceName, (Object)maxCount, (Object)this.maxPieceCounts.get(pieceName));
                        YungsApiCommon.LOGGER.error("This can happen when multiple pieces across pools use the same name, but have different max_count values.");
                        YungsApiCommon.LOGGER.error("Please change these max_count values to match. Using max_count={} for now...", (Object)maxCount);
                    }
                    this.maxPieceCounts.put(pieceName, maxCount);
                    if (this.pieceCounts.getOrDefault(pieceName, 0) >= maxCount) {
                        totalWeightSum -= ((Integer)chosenPiecePair.getSecond()).intValue();
                        candidatePieces.remove(chosenPiecePair);
                        continue;
                    }
                }
                if (chosenPiece instanceof YungJigsawSinglePoolElement && !(yungJigsawPiece = (YungJigsawSinglePoolElement)chosenPiece).isAtValidDepth(depth)) {
                    totalWeightSum -= n;
                    candidatePieces.remove(chosenPiecePair);
                    continue;
                }
                for (class_2470 rotation : class_2470.method_16547((class_5819)this.rand)) {
                    List candidateJigsawBlocks = chosenPiece.method_16627(this.structureTemplateManager, class_2338.field_10980, rotation, this.rand);
                    class_3341 tempCandidateBoundingBox = chosenPiece.method_16628(this.structureTemplateManager, class_2338.field_10980, rotation);
                    int candidateHeightAdjustments = 0;
                    if (useExpansionHack && tempCandidateBoundingBox.method_14660() <= 16) {
                        candidateHeightAdjustments = candidateJigsawBlocks.stream().mapToInt(pieceCandidateJigsawBlock -> {
                            if (!tempCandidateBoundingBox.method_14662((class_2382)pieceCandidateJigsawBlock.field_15597.method_10093(class_3748.method_26378((class_2680)pieceCandidateJigsawBlock.field_15596)))) {
                                return 0;
                            }
                            class_2960 candidateTargetPool = new class_2960(pieceCandidateJigsawBlock.field_15595.method_10558("pool"));
                            Optional candidateTargetPoolOptional = this.poolRegistry.method_17966(candidateTargetPool);
                            Optional<Integer> candidateTargetFallbackOptional = candidateTargetPoolOptional.flatMap(StructureTemplatePool -> this.poolRegistry.method_17966(StructureTemplatePool.method_16634()));
                            int tallestCandidateTargetPoolPieceHeight = candidateTargetPoolOptional.map(structureTemplatePool -> structureTemplatePool.method_19309(this.structureTemplateManager)).orElse(0);
                            int tallestCandidateTargetFallbackPieceHeight = candidateTargetFallbackOptional.map(structureTemplatePool -> structureTemplatePool.method_19309(this.structureTemplateManager)).orElse(0);
                            return Math.max(tallestCandidateTargetPoolPieceHeight, tallestCandidateTargetFallbackPieceHeight);
                        }).max().orElse(0);
                    }
                    for (class_3499.class_3501 candidateJigsawBlock : candidateJigsawBlocks) {
                        int candidateJigsawBlockY;
                        ConditionContext ctx;
                        YungJigsawSinglePoolElement yungJigsawPiece2;
                        int adjustedCandidatePieceMinY;
                        if (!class_3748.method_16546((class_3499.class_3501)jigsawBlock, (class_3499.class_3501)candidateJigsawBlock)) continue;
                        class_2338 candidateJigsawBlockPos = candidateJigsawBlock.field_15597;
                        class_2338 candidateJigsawBlockRelativePos = jigsawBlockTargetPos.method_10059((class_2382)candidateJigsawBlockPos);
                        class_3341 rotatedCandidateBoundingBox = chosenPiece.method_16628(this.structureTemplateManager, candidateJigsawBlockRelativePos, rotation);
                        class_3785.class_3786 candidatePlacementBehavior = chosenPiece.method_16624();
                        boolean isCandidateRigid = candidatePlacementBehavior == class_3785.class_3786.field_16687;
                        int candidateJigsawBlockRelativeY = candidateJigsawBlockPos.method_10264();
                        int candidateJigsawYOffsetNeeded = jigsawBlockRelativeY - candidateJigsawBlockRelativeY + class_3748.method_26378((class_2680)jigsawBlock.field_15596).method_10164();
                        if (isPieceRigid && isCandidateRigid) {
                            adjustedCandidatePieceMinY = pieceMinY + candidateJigsawYOffsetNeeded;
                        } else {
                            if (surfaceHeight == -1) {
                                surfaceHeight = this.chunkGenerator.method_20402(jigsawBlockPos.method_10263(), jigsawBlockPos.method_10260(), class_2902.class_2903.field_13194, levelHeightAccessor, randomState);
                            }
                            adjustedCandidatePieceMinY = surfaceHeight - candidateJigsawBlockRelativeY;
                        }
                        int candidatePieceYOffsetNeeded = adjustedCandidatePieceMinY - rotatedCandidateBoundingBox.method_35416();
                        class_3341 adjustedCandidateBoundingBox = rotatedCandidateBoundingBox.method_19311(0, candidatePieceYOffsetNeeded, 0);
                        class_2338 adjustedCandidateJigsawBlockRelativePos = candidateJigsawBlockRelativePos.method_10069(0, candidatePieceYOffsetNeeded, 0);
                        if (candidateHeightAdjustments > 0) {
                            int k2 = Math.max(candidateHeightAdjustments + 1, adjustedCandidateBoundingBox.method_35419() - adjustedCandidateBoundingBox.method_35416());
                            ((BoundingBoxAccessor)adjustedCandidateBoundingBox).setMaxY(adjustedCandidateBoundingBox.method_35416() + k2);
                        }
                        if (this.maxY.isPresent() && adjustedCandidateBoundingBox.method_35419() > this.maxY.get() || this.minY.isPresent() && adjustedCandidateBoundingBox.method_35416() < this.minY.get()) continue;
                        class_238 aabb = class_238.method_19316((class_3341)adjustedCandidateBoundingBox);
                        class_238 aabbDeflated = aabb.method_1011(0.25);
                        boolean pieceIgnoresBounds = false;
                        if (chosenPiece instanceof YungJigsawSinglePoolElement) {
                            YungJigsawSinglePoolElement yungJigsawPiece3 = (YungJigsawSinglePoolElement)chosenPiece;
                            pieceIgnoresBounds = yungJigsawPiece3.ignoresBounds();
                        }
                        if (!pieceIgnoresBounds) {
                            boolean pieceIntersectsExistingPieces = ((BoxOctree)boxOctree.getValue()).intersectsAnyBox(aabbDeflated);
                            boolean pieceIsContainedWithinStructureBoundaries = ((BoxOctree)boxOctree.getValue()).boundaryContains(aabbDeflated);
                            if (pieceIntersectsExistingPieces || !pieceIsContainedWithinStructureBoundaries) continue;
                        }
                        if (chosenPiece instanceof YungJigsawSinglePoolElement && !(yungJigsawPiece2 = (YungJigsawSinglePoolElement)chosenPiece).passesConditions(ctx = new ConditionContext(adjustedCandidateBoundingBox.method_35416(), adjustedCandidateBoundingBox.method_35419()))) continue;
                        ((BoxOctree)boxOctree.getValue()).addBox(aabb);
                        int newPieceGroundLevelDelta = piece.method_16646();
                        int groundLevelDelta = isCandidateRigid ? newPieceGroundLevelDelta - candidateJigsawYOffsetNeeded : chosenPiece.method_19308();
                        class_3790 newPiece = new class_3790(this.structureTemplateManager, chosenPiece, adjustedCandidateJigsawBlockRelativePos, groundLevelDelta, rotation, adjustedCandidateBoundingBox);
                        if (isPieceRigid) {
                            candidateJigsawBlockY = pieceMinY + jigsawBlockRelativeY;
                        } else if (isCandidateRigid) {
                            candidateJigsawBlockY = adjustedCandidatePieceMinY + candidateJigsawBlockRelativeY;
                        } else {
                            if (surfaceHeight == -1) {
                                surfaceHeight = this.chunkGenerator.method_20402(jigsawBlockPos.method_10263(), jigsawBlockPos.method_10260(), class_2902.class_2903.field_13194, levelHeightAccessor, randomState);
                            }
                            candidateJigsawBlockY = surfaceHeight + candidateJigsawYOffsetNeeded / 2;
                        }
                        piece.method_16647(new class_3780(jigsawBlockTargetPos.method_10263(), candidateJigsawBlockY - jigsawBlockRelativeY + newPieceGroundLevelDelta, jigsawBlockTargetPos.method_10260(), candidateJigsawYOffsetNeeded, candidatePlacementBehavior));
                        newPiece.method_16647(new class_3780(jigsawBlockPos.method_10263(), candidateJigsawBlockY - candidateJigsawBlockRelativeY + groundLevelDelta, jigsawBlockPos.method_10260(), -candidateJigsawYOffsetNeeded, piece.method_16644().method_16624()));
                        this.pieces.add((class_3790)newPiece);
                        if (depth + 1 <= this.maxDepth) {
                            this.pieceQueue.addLast(new PieceEntry(newPiece, boxOctree, depth + 1));
                        }
                        if (chosenPiece instanceof YungJigsawSinglePoolElement) {
                            YungJigsawSinglePoolElement yungJigsawPiece4 = (YungJigsawSinglePoolElement)chosenPiece;
                            if (yungJigsawPiece4.maxCount.isPresent()) {
                                if (yungJigsawPiece4.name.isEmpty()) {
                                    return chosenPiece;
                                }
                                String pieceName = yungJigsawPiece4.name.get();
                                this.pieceCounts.put(pieceName, this.pieceCounts.getOrDefault(pieceName, 0) + 1);
                            }
                        }
                        if (chosenPiece instanceof IMaxCountJigsawPiece) {
                            String pieceName = ((IMaxCountJigsawPiece)chosenPiece).getName();
                            this.pieceCounts.put(pieceName, this.pieceCounts.getOrDefault(pieceName, 0) + 1);
                        }
                        return chosenPiece;
                    }
                }
                totalWeightSum -= n;
                candidatePieces.remove(chosenPiecePair);
            }
            return null;
        }
    }

    public record PieceEntry(class_3790 piece, MutableObject<BoxOctree> boxOctreeMutableObject, int depth) {
    }
}

