/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterstrongholds.module;

import com.yungnickyoung.minecraft.betterstrongholds.BetterStrongholdsCommon;
import com.yungnickyoung.minecraft.betterstrongholds.config.BSConfigFabric;
import com.yungnickyoung.minecraft.betterstrongholds.world.ArmorStandChances;
import com.yungnickyoung.minecraft.betterstrongholds.world.ItemFrameChances;
import com.yungnickyoung.minecraft.betterstrongholds.world.OreChances;
import com.yungnickyoung.minecraft.betterstrongholds.world.RareBlockChances;
import com.yungnickyoung.minecraft.yungsapi.io.JSON;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.serializer.Toml4jConfigSerializer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1269;

public class ConfigModuleFabric {
    public static final String CUSTOM_CONFIG_PATH = "betterstrongholds";
    public static final String VERSION_PATH = "fabric-1_19_3";

    public static void init() {
        ConfigModuleFabric.initCustomFiles();
        AutoConfig.register(BSConfigFabric.class, Toml4jConfigSerializer::new);
        AutoConfig.getConfigHolder(BSConfigFabric.class).registerSaveListener(ConfigModuleFabric::bakeConfig);
        AutoConfig.getConfigHolder(BSConfigFabric.class).registerLoadListener(ConfigModuleFabric::bakeConfig);
        ConfigModuleFabric.bakeConfig((BSConfigFabric)AutoConfig.getConfigHolder(BSConfigFabric.class).get());
    }

    private static class_1269 bakeConfig(ConfigHolder<BSConfigFabric> configHolder, BSConfigFabric configFabric) {
        ConfigModuleFabric.bakeConfig(configFabric);
        return class_1269.field_5812;
    }

    private static void initCustomFiles() {
        ConfigModuleFabric.createDirectory();
        ConfigModuleFabric.createBaseReadMe();
        ConfigModuleFabric.createJsonReadMe();
        ConfigModuleFabric.loadJSON();
    }

    private static void loadJSON() {
        ConfigModuleFabric.loadOresJSON();
        ConfigModuleFabric.loadRareBlocksJSON();
        ConfigModuleFabric.loadArmorStandsJSON();
        ConfigModuleFabric.loadItemFramesJSON();
    }

    private static void createDirectory() {
        File parentDir = new File(FabricLoader.getInstance().getConfigDir().toString(), CUSTOM_CONFIG_PATH);
        File customConfigDir = new File(parentDir, VERSION_PATH);
        try {
            String filePath = customConfigDir.getCanonicalPath();
            if (customConfigDir.mkdirs()) {
                BetterStrongholdsCommon.LOGGER.info("Creating directory for additional Better Strongholds configuration at {}", (Object)filePath);
            }
        }
        catch (IOException e) {
            BetterStrongholdsCommon.LOGGER.error("ERROR creating Better Strongholds config directory: {}", (Object)e.toString());
        }
    }

    private static void createBaseReadMe() {
        Path path = Paths.get(FabricLoader.getInstance().getConfigDir().toString(), CUSTOM_CONFIG_PATH, "README.txt");
        File readme = new File(path.toString());
        if (!readme.exists()) {
            String readmeText = "This directory is for a few additional options for YUNG's Better Strongholds.\nOptions provided may vary by version.\nThis directory contains subdirectories for supported versions. The first time you run Better Strongholds, a version subdirectory will be created if that version supports advanced options.\nFor example, the first time you use Better Strongholds for MC 1.16 on Forge, the 'forge-1_16' subdirectory will be created in this folder.\nIf no subdirectory for your version is created, then that version probably does not support the additional options.\nNOTE -- MOST OPTIONS CAN BE FOUND IN A CONFIG FILE OUTSIDE THIS FOLDER!\nFor example, on Forge 1.16 the file is 'betterstrongholds-forge-1_16.toml'.";
            try {
                Files.write(path, readmeText.getBytes(), new OpenOption[0]);
            }
            catch (IOException e) {
                BetterStrongholdsCommon.LOGGER.error("Unable to create README file!");
            }
        }
    }

    private static void createJsonReadMe() {
        Path path = Paths.get(FabricLoader.getInstance().getConfigDir().toString(), CUSTOM_CONFIG_PATH, VERSION_PATH, "README.txt");
        File readme = new File(path.toString());
        if (!readme.exists()) {
            String readmeText = "######################################\n#             ores.json              #\n######################################\n  This file contains a BlockSetSelector (see below) describing the probability of a given ore being chosen.\nThese probabilities are used in treasure rooms in the stronghold, in which\npiles of ore have a chance of spawning.\nFor information on BlockSetSelectors, see the bottom of this README.\n######################################\n#          rareblocks.json           #\n######################################\n  This file contains a BlockSetSelector describing the probability of a given block being chosen.\nThese probabilities are used in grand libraries, in which\ntwo rare blocks will spawn.\nFor information on BlockSetSelectors, see the bottom of this README.\n######################################\n#          armorstands.json          #\n######################################\n  This file contains ItemSetSelectors describing the probability distribution of armor on armor stands.\nCommon armor stands spawn in Armoury rooms, while Rare ones are only available in the rare Commander rooms.\nFor information on ItemSetSelectors, see the bottom of this README.\n######################################\n#          itemframes.json          #\n######################################\n  This file contains ItemSetSelectors describing the probability distribution of items in item frames.\nItem frames only spawn in storage rooms and armoury rooms.\nFor information on ItemSetSelectors, see the bottom of this README.\n######################################\n#         BlockSetSelectors          #\n######################################\nDescribes a set of blockstates and the probability of each blockstate being chosen.\n - entries: An object where each entry's key is a blockstate, and each value is that blockstate's probability of being chosen.\n      The total sum of all probabilities SHOULD NOT exceed 1.0!\n - defaultBlock: The blockstate used for any leftover probability ranges.\n      For example, if the total sum of all the probabilities of the entries is 0.6, then\n      there is a 0.4 chance of the defaultBlock being selected.\nHere's an example block selector:\n\"entries\": {\n  \"minecraft:cobblestone\": 0.25,\n  \"minecraft:air\": 0.2,\n  \"minecraft:stone_bricks\": 0.1\n},\n\"defaultBlock\": \"minecraft:oak_planks\"\nFor each block, this selector has a 25% chance of returning cobblestone, 20% chance of choosing air,\n10% chance of choosing stone bricks, and a 100 - (25 + 20 + 10) = 45% chance of choosing oak planks (since it's the default block).\n######################################\n#         ItemSetSelectors           #\n######################################\nDescribes a set of items and the probability of each item being chosen.\nWorks the same as BlockSetSelectors, but with items instead of blockstates.\n";
            try {
                Files.write(path, readmeText.getBytes(), new OpenOption[0]);
            }
            catch (IOException e) {
                BetterStrongholdsCommon.LOGGER.error("Unable to create ores and rare blocks README file!");
            }
        }
    }

    private static void loadOresJSON() {
        Path jsonPath = Paths.get(FabricLoader.getInstance().getConfigDir().toString(), CUSTOM_CONFIG_PATH, VERSION_PATH, "ores.json");
        File jsonFile = new File(jsonPath.toString());
        if (!jsonFile.exists()) {
            try {
                JSON.createJsonFileFromObject((Path)jsonPath, (Object)OreChances.get());
            }
            catch (IOException e) {
                BetterStrongholdsCommon.LOGGER.error("Unable to create ores.json file: {}", (Object)e.toString());
            }
        } else {
            if (!jsonFile.canRead()) {
                BetterStrongholdsCommon.LOGGER.error("Better Strongholds ores.json file not readable! Using default configuration...");
                return;
            }
            try {
                OreChances.instance = (OreChances)JSON.loadObjectFromJsonFile((Path)jsonPath, OreChances.class);
            }
            catch (IOException e) {
                BetterStrongholdsCommon.LOGGER.error("Error loading Better Strongholds ores.json file: {}", (Object)e.toString());
                BetterStrongholdsCommon.LOGGER.error("Using default configuration...");
            }
        }
    }

    private static void loadRareBlocksJSON() {
        Path jsonPath = Paths.get(FabricLoader.getInstance().getConfigDir().toString(), CUSTOM_CONFIG_PATH, VERSION_PATH, "rareblocks.json");
        File jsonFile = new File(jsonPath.toString());
        if (!jsonFile.exists()) {
            try {
                JSON.createJsonFileFromObject((Path)jsonPath, (Object)RareBlockChances.get());
            }
            catch (IOException e) {
                BetterStrongholdsCommon.LOGGER.error("Unable to create rareblocks.json file: {}", (Object)e.toString());
            }
        } else {
            if (!jsonFile.canRead()) {
                BetterStrongholdsCommon.LOGGER.error("Better Strongholds rareblocks.json file not readable! Using default configuration...");
                return;
            }
            try {
                RareBlockChances.instance = (RareBlockChances)JSON.loadObjectFromJsonFile((Path)jsonPath, RareBlockChances.class);
            }
            catch (IOException e) {
                BetterStrongholdsCommon.LOGGER.error("Error loading Better Strongholds rareblocks.json file: {}", (Object)e.toString());
                BetterStrongholdsCommon.LOGGER.error("Using default configuration...");
            }
        }
    }

    private static void loadArmorStandsJSON() {
        Path jsonPath = Paths.get(FabricLoader.getInstance().getConfigDir().toString(), CUSTOM_CONFIG_PATH, VERSION_PATH, "armorstands.json");
        File jsonFile = new File(jsonPath.toString());
        if (!jsonFile.exists()) {
            try {
                JSON.createJsonFileFromObject((Path)jsonPath, (Object)ArmorStandChances.get());
            }
            catch (IOException e) {
                BetterStrongholdsCommon.LOGGER.error("Unable to create armorstands.json file: {}", (Object)e.toString());
            }
        } else {
            if (!jsonFile.canRead()) {
                BetterStrongholdsCommon.LOGGER.error("Better Strongholds armorstands.json file not readable! Using default configuration...");
                return;
            }
            try {
                ArmorStandChances.instance = (ArmorStandChances)JSON.loadObjectFromJsonFile((Path)jsonPath, ArmorStandChances.class);
            }
            catch (IOException e) {
                BetterStrongholdsCommon.LOGGER.error("Error loading Better Strongholds armorstands.json file: {}", (Object)e.toString());
                BetterStrongholdsCommon.LOGGER.error("Using default configuration...");
            }
        }
    }

    private static void loadItemFramesJSON() {
        Path jsonPath = Paths.get(FabricLoader.getInstance().getConfigDir().toString(), CUSTOM_CONFIG_PATH, VERSION_PATH, "itemframes.json");
        File jsonFile = new File(jsonPath.toString());
        if (!jsonFile.exists()) {
            try {
                JSON.createJsonFileFromObject((Path)jsonPath, (Object)ItemFrameChances.get());
            }
            catch (IOException e) {
                BetterStrongholdsCommon.LOGGER.error("Unable to create itemframes.json file: {}", (Object)e.toString());
            }
        } else {
            if (!jsonFile.canRead()) {
                BetterStrongholdsCommon.LOGGER.error("Better Strongholds itemframes.json file not readable! Using default configuration...");
                return;
            }
            try {
                ItemFrameChances.instance = (ItemFrameChances)JSON.loadObjectFromJsonFile((Path)jsonPath, ItemFrameChances.class);
            }
            catch (IOException e) {
                BetterStrongholdsCommon.LOGGER.error("Error loading Better Strongholds itemframes.json file: {}", (Object)e.toString());
                BetterStrongholdsCommon.LOGGER.error("Using default configuration...");
            }
        }
    }

    private static void bakeConfig(BSConfigFabric configFabric) {
        BetterStrongholdsCommon.CONFIG.general.cobwebReplacementChanceNormal = configFabric.betterStrongholds.general.cobwebReplacementChanceNormal;
        BetterStrongholdsCommon.CONFIG.general.cobwebReplacementChanceSpawner = configFabric.betterStrongholds.general.cobwebReplacementChanceSpawner;
        BetterStrongholdsCommon.CONFIG.general.torchSpawnRate = configFabric.betterStrongholds.general.torchSpawnRate;
        BetterStrongholdsCommon.CONFIG.general.lanternSpawnRate = configFabric.betterStrongholds.general.lanternSpawnRate;
    }
}

