/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.advancementplaques;

import com.anthonyhilyard.advancementplaques.Loader;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class AdvancementPlaquesConfig {
    public static final ForgeConfigSpec SPEC;
    public static final AdvancementPlaquesConfig INSTANCE;
    public final ForgeConfigSpec.BooleanValue onTop;
    public final ForgeConfigSpec.IntValue distance;
    public final ForgeConfigSpec.BooleanValue hideWaila;
    public final ForgeConfigSpec.BooleanValue tasks;
    public final ForgeConfigSpec.BooleanValue goals;
    public final ForgeConfigSpec.BooleanValue challenges;

    public AdvancementPlaquesConfig(ForgeConfigSpec.Builder build) {
        build.comment("Client Configuration").push("client").push("visual_options");
        this.onTop = build.comment("If plaques should show on the top of the screen.").define("on_top", true);
        this.distance = build.comment("The distance from the top or bottom of the screen, in pixels.").defineInRange("distance", 42, 8, 256);
        this.hideWaila = build.comment("Hide waila/hwyla/jade popups while plaques are showing.").define("hide_waila", false);
        this.tasks = build.comment("If plaques should show for task advancements (normal advancements).").define("tasks", true);
        this.goals = build.comment("If plaques should show for goal advancements (medium-difficulty advancements).").define("goals", true);
        this.challenges = build.comment("If plaques should show for challenge advancements (high-difficulty advancements).").define("challenges", true);
        build.pop().pop();
    }

    @SubscribeEvent
    public static void onLoad(ModConfig.Loading e) {
        if (e.getConfig().getModId().equals("advancementplaques")) {
            Loader.LOGGER.info("Advancement Plaques config reloaded.");
        }
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(AdvancementPlaquesConfig::new);
        SPEC = (ForgeConfigSpec)specPair.getRight();
        INSTANCE = (AdvancementPlaquesConfig)specPair.getLeft();
    }
}

