/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.advancementplaques;

import com.anthonyhilyard.advancementplaques.AdvancementPlaque;
import com.anthonyhilyard.advancementplaques.AdvancementPlaquesConfig;
import com.anthonyhilyard.advancementplaques.CustomItemRenderer;
import com.google.common.collect.Queues;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Arrays;
import java.util.Deque;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.FrameType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.toasts.AdvancementToast;
import net.minecraft.client.gui.toasts.IToast;
import net.minecraft.client.gui.toasts.ToastGui;
import net.minecraftforge.fml.ModList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AdvancementPlaquesToastGui
extends ToastGui {
    private static final Logger LOGGER = LogManager.getLogger();
    private final AdvancementPlaque[] plaques = new AdvancementPlaque[3];
    private final Deque<AdvancementToast> advancementToastsQueue = Queues.newArrayDeque();
    private final Minecraft mc;
    private final CustomItemRenderer itemRenderer;

    public AdvancementPlaquesToastGui(Minecraft mcIn) {
        super(mcIn);
        this.mc = mcIn;
        this.itemRenderer = new CustomItemRenderer(this.mc.func_110434_K(), this.mc.func_209506_al(), this.mc.getItemColors(), this.mc);
    }

    public void func_192988_a(IToast toastIn) {
        if (toastIn instanceof AdvancementToast) {
            AdvancementToast advancementToast = (AdvancementToast)toastIn;
            DisplayInfo displayInfo = advancementToast.field_193679_c.func_192068_c();
            if (displayInfo.func_192291_d() == FrameType.TASK && (Boolean)AdvancementPlaquesConfig.INSTANCE.tasks.get() != false || displayInfo.func_192291_d() == FrameType.GOAL && (Boolean)AdvancementPlaquesConfig.INSTANCE.goals.get() != false || displayInfo.func_192291_d() == FrameType.CHALLENGE && ((Boolean)AdvancementPlaquesConfig.INSTANCE.challenges.get()).booleanValue()) {
                this.advancementToastsQueue.add((AdvancementToast)toastIn);
                return;
            }
        }
        super.func_192988_a(toastIn);
    }

    public void func_238541_a_(MatrixStack stack) {
        if (!this.mc.field_71474_y.field_74319_N) {
            super.func_238541_a_(stack);
            try {
                if (((Boolean)AdvancementPlaquesConfig.INSTANCE.hideWaila.get()).booleanValue() && ModList.get().isLoaded("waila")) {
                    boolean anyPlaques = false;
                    for (int i = 0; i < this.plaques.length; ++i) {
                        if (this.plaques[i] == null) continue;
                        anyPlaques = true;
                        break;
                    }
                    if (anyPlaques) {
                        Class.forName("com.anthonyhilyard.advancementplaques.WailaHandler").getMethod("disableWaila", new Class[0]).invoke(null, new Object[0]);
                    } else {
                        Class.forName("com.anthonyhilyard.advancementplaques.WailaHandler").getMethod("enableWaila", new Class[0]).invoke(null, new Object[0]);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)e);
            }
            for (int i = 0; i < this.plaques.length; ++i) {
                AdvancementPlaque toastinstance = this.plaques[i];
                if (toastinstance != null && toastinstance.render(this.mc.func_228018_at_().func_198107_o(), i, stack)) {
                    this.plaques[i] = null;
                }
                if (this.plaques[i] != null || this.advancementToastsQueue.isEmpty()) continue;
                this.plaques[i] = new AdvancementPlaque(this.advancementToastsQueue.removeFirst(), this.mc, this.itemRenderer);
            }
        }
    }

    public void func_191788_b() {
        super.func_191788_b();
        Arrays.fill(this.plaques, null);
        this.advancementToastsQueue.clear();
    }
}

