/*
 * Decompiled with CFR 0.152.
 */
package wile.anthillinside;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import wile.anthillinside.ModConfig;
import wile.anthillinside.ModContent;
import wile.anthillinside.blocks.RedAntHive;
import wile.anthillinside.libmc.detail.Auxiliaries;
import wile.anthillinside.libmc.detail.Networking;
import wile.anthillinside.libmc.detail.Overlay;

@Mod(value="anthillinside")
public class ModAnthillInside {
    public static final String MODID = "anthillinside";
    public static final String MODNAME = "Anthill Inside";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final CreativeModeTab ITEMGROUP = new CreativeModeTab("tabanthillinside"){

        @OnlyIn(value=Dist.CLIENT)
        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)ModContent.ANTS_ITEM);
        }
    };

    public ModAnthillInside() {
        Auxiliaries.init(MODID, LOGGER, ModConfig::getServerConfig);
        Auxiliaries.logGitVersion(MODNAME);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ModConfig.COMMON_CONFIG_SPEC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onClientSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.addListener(ForgeEvents::onBlockBroken);
    }

    public static Logger logger() {
        return LOGGER;
    }

    private void onSetup(FMLCommonSetupEvent event) {
        Networking.init(MODID);
        ModConfig.apply();
    }

    private void onClientSetup(FMLClientSetupEvent event) {
        Overlay.register();
        ModContent.registerTileEntityRenderers();
        ModContent.registerContainerGuis();
        ModContent.processContentClientSide();
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static final class ForgeEvents {
        @SubscribeEvent
        public static void onBlocksRegistry(RegistryEvent.Register<Block> event) {
            ModContent.allBlocks().forEach(e -> event.getRegistry().register((IForgeRegistryEntry)e));
        }

        @SubscribeEvent
        public static void onItemRegistry(RegistryEvent.Register<Item> event) {
            ModContent.allItems().forEach(e -> event.getRegistry().register((IForgeRegistryEntry)e));
            ItemTags.createOptional((ResourceLocation)new ResourceLocation(ModAnthillInside.MODID, "fertilizers"));
        }

        @SubscribeEvent
        public static void onTileEntityRegistry(RegistryEvent.Register<BlockEntityType<?>> event) {
            ModContent.allTileEntityTypes().forEach(e -> event.getRegistry().register((IForgeRegistryEntry)e));
        }

        @SubscribeEvent
        public static void onRegisterEntityTypes(RegistryEvent.Register<EntityType<?>> event) {
            ModContent.allEntityTypes().forEach(e -> event.getRegistry().register((IForgeRegistryEntry)e));
        }

        @SubscribeEvent
        public static void onRegisterContainerTypes(RegistryEvent.Register<MenuType<?>> event) {
            ModContent.allContainerTypes().forEach(e -> event.getRegistry().register((IForgeRegistryEntry)e));
        }

        public static void onBlockBroken(BlockEvent.BreakEvent event) {
            if (event.getState() == null || event.getPlayer() == null) {
                return;
            }
            RedAntHive.onGlobalPlayerBlockBrokenEvent(event.getState(), event.getWorld(), event.getPos(), event.getPlayer());
        }
    }
}

