/*
 * Decompiled with CFR 0.152.
 */
package wile.anthillinside;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.Logger;
import wile.anthillinside.ModAnthillInside;
import wile.anthillinside.blocks.RedAntHive;
import wile.anthillinside.blocks.RedAntTrail;
import wile.anthillinside.items.AntsItem;
import wile.anthillinside.items.RedSugarItem;
import wile.anthillinside.libmc.blocks.StandardBlocks;
import wile.anthillinside.libmc.detail.Auxiliaries;

public class ModContent {
    private static final Logger LOGGER = ModAnthillInside.LOGGER;
    private static final String MODID = "anthillinside";
    public static final RedAntHive.RedAntHiveBlock HIVE_BLOCK = (RedAntHive.RedAntHiveBlock)new RedAntHive.RedAntHiveBlock(41L, BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76409_).m_60913_(2.0f, 6.0f).m_60918_(SoundType.f_56742_), new AABB[]{Auxiliaries.getPixeledAABB(1.0, 1.0, 0.0, 15.0, 15.0, 1.0), Auxiliaries.getPixeledAABB(0.0, 0.0, 1.0, 16.0, 16.0, 16.0)}).setRegistryName(new ResourceLocation("anthillinside", "hive"));
    public static final RedAntTrail.RedAntTrailBlock TRAIL_BLOCK = (RedAntTrail.RedAntTrailBlock)new RedAntTrail.RedAntTrailBlock(52L, BlockBehaviour.Properties.m_60944_((Material)Material.f_76310_, (MaterialColor)MaterialColor.f_76362_).m_60913_(0.1f, 3.0f).m_60918_(SoundType.f_56758_).m_60910_().m_60955_().m_60922_((s, w, p, e) -> false).m_60967_(1.2f).m_60977_()).setRegistryName(new ResourceLocation("anthillinside", "trail"));
    private static final Block[] modBlocks = new Block[]{HIVE_BLOCK, TRAIL_BLOCK};
    public static final RedSugarItem RED_SUGAR_ITEM = (RedSugarItem)new RedSugarItem(ModContent.default_item_properties().m_41497_(Rarity.UNCOMMON)).setRegistryName("anthillinside", "red_sugar");
    public static final AntsItem ANTS_ITEM = (AntsItem)new AntsItem((Block)TRAIL_BLOCK, ModContent.default_item_properties().m_41497_(Rarity.UNCOMMON)).setRegistryName("anthillinside", "ants");
    private static final Item[] modItems = new Item[]{RED_SUGAR_ITEM, ANTS_ITEM};
    public static final BlockEntityType<RedAntHive.RedAntHiveTileEntity> TET_HIVE = (BlockEntityType)BlockEntityType.Builder.m_155273_(RedAntHive.RedAntHiveTileEntity::new, (Block[])new Block[]{HIVE_BLOCK}).m_58966_(null).setRegistryName("anthillinside", "te_hive");
    private static final BlockEntityType<?>[] tile_entity_types = new BlockEntityType[]{TET_HIVE};
    private static final EntityType<?>[] entity_types = new EntityType[0];
    public static final MenuType<RedAntHive.RedAntHiveMenu> CT_HIVE = new MenuType(RedAntHive.RedAntHiveMenu::new);
    private static final MenuType<?>[] container_types;
    private static final List<Item> registeredItems;

    private static Item.Properties default_item_properties() {
        return new Item.Properties().m_41491_(ModAnthillInside.ITEMGROUP);
    }

    public static List<Block> allBlocks() {
        return Arrays.asList(modBlocks);
    }

    public static List<Item> allItems() {
        if (!registeredItems.isEmpty()) {
            return registeredItems;
        }
        HashMap<ResourceLocation, Item> items = new HashMap<ResourceLocation, Item>();
        for (Item item : modItems) {
            items.put(item.getRegistryName(), item);
        }
        for (Item item : modBlocks) {
            BlockItem item2;
            ResourceLocation rl = item.getRegistryName();
            if (rl == null || items.containsValue(item2 = item instanceof StandardBlocks.IBlockItemFactory ? ((StandardBlocks.IBlockItemFactory)item).getBlockItem((Block)item, new Item.Properties().m_41491_(ModAnthillInside.ITEMGROUP)) : new BlockItem((Block)item, new Item.Properties().m_41491_(ModAnthillInside.ITEMGROUP))) || items.containsKey(item2.getRegistryName())) continue;
            items.put(rl, (Item)item2.setRegistryName(rl));
        }
        registeredItems.addAll(items.values());
        return registeredItems;
    }

    public static List<EntityType<?>> allEntityTypes() {
        return Arrays.asList(entity_types);
    }

    public static List<MenuType<?>> allContainerTypes() {
        return Arrays.asList(container_types);
    }

    public static List<BlockEntityType<?>> allTileEntityTypes() {
        return Arrays.asList(tile_entity_types);
    }

    public static boolean isExperimentalBlock(Block block) {
        return false;
    }

    @Nonnull
    public static List<Block> getRegisteredBlocks() {
        return Collections.unmodifiableList(Arrays.asList(modBlocks));
    }

    @Nonnull
    public static List<Item> getRegisteredItems() {
        return Collections.unmodifiableList(Arrays.asList(modItems));
    }

    public static void registerContainerGuis() {
        MenuScreens.m_96206_(CT_HIVE, RedAntHive.RedAntHiveGui::new);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerTileEntityRenderers() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void processContentClientSide() {
        for (Block block : ModContent.getRegisteredBlocks()) {
            if (!(block instanceof StandardBlocks.IStandardBlock)) continue;
            switch (((StandardBlocks.IStandardBlock)block).getRenderTypeHint()) {
                case CUTOUT: {
                    ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)RenderType.m_110463_());
                    break;
                }
                case CUTOUT_MIPPED: {
                    ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)RenderType.m_110457_());
                    break;
                }
                case TRANSLUCENT: {
                    ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)RenderType.m_110466_());
                    break;
                }
                case TRANSLUCENT_NO_CRUMBLING: {
                    ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)RenderType.m_110472_());
                    break;
                }
            }
        }
    }

    static {
        CT_HIVE.setRegistryName(MODID, "ct_hive");
        container_types = new MenuType[]{CT_HIVE};
        registeredItems = new ArrayList<Item>();
    }
}

