/*
 * Decompiled with CFR 0.152.
 */
package wile.anthillinside.blocks;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.IItemHandler;
import wile.anthillinside.ModContent;
import wile.anthillinside.libmc.blocks.StandardBlocks;
import wile.anthillinside.libmc.detail.Auxiliaries;
import wile.anthillinside.libmc.detail.Inventories;

public class RedAntTrail {
    private static double speed_modifier = 1.0;

    public static void on_config(int speed_percent) {
        speed_modifier = (double)Mth.m_14045_((int)speed_percent, (int)25, (int)200) / 100.0;
    }

    public static class RedAntTrailBlock
    extends StandardBlocks.HorizontalWaterLoggable
    implements StandardBlocks.IBlockItemFactory {
        public static final BooleanProperty FRONT = BooleanProperty.m_61465_((String)"front");
        public static final BooleanProperty LEFT = BooleanProperty.m_61465_((String)"left");
        public static final BooleanProperty RIGHT = BooleanProperty.m_61465_((String)"right");
        public static final BooleanProperty UP = BooleanProperty.m_61465_((String)"up");

        public RedAntTrailBlock(long config, BlockBehaviour.Properties builder) {
            super(config, builder, (List<BlockState> states) -> {
                HashMap<BlockState, VoxelShape> shapes = new HashMap<BlockState, VoxelShape>();
                AABB base_aabb = Auxiliaries.getPixeledAABB(0.0, 0.0, 0.0, 16.0, 0.2, 16.0);
                AABB up_aabb = Auxiliaries.getPixeledAABB(0.0, 0.0, 0.0, 16.0, 16.0, 0.2);
                for (BlockState state : states) {
                    Direction facing = (Direction)state.m_61143_((Property)HORIZONTAL_FACING);
                    VoxelShape shape = Shapes.m_83040_();
                    if (((Boolean)state.m_61143_((Property)UP)).booleanValue()) {
                        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83064_((AABB)Auxiliaries.getRotatedAABB(up_aabb, facing, true)), (BooleanOp)BooleanOp.f_82695_);
                    }
                    if (((Boolean)state.m_61143_((Property)FRONT)).booleanValue() || !((Boolean)state.m_61143_((Property)UP)).booleanValue()) {
                        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83064_((AABB)Auxiliaries.getRotatedAABB(base_aabb, facing, true)), (BooleanOp)BooleanOp.f_82695_);
                    }
                    shapes.putIfAbsent(state, shape);
                }
                return shapes;
            });
            this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)super.m_49966_().m_61124_((Property)FRONT, (Comparable)Boolean.valueOf(true))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LEFT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)RIGHT, (Comparable)Boolean.valueOf(false)));
        }

        @Override
        public BlockItem getBlockItem(Block block, Item.Properties builder) {
            return ModContent.ANTS_ITEM;
        }

        @Override
        public boolean hasDynamicDropList() {
            return true;
        }

        public Item m_5456_() {
            return ModContent.ANTS_ITEM;
        }

        @Override
        public List<ItemStack> dropList(BlockState state, Level world, BlockEntity te, boolean explosion) {
            return Collections.singletonList(new ItemStack((ItemLike)this.m_5456_()));
        }

        @Override
        protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
            super.m_7926_(builder);
            builder.m_61104_(new Property[]{FRONT, LEFT, RIGHT, UP});
        }

        @Override
        @Nullable
        public BlockState m_5573_(BlockPlaceContext context) {
            BlockState state = super.m_5573_(context);
            if (state == null) {
                return null;
            }
            if (!((Boolean)state.m_61143_((Property)UP)).booleanValue() && context.m_43719_().m_122434_().m_122478_() && !Block.m_49936_((BlockGetter)context.m_43725_(), (BlockPos)context.m_8083_().m_7495_())) {
                return null;
            }
            return this.updatedState(state, (LevelAccessor)context.m_43725_(), context.m_8083_());
        }

        public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
            Direction block_facing = (Direction)state.m_61143_((Property)HORIZONTAL_FACING);
            for (Direction facing : Direction.values()) {
                Direction diagonal_facing;
                BlockPos diagonal_pos;
                BlockState diagonal_state;
                if (!facing.m_122434_().m_122479_() || facing == block_facing || !(diagonal_state = world.m_8055_(diagonal_pos = pos.m_142300_(facing).m_7495_())).m_60713_((Block)this) || ((Boolean)diagonal_state.m_61143_((Property)UP)).booleanValue() || (diagonal_facing = (Direction)diagonal_state.m_61143_((Property)HORIZONTAL_FACING)) != facing.m_122424_()) continue;
                world.m_7731_(diagonal_pos, (BlockState)diagonal_state.m_61124_((Property)UP, (Comparable)Boolean.valueOf(true)), 2);
            }
        }

        @Override
        public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos pos, BlockPos facingPos) {
            if (!(world instanceof Level)) {
                return state;
            }
            if (this.m_7898_(state, (LevelReader)world, pos)) {
                return this.updatedState(state, world, pos);
            }
            return Blocks.f_50016_.m_49966_();
        }

        public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
            if (Block.m_49918_((VoxelShape)world.m_8055_(pos.m_7495_()).m_60808_((BlockGetter)world, pos.m_7495_()), (Direction)Direction.UP)) {
                return true;
            }
            if (!((Boolean)state.m_61143_((Property)UP)).booleanValue()) {
                return false;
            }
            Direction facing = (Direction)state.m_61143_((Property)HORIZONTAL_FACING);
            return Block.m_49918_((VoxelShape)world.m_8055_(pos.m_142300_(facing)).m_60808_((BlockGetter)world, pos.m_142300_(facing)), (Direction)facing.m_122424_());
        }

        @Override
        public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rtr) {
            Direction dir = rtr.m_82434_().m_122424_();
            return world.m_8055_(pos.m_142300_(dir)).m_60664_(world, player, hand, new BlockHitResult(rtr.m_82450_(), rtr.m_82434_(), pos.m_142300_(dir), false));
        }

        public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
            if (entity instanceof ItemEntity) {
                this.moveEntity(state, world, pos, entity);
                if (((Boolean)state.m_61143_((Property)UP)).booleanValue() && !world.m_6219_().m_5916_(pos, (Object)this)) {
                    world.m_6219_().m_5945_(pos, (Object)this, 60);
                }
            } else if (entity instanceof LivingEntity) {
                this.itchEntity(state, world, pos, entity);
            }
        }

        @Override
        public void m_7458_(BlockState state, ServerLevel world, BlockPos pos, Random rand) {
            if (!((Boolean)state.m_61143_((Property)UP)).booleanValue()) {
                return;
            }
            BlockState st = world.m_8055_(pos.m_7494_());
            if (st.m_60713_((Block)this)) {
                return;
            }
            List entities = world.m_6443_(ItemEntity.class, new AABB(pos.m_7494_()).m_82363_(0.0, -0.2, 0.0), Entity::m_6084_);
            Vec3 v = Vec3.m_82528_((Vec3i)((Direction)state.m_61143_((Property)HORIZONTAL_FACING)).m_122436_()).m_82520_(0.0, 1.0, 0.0).m_82490_(0.1);
            for (ItemEntity entity : entities) {
                entity.m_20256_(v);
            }
        }

        public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean unused) {
            world.m_7731_(pos, this.updatedState(state, (LevelAccessor)world, pos), 2);
        }

        public boolean shouldCheckWeakPower(BlockState state, LevelReader world, BlockPos pos, Direction side) {
            return false;
        }

        @Override
        public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, @Nullable Direction side) {
            return true;
        }

        @Override
        public boolean m_7357_(BlockState state, BlockGetter world, BlockPos pos, PathComputationType type) {
            return (Boolean)state.m_61143_((Property)UP) == false || super.m_7357_(state, world, pos, type);
        }

        public BlockState updatedState(@Nullable BlockState state, LevelAccessor world, BlockPos pos) {
            if (state == null || !(world instanceof Level)) {
                return state;
            }
            Direction facing = (Direction)state.m_61143_((Property)HORIZONTAL_FACING);
            boolean down_solid = Block.m_49936_((BlockGetter)world, (BlockPos)pos.m_7495_());
            boolean up_is_cube = world.m_8055_(pos.m_7494_()).m_60796_((BlockGetter)world, pos.m_7494_());
            boolean up = RedAntTrailBlock.m_49918_((VoxelShape)world.m_8055_(pos.m_142300_(facing)).m_60808_((BlockGetter)world, pos.m_142300_(facing)), (Direction)facing.m_122424_()) && (!down_solid || world.m_8055_(pos.m_7494_()).m_60713_((Block)this) || !up_is_cube && world.m_8055_(pos.m_142300_(facing).m_7494_()).m_60713_((Block)this));
            boolean left = false;
            boolean right = false;
            boolean front = down_solid;
            if (((Level)world).m_46753_(pos)) {
                BlockState left_state;
                BlockState right_state = world.m_8055_(pos.m_142300_(facing.m_122427_()));
                if (right_state.m_60713_((Block)this) && right_state.m_61143_((Property)HORIZONTAL_FACING) == facing.m_122427_()) {
                    right = true;
                }
                if ((left_state = world.m_8055_(pos.m_142300_(facing.m_122428_()))).m_60713_((Block)this) && left_state.m_61143_((Property)HORIZONTAL_FACING) == facing.m_122428_()) {
                    left = true;
                }
                if (!right && !left) {
                    front = false;
                }
            } else if (!(right || left || up)) {
                front = true;
            }
            state = (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)FRONT, (Comparable)Boolean.valueOf(front))).m_61124_((Property)RIGHT, (Comparable)Boolean.valueOf(right))).m_61124_((Property)LEFT, (Comparable)Boolean.valueOf(left))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(up));
            return state;
        }

        public void moveEntity(BlockState state, Level world, BlockPos pos, Entity any_entity) {
            Direction dir;
            Direction facing_left;
            BlockState left_state;
            Direction sorting_direction;
            Entity entity;
            if (!any_entity.m_6084_() || !((entity = any_entity) instanceof ItemEntity)) {
                return;
            }
            ItemEntity entity2 = (ItemEntity)entity;
            if (entity2.m_32055_().m_41619_() || entity2.m_32055_().m_41720_() == ModContent.ANTS_ITEM) {
                return;
            }
            boolean up = (Boolean)state.m_61143_((Property)UP);
            if (!up && !entity2.m_20096_()) {
                return;
            }
            double speed = 0.07 * speed_modifier;
            Vec3 dp = entity2.m_20182_().m_82492_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5).m_82490_(2.0);
            if (!up && dp.f_82480_ > 0.0) {
                speed *= 0.2;
            }
            boolean outgoing = false;
            boolean check_insertion_front = false;
            boolean check_insertion_up = false;
            boolean front = (Boolean)state.m_61143_((Property)FRONT);
            boolean right = (Boolean)state.m_61143_((Property)RIGHT);
            boolean left = (Boolean)state.m_61143_((Property)LEFT);
            Direction block_facing = (Direction)state.m_61143_((Property)HORIZONTAL_FACING);
            Optional sorting_diversion = left || right || !front && !up ? Optional.empty() : this.itemFrameDiversion(world, pos, entity2.m_32055_());
            Vec3 motion = Vec3.m_82528_((Vec3i)block_facing.m_122436_());
            if (sorting_diversion.isPresent() && (sorting_direction = (Direction)sorting_diversion.get()) != block_facing && sorting_direction != block_facing.m_122424_() && sorting_direction != Direction.UP) {
                if (sorting_direction == Direction.DOWN) {
                    if (!world.m_5776_() && this.tryInsertItemEntity(world, pos, Direction.DOWN, entity2)) {
                        entity2.m_20256_(entity2.m_20184_().m_82490_(0.7));
                        return;
                    }
                } else {
                    motion = Vec3.m_82528_((Vec3i)sorting_direction.m_122436_());
                    right = false;
                    left = false;
                    outgoing = true;
                }
            }
            if (right) {
                Direction dir2;
                Direction facing_right = block_facing.m_122427_();
                BlockState right_state = world.m_8055_(pos.m_142300_(facing_right));
                if (right_state.m_60713_((Block)this) && (dir2 = (Direction)right_state.m_61143_((Property)HORIZONTAL_FACING)) == facing_right) {
                    motion = Vec3.m_82528_((Vec3i)facing_right.m_122436_());
                    outgoing = true;
                }
            } else if (left && (left_state = world.m_8055_(pos.m_142300_(facing_left = block_facing.m_122428_()))).m_60713_((Block)this) && (dir = (Direction)left_state.m_61143_((Property)HORIZONTAL_FACING)) == facing_left) {
                motion = Vec3.m_82528_((Vec3i)facing_left.m_122436_());
                outgoing = true;
            }
            if (!(outgoing || front || up)) {
                motion = motion.m_82490_(0.0);
            } else {
                if (!outgoing) {
                    Vec3 centering_motion = new Vec3(block_facing.m_122434_() == Direction.Axis.X ? 0.0 : -0.2 * Math.signum(dp.f_82479_), 0.0, block_facing.m_122434_() == Direction.Axis.Z ? 0.0 : -0.1 * Math.signum(dp.f_82481_));
                    if (up) {
                        centering_motion.m_82490_(2.0);
                    }
                    motion = motion.m_82549_(centering_motion);
                }
                BlockState ahead_state = world.m_8055_(pos.m_142300_(block_facing));
                if (!outgoing && ahead_state.m_60713_((Block)this)) {
                    Direction dir3 = (Direction)ahead_state.m_61143_((Property)HORIZONTAL_FACING);
                    if (dir3 == block_facing) {
                        motion = motion.m_82490_(2.0);
                    } else if (dir3 == block_facing.m_122424_()) {
                        motion = motion.m_82490_(0.5);
                    } else if (((Boolean)ahead_state.m_61143_((Property)UP)).booleanValue()) {
                        motion = motion.m_82490_(2.0);
                    }
                }
                double progress = dp.m_82507_(block_facing.m_122434_()) * Vec3.m_82528_((Vec3i)block_facing.m_122436_()).m_82507_(block_facing.m_122434_());
                double y_speed = -0.1 * Math.min(dp.f_82480_, 0.5);
                if (!up) {
                    if (progress > 0.7 && front) {
                        check_insertion_front = true;
                    }
                } else {
                    if (front && dp.f_82480_ < 0.3 && progress < 0.6) {
                        y_speed = 0.08;
                    } else if (progress > 0.7 && world.m_8055_(pos.m_7494_().m_142300_(block_facing)).m_60713_((Block)this)) {
                        motion = motion.m_82490_(1.2);
                        y_speed = 0.14;
                    } else {
                        y_speed = 0.1;
                    }
                    if (dp.f_82480_ >= 0.4 && !world.m_8055_(pos.m_7494_()).m_60713_((Block)this)) {
                        check_insertion_up = true;
                    }
                }
                if (motion.f_82480_ < -0.1) {
                    motion = new Vec3(motion.f_82479_, -0.1, motion.f_82481_);
                }
                motion = motion.m_82490_(speed).m_82520_(0.0, y_speed, 0.0);
            }
            if ((check_insertion_front || check_insertion_up) && !world.m_5776_() && !entity2.m_32055_().m_41619_()) {
                Direction insertion_facing = check_insertion_up ? Direction.UP : block_facing;
                this.tryInsertItemEntity(world, pos, insertion_facing, entity2);
            }
            if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
                motion.m_82520_(0.0, -0.1, 0.0);
            }
            motion = entity2.m_20184_().m_82490_(0.5).m_82549_(motion);
            entity2.m_20256_(motion);
        }

        public void itchEntity(BlockState state, Level world, BlockPos pos, Entity entity) {
            if (world.m_5822_().nextDouble() > 0.008 || !entity.m_6084_() || !entity.m_20096_() || world.m_5776_() || entity.m_6144_() || !entity.m_6072_() || entity.m_20070_() || entity.f_19812_ || !(entity instanceof LivingEntity)) {
                return;
            }
            if (entity instanceof Monster) {
                entity.m_6469_(DamageSource.f_19314_, 2.0f);
            } else if (entity instanceof Player) {
                if (world.m_5822_().nextDouble() > 0.1) {
                    return;
                }
                entity.m_6469_(DamageSource.f_19314_, 0.1f);
            } else {
                entity.m_6469_(DamageSource.f_19314_, 0.0f);
                if (entity instanceof Villager) {
                    ((Villager)entity).m_6274_().m_21889_(Activity.f_37984_);
                } else if (entity instanceof Animal) {
                    ((Animal)entity).m_6274_().m_21889_(Activity.f_37984_);
                }
            }
        }

        private Optional<Direction> itemFrameDiversion(Level world, BlockPos pos, ItemStack match_stack) {
            List frames = world.m_45976_(ItemFrame.class, new AABB(pos));
            if (frames.isEmpty()) {
                return Optional.empty();
            }
            for (ItemFrame frame : frames) {
                if (!frame.m_31822_().m_41726_(match_stack)) continue;
                return Optional.of(frame.m_6350_());
            }
            return Optional.empty();
        }

        private boolean tryInsertItemEntity(Level world, BlockPos pos, Direction insertion_facing, ItemEntity entity) {
            IItemHandler ih = Inventories.itemhandler(world, pos.m_142300_(insertion_facing), insertion_facing.m_122424_());
            if (ih == null) {
                return false;
            }
            ItemStack stack = entity.m_32055_().m_41777_();
            ItemStack remaining = Inventories.insert(ih, stack, false);
            if (remaining.m_41613_() >= stack.m_41613_()) {
                return false;
            }
            if (stack.m_41619_()) {
                entity.m_142687_(Entity.RemovalReason.DISCARDED);
                return true;
            }
            entity.m_32045_(remaining);
            return false;
        }
    }
}

