/*
 * Decompiled with CFR 0.152.
 */
package wile.anthillinside.libmc.detail;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.IForgeShearable;

public class ToolActions {
    public static boolean shearEntity(LivingEntity entity) {
        LivingEntity livingEntity;
        if (entity.f_19853_.m_5776_() || !((livingEntity = entity) instanceof IForgeShearable)) {
            return false;
        }
        IForgeShearable target = (IForgeShearable)livingEntity;
        BlockPos pos = new BlockPos((Vec3i)entity.m_142538_());
        ItemStack tool = new ItemStack((ItemLike)Items.f_42574_);
        if (target.isShearable(tool, entity.f_19853_, pos)) {
            List drops = target.onSheared(null, tool, entity.f_19853_, pos, 1);
            Random rand = new Random();
            drops.forEach(d -> {
                ItemEntity ent = entity.m_5552_(d, 1.0f);
                if (ent == null) {
                    return;
                }
                ent.m_20256_(ent.m_20184_().m_82520_((double)((rand.nextFloat() - rand.nextFloat()) * 0.05f), (double)(rand.nextFloat() * 0.05f), (double)((rand.nextFloat() - rand.nextFloat()) * 0.05f)));
            });
            entity.f_19853_.m_5594_(null, pos, SoundEvents.f_12344_, SoundSource.BLOCKS, 0.8f, 1.1f);
        }
        return true;
    }

    public static boolean shearEntities(Level world, AABB range, int max_count) {
        if (max_count <= 0) {
            return false;
        }
        List entities = world.m_6443_(LivingEntity.class, range, e -> e instanceof IForgeShearable);
        boolean snipped = false;
        for (LivingEntity e2 : entities) {
            if (!ToolActions.shearEntity(e2)) continue;
            snipped = true;
            if (--max_count != 0) continue;
            break;
        }
        return snipped;
    }

    public static boolean shearPlant(Level world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        if (!state.m_60620_((Tag)BlockTags.f_13035_) && block != Blocks.f_50033_ && block != Blocks.f_50034_ & block != Blocks.f_50359_ && block != Blocks.f_50035_ && block != Blocks.f_50036_ && block != Blocks.f_50191_ && block != Blocks.f_50267_ && !state.m_60620_((Tag)BlockTags.f_13089_)) {
            return false;
        }
        ItemEntity ie = new ItemEntity(world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, new ItemStack((ItemLike)block.m_5456_()));
        ie.m_32060_();
        world.m_7967_((Entity)ie);
        world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 11);
        if (!world.m_5776_()) {
            world.m_5594_(null, pos, SoundEvents.f_12344_, SoundSource.BLOCKS, 0.8f, 1.1f);
        }
        return true;
    }

    public static Optional<List<ItemStack>> harvestCrop(ServerLevel world, BlockPos pos, boolean try_replant, ItemStack bone_meal) {
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        Block block2 = block;
        if (!(block2 instanceof CropBlock)) {
            return Optional.empty();
        }
        CropBlock crop = (CropBlock)block2;
        if (!crop.m_52307_(state)) {
            if (!bone_meal.m_41619_() && crop.m_5491_((Level)world, world.m_5822_(), pos, state)) {
                bone_meal.m_41774_(1);
                crop.m_7719_(world, world.m_5822_(), pos, state);
            }
            return Optional.of(Collections.emptyList());
        }
        List drops = state.m_60724_(new LootContext.Builder(world).m_78972_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)pos)).m_78972_(LootContextParams.f_81461_, (Object)state).m_78984_(LootContextParams.f_81462_, (Object)world.m_7702_(pos)).m_78984_(LootContextParams.f_81455_, null).m_78972_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_));
        if (!try_replant) {
            world.m_7471_(pos, false);
        } else {
            ItemStack seed = crop.m_7397_((BlockGetter)world, pos, state);
            if (!seed.m_41619_()) {
                boolean fetched_seed = false;
                for (ItemStack stack : drops) {
                    if (!stack.m_41656_(seed)) continue;
                    stack.m_41774_(1);
                    fetched_seed = true;
                    break;
                }
                if (fetched_seed) {
                    int init_val = (Integer)crop.m_49966_().m_61143_((Property)crop.m_7959_());
                    world.m_7731_(pos, crop.m_52289_(init_val), 3);
                }
            }
        }
        return Optional.of(drops);
    }
}

