/*
 * Decompiled with CFR 0.152.
 */
package dev.sapphic.armorsoundtweak;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemElytra;
import net.minecraft.item.ItemSkull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@Config(modid="armorsoundtweak", category="")
@Mod(modid="armorsoundtweak", useMetadata=true, clientSideOnly=true, acceptedMinecraftVersions="[1.10,1.13)")
public final class ArmorSoundTweak {
    @Config.Ignore
    public static final String MOD_ID = "armorsoundtweak";
    public static final Sounds SOUNDS = new Sounds();
    private final Minecraft client = Minecraft.func_71410_x();
    private List<SubItem> oldEquipment = Collections.emptyList();
    private @MonotonicNonNull SoundEvent elytraEquipSound;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        ResourceLocation id = new ResourceLocation("item.armor.equip_elytra");
        @Nullable SoundEvent sound = (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)id);
        this.elytraEquipSound = sound != null ? sound : SoundEvents.field_187719_p;
    }

    @SubscribeEvent
    public void configChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (MOD_ID.equals(event.getModID())) {
            ConfigManager.sync((String)MOD_ID, (Config.Type)Config.Type.INSTANCE);
        }
    }

    @SubscribeEvent
    public void tick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START && this.client.field_71439_g != null && this.client.field_71439_g.field_70170_p != null && this.client.field_71439_g.field_70170_p.field_72995_K) {
            ArrayList<SubItem> equipment = new ArrayList<SubItem>(4);
            for (ItemStack stack : this.client.field_71439_g.func_184193_aE()) {
                equipment.add(stack != null ? new SubItem(stack) : SubItem.EMPTY);
            }
            if (this.client.field_71462_r instanceof GuiContainer) {
                Iterator newEquipment = equipment.iterator();
                Iterator<SubItem> oldEquipment = this.oldEquipment.iterator();
                while (oldEquipment.hasNext() && newEquipment.hasNext()) {
                    SoundEvent sound;
                    SubItem oldItem;
                    SubItem newItem = (SubItem)newEquipment.next();
                    if (newItem.is(oldItem = oldEquipment.next()) || (sound = this.getEquipSound(newItem, oldItem)) == null) continue;
                    this.client.field_71439_g.func_184185_a(sound, 1.0f, 1.0f);
                }
            }
            this.oldEquipment = equipment;
        }
    }

    private @Nullable SoundEvent getEquipSound(SubItem newItem, SubItem oldItem) {
        Item item = (newItem.isEmpty() ? oldItem : newItem).item;
        if (ArmorSoundTweak.SOUNDS.armor && item instanceof ItemArmor) {
            return ((ItemArmor)item).func_82812_d().func_185017_b();
        }
        if (ArmorSoundTweak.SOUNDS.elytra && item instanceof ItemElytra) {
            return this.elytraEquipSound;
        }
        if (ArmorSoundTweak.SOUNDS.pumpkins && Block.func_149634_a((Item)item) == Blocks.field_150423_aK) {
            return SoundEvents.field_187719_p;
        }
        if (ArmorSoundTweak.SOUNDS.anything || ArmorSoundTweak.SOUNDS.skulls && item instanceof ItemSkull) {
            return SoundEvents.field_187719_p;
        }
        return null;
    }

    private static final class SubItem {
        private static final SubItem EMPTY = new SubItem(null, 0);
        private final @Nullable Item item;
        private final int metadata;

        private SubItem(@Nullable Item item, int metadata) {
            this.item = item;
            this.metadata = metadata;
        }

        private SubItem(ItemStack stack) {
            this(stack.func_77973_b(), stack.func_77960_j());
        }

        private boolean isEmpty() {
            return this.item == null;
        }

        private boolean is(SubItem that) {
            return this == that || this.metadata == that.metadata && this.item == that.item;
        }
    }

    public static final class Sounds {
        @Config.Name(value="armor")
        public boolean armor = true;
        @Config.Name(value="elytra")
        public boolean elytra = true;
        @Config.Name(value="skulls")
        public boolean skulls = false;
        @Config.Name(value="pumpkins")
        public boolean pumpkins = false;
        @Config.Name(value="anything")
        public boolean anything = false;

        private Sounds() {
        }
    }
}

