/*
 * Decompiled with CFR 0.152.
 */
package dev.sapphic.armorsoundtweak;

import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigSpec;
import com.electronwill.nightconfig.core.file.FileConfig;
import com.electronwill.nightconfig.core.file.FileWatcher;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1738;
import net.minecraft.class_1747;
import net.minecraft.class_1770;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2190;
import net.minecraft.class_2248;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_465;
import org.checkerframework.checker.nullness.qual.Nullable;

@Environment(value=EnvType.CLIENT)
public final class ArmorSoundTweak
implements ClientModInitializer {
    private final Supplier<Boolean> armor;
    private final Supplier<Boolean> elytra;
    private final Supplier<Boolean> skulls;
    private final Supplier<Boolean> pumpkins;
    private final Supplier<Boolean> anything;
    private List<class_1792> oldEquipment = Collections.emptyList();

    public ArmorSoundTweak() {
        Path file = FabricLoader.getInstance().getConfigDir().resolve("armorsoundtweak.toml");
        FileConfig config = FileConfig.builder((Path)file).autoreload().build();
        ConfigSpec spec = new ConfigSpec();
        spec.define("sounds.armor", (Object)true);
        spec.define("sounds.elytra", (Object)true);
        spec.define("sounds.skulls", (Object)false);
        spec.define("sounds.pumpkins", (Object)false);
        spec.define("sounds.anything", (Object)false);
        try {
            FileWatcher.defaultInstance().addWatch(file, () -> ArmorSoundTweak.correct(config, spec));
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to add config correction watcher", e);
        }
        this.armor = () -> (Boolean)config.getOrElse("sounds.armor", (Object)true);
        this.elytra = () -> (Boolean)config.getOrElse("sounds.elytra", (Object)true);
        this.skulls = () -> (Boolean)config.getOrElse("sounds.skulls", (Object)false);
        this.pumpkins = () -> (Boolean)config.getOrElse("sounds.pumpkins", (Object)false);
        this.anything = () -> (Boolean)config.getOrElse("sounds.anything", (Object)false);
        config.load();
        ArmorSoundTweak.correct(config, spec);
    }

    private static void correct(FileConfig config, ConfigSpec spec) {
        if (!spec.isCorrect((Config)config)) {
            spec.correct((Config)config);
        }
        config.save();
    }

    private static boolean isSkull(class_1792 item) {
        if (item instanceof class_1747) {
            class_2248 block = ((class_1747)item).method_7711();
            return block instanceof class_2190;
        }
        return false;
    }

    public void onInitializeClient() {
        ClientTickEvents.START_CLIENT_TICK.register(client -> {
            if (client.field_1724 != null && client.field_1724.field_6002 != null && client.field_1724.field_6002.field_9236) {
                ArrayList<class_1792> equipment = new ArrayList<class_1792>(4);
                for (class_1799 stack : client.field_1724.method_5661()) {
                    equipment.add(stack.method_7909());
                }
                if (client.field_1755 instanceof class_465) {
                    Iterator newEquipment = equipment.iterator();
                    Iterator<class_1792> oldEquipment = this.oldEquipment.iterator();
                    while (oldEquipment.hasNext() && newEquipment.hasNext()) {
                        class_3414 sound;
                        class_1792 oldItem;
                        class_1792 newItem = (class_1792)newEquipment.next();
                        if (newItem == (oldItem = oldEquipment.next()) || (sound = this.getEquipSound(newItem, oldItem)) == null) continue;
                        client.field_1724.method_17356(sound, class_3419.field_15254, 1.0f, 1.0f);
                    }
                }
                this.oldEquipment = equipment;
            }
        });
    }

    private @Nullable class_3414 getEquipSound(class_1792 newItem, class_1792 oldItem) {
        class_1792 item;
        class_1792 class_17922 = item = newItem == class_1802.field_8162 ? oldItem : newItem;
        if (this.armor.get().booleanValue() && item instanceof class_1738) {
            return ((class_1738)item).method_7686().method_7698();
        }
        if (this.elytra.get().booleanValue() && item instanceof class_1770) {
            return class_3417.field_14966;
        }
        if (this.pumpkins.get().booleanValue() && item == class_1802.field_17519) {
            return class_3417.field_14883;
        }
        if (this.anything.get().booleanValue() || this.skulls.get().booleanValue() && ArmorSoundTweak.isSkull(item)) {
            return class_3417.field_14883;
        }
        return null;
    }
}

