/*
 * Decompiled with CFR 0.152.
 */
package dev.sapphic.armorsoundtweak;

import dev.sapphic.armorsoundtweak.ArmorSoundTweak;
import dev.sapphic.armorsoundtweak.EquipmentConfig;
import dev.sapphic.armorsoundtweak.EquipmentTicker;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.block.AbstractSkullBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ElytraItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.common.MinecraftForge;
import org.checkerframework.checker.nullness.qual.Nullable;

final class ArmorTicker
extends EquipmentTicker {
    private final EquipmentConfig.Sounds sounds = ArmorSoundTweak.config().sounds();

    ArmorTicker() {
    }

    static void register() {
        MinecraftForge.EVENT_BUS.addListener((Consumer)new ArmorTicker());
    }

    private static boolean isSkull(Item item) {
        return item instanceof BlockItem && ((BlockItem)item).func_179223_d() instanceof AbstractSkullBlock;
    }

    @Override
    protected List<Item> getEquipment(PlayerEntity player) {
        ArrayList<Item> equipment = new ArrayList<Item>(4);
        for (ItemStack stack : player.func_184193_aE()) {
            equipment.add(stack.func_77973_b());
        }
        return equipment;
    }

    @Override
    protected void playEquipSound(PlayerEntity player, Item item) {
        if (!ArmorSoundTweak.config().allowsArmor()) {
            return;
        }
        @Nullable SoundEvent sound = this.getEquipSound(item);
        if (sound != null) {
            player.func_213823_a(sound, SoundCategory.NEUTRAL, 1.0f, 1.0f);
        }
    }

    private @Nullable SoundEvent getEquipSound(Item item) {
        if (this.sounds.hasArmor() && item instanceof ArmorItem) {
            return ((ArmorItem)item).func_200880_d().func_200899_b();
        }
        if (this.sounds.hasElytra() && item instanceof ElytraItem) {
            return SoundEvents.field_191258_p;
        }
        if (this.sounds.hasPumpkins() && item == Items.field_221689_cG) {
            return SoundEvents.field_187719_p;
        }
        if (this.sounds.hasSkulls() && ArmorTicker.isSkull(item)) {
            return SoundEvents.field_187719_p;
        }
        if (this.sounds.hasAnything()) {
            return SoundEvents.field_187719_p;
        }
        return null;
    }
}

